/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search.matcher;

import java.io.InputStream;
import java.util.Collection;
import java.util.HashSet;
import org.netbeans.api.search.SearchPattern;
import org.netbeans.api.search.provider.SearchListener;
import org.netbeans.modules.search.MatchingObject;
import org.netbeans.modules.search.TextRegexpUtil;
import org.netbeans.modules.search.matcher.AbstractMatcher;
import org.netbeans.modules.search.matcher.MatcherUtils;
import org.netbeans.modules.search.matcher.MultiLineStreamMatcher;
import org.netbeans.modules.search.matcher.SingleLineStreamMatcher;
import org.netbeans.modules.search.matcher.TrivialFileMatcher;
import org.openide.filesystems.FileObject;

public class DefaultMatcher
extends AbstractMatcher {
    private static final int MAX_UNRECOGNIZED_FILE_SIZE = 0x500000;
    private static final Collection<String> searchableXMimeTypes = new HashSet<String>(17);
    private static final Collection<String> searchableExtensions;
    private AbstractMatcher realMatcher;
    private boolean trivial;

    public DefaultMatcher(SearchPattern searchPattern) {
        boolean bl;
        this.trivial = MatcherUtils.isTrivialPattern(searchPattern);
        this.realMatcher = this.trivial ? new TrivialFileMatcher() : ((bl = TextRegexpUtil.canBeMultilinePattern(searchPattern.getSearchExpression())) ? new MultiLineStreamMatcher(searchPattern) : new SingleLineStreamMatcher(searchPattern));
    }

    @Override
    public MatchingObject.Def checkMeasuredInternal(FileObject fileObject, SearchListener searchListener) {
        if (this.trivial) {
            return this.realMatcher.check(fileObject, searchListener);
        }
        if (DefaultMatcher.isTextFile(fileObject)) {
            try {
                return this.realMatcher.check(fileObject, searchListener);
            }
            catch (Exception exception) {
                searchListener.fileContentMatchingError(fileObject.getPath(), exception);
                return null;
            }
        }
        searchListener.fileSkipped(fileObject, null, "Not a text file");
        return null;
    }

    @Override
    public synchronized void terminate() {
        this.realMatcher.terminate();
    }

    private static boolean isTextFile(FileObject fileObject) {
        String string = fileObject.getMIMEType();
        if (string.equals("content/unknown")) {
            if (searchableExtensions.contains(fileObject.getExt().toLowerCase())) {
                return true;
            }
            return fileObject.getSize() <= 0x500000L || DefaultMatcher.hasTextContent(fileObject);
        }
        if (string.startsWith("text/")) {
            return true;
        }
        if (string.startsWith("application/")) {
            String string2 = string.substring(12);
            return string2.equals("rtf") || string2.equals("sgml") || string2.startsWith("xml-") || string2.endsWith("+xml") || DefaultMatcher.isApplicationXSource(string2, fileObject);
        }
        return string.endsWith("+xml");
    }

    private static boolean isApplicationXSource(String string, FileObject fileObject) {
        return string.startsWith("x-") && (searchableXMimeTypes.contains(string.substring(2)) || DefaultMatcher.hasTextContent(fileObject));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static boolean hasTextContent(FileObject fileObject) {
        byte[] byArray = new byte[1024];
        byte by = -2;
        byte by2 = -1;
        byte by3 = 0;
        byte by4 = -17;
        byte by5 = -65;
        byte by6 = -69;
        try {
            InputStream inputStream = fileObject.getInputStream();
            try {
                int n;
                int n2 = inputStream.read(byArray);
                if (n2 > 2 && byArray[0] == by4 && byArray[1] == by6 && byArray[2] == by5) {
                    boolean bl = true;
                    return bl;
                }
                if (n2 > 1 && (byArray[0] == by2 && byArray[1] == by || byArray[0] == by && byArray[1] == by2)) {
                    boolean bl = true;
                    return bl;
                }
                if (n2 > 3 && (byArray[0] == by3 && byArray[1] == by3 && byArray[2] == by && byArray[3] == by2 || byArray[0] == by2 && byArray[1] == by && byArray[2] == by3 && byArray[3] == by3)) {
                    boolean bl = true;
                    return bl;
                }
                for (n = 0; n < n2; ++n) {
                    if (byArray[n] != by3) continue;
                    boolean bl = false;
                    return bl;
                }
                n = 1;
                return n != 0;
            }
            finally {
                inputStream.close();
            }
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public void setStrict(boolean bl) {
        super.setStrict(bl);
        this.realMatcher.setStrict(bl);
    }

    static {
        searchableXMimeTypes.add("csh");
        searchableXMimeTypes.add("httpd-eruby");
        searchableXMimeTypes.add("httpd-php");
        searchableXMimeTypes.add("httpd-php-source");
        searchableXMimeTypes.add("javascript");
        searchableXMimeTypes.add("latex");
        searchableXMimeTypes.add("php");
        searchableXMimeTypes.add("sh");
        searchableXMimeTypes.add("tcl");
        searchableXMimeTypes.add("tex");
        searchableXMimeTypes.add("texinfo");
        searchableXMimeTypes.add("troff");
        searchableExtensions = new HashSet<String>();
        searchableExtensions.add("txt");
        searchableExtensions.add("log");
    }
}

