/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.TextAttribute;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.text.AttributedCharacterIterator;
import java.util.HashSet;
import java.util.Set;
import org.apache.batik.bridge.TextHit;
import org.apache.batik.bridge.TextSpanLayout;
import org.apache.batik.gvt.font.AWTGVTFont;
import org.apache.batik.gvt.font.AltGlyphHandler;
import org.apache.batik.gvt.font.GVTFont;
import org.apache.batik.gvt.font.GVTGlyphMetrics;
import org.apache.batik.gvt.font.GVTGlyphVector;
import org.apache.batik.gvt.font.GVTLineMetrics;
import org.apache.batik.gvt.text.ArabicTextHandler;
import org.apache.batik.gvt.text.GVTAttributedCharacterIterator;
import org.apache.batik.gvt.text.TextPath;

public class GlyphLayout
implements TextSpanLayout {
    protected GVTGlyphVector gv;
    private GVTFont font;
    private GVTLineMetrics metrics;
    private AttributedCharacterIterator aci;
    protected Point2D advance;
    private Point2D offset;
    private float xScale = 1.0f;
    private float yScale = 1.0f;
    private TextPath textPath;
    private Point2D textPathAdvance;
    private int[] charMap;
    private boolean vertical;
    private boolean adjSpacing = true;
    private float[] glyphAdvances;
    private boolean isAltGlyph;
    protected boolean layoutApplied = false;
    private boolean spacingApplied = false;
    private boolean pathApplied = false;
    public static final AttributedCharacterIterator.Attribute FLOW_LINE_BREAK = GVTAttributedCharacterIterator.TextAttribute.FLOW_LINE_BREAK;
    public static final AttributedCharacterIterator.Attribute FLOW_PARAGRAPH = GVTAttributedCharacterIterator.TextAttribute.FLOW_PARAGRAPH;
    public static final AttributedCharacterIterator.Attribute FLOW_EMPTY_PARAGRAPH = GVTAttributedCharacterIterator.TextAttribute.FLOW_EMPTY_PARAGRAPH;
    public static final AttributedCharacterIterator.Attribute LINE_HEIGHT = GVTAttributedCharacterIterator.TextAttribute.LINE_HEIGHT;
    public static final AttributedCharacterIterator.Attribute VERTICAL_ORIENTATION = GVTAttributedCharacterIterator.TextAttribute.VERTICAL_ORIENTATION;
    public static final AttributedCharacterIterator.Attribute VERTICAL_ORIENTATION_ANGLE = GVTAttributedCharacterIterator.TextAttribute.VERTICAL_ORIENTATION_ANGLE;
    public static final AttributedCharacterIterator.Attribute HORIZONTAL_ORIENTATION_ANGLE = GVTAttributedCharacterIterator.TextAttribute.HORIZONTAL_ORIENTATION_ANGLE;
    private static final AttributedCharacterIterator.Attribute X = GVTAttributedCharacterIterator.TextAttribute.X;
    private static final AttributedCharacterIterator.Attribute Y = GVTAttributedCharacterIterator.TextAttribute.Y;
    private static final AttributedCharacterIterator.Attribute DX = GVTAttributedCharacterIterator.TextAttribute.DX;
    private static final AttributedCharacterIterator.Attribute DY = GVTAttributedCharacterIterator.TextAttribute.DY;
    private static final AttributedCharacterIterator.Attribute ROTATION = GVTAttributedCharacterIterator.TextAttribute.ROTATION;
    private static final AttributedCharacterIterator.Attribute BASELINE_SHIFT = GVTAttributedCharacterIterator.TextAttribute.BASELINE_SHIFT;
    private static final AttributedCharacterIterator.Attribute WRITING_MODE = GVTAttributedCharacterIterator.TextAttribute.WRITING_MODE;
    private static final Integer WRITING_MODE_TTB = GVTAttributedCharacterIterator.TextAttribute.WRITING_MODE_TTB;
    private static final Integer ORIENTATION_AUTO = GVTAttributedCharacterIterator.TextAttribute.ORIENTATION_AUTO;
    public static final AttributedCharacterIterator.Attribute GVT_FONT = GVTAttributedCharacterIterator.TextAttribute.GVT_FONT;
    protected static Set runAtts = new HashSet();
    protected static Set szAtts;
    public static final double eps = 1.0E-5;

    public GlyphLayout(AttributedCharacterIterator attributedCharacterIterator, int[] nArray, Point2D point2D, FontRenderContext fontRenderContext) {
        this.aci = attributedCharacterIterator;
        this.offset = point2D;
        this.font = this.getFont();
        this.charMap = nArray;
        this.metrics = this.font.getLineMetrics(attributedCharacterIterator, attributedCharacterIterator.getBeginIndex(), attributedCharacterIterator.getEndIndex(), fontRenderContext);
        this.gv = null;
        this.aci.first();
        this.vertical = attributedCharacterIterator.getAttribute(WRITING_MODE) == WRITING_MODE_TTB;
        this.textPath = (TextPath)attributedCharacterIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.TEXTPATH);
        AltGlyphHandler altGlyphHandler = (AltGlyphHandler)this.aci.getAttribute(GVTAttributedCharacterIterator.TextAttribute.ALT_GLYPH_HANDLER);
        if (altGlyphHandler != null) {
            this.gv = altGlyphHandler.createGlyphVector(fontRenderContext, this.font.getSize(), this.aci);
            if (this.gv != null) {
                this.isAltGlyph = true;
            }
        }
        if (this.gv == null) {
            this.gv = this.font.createGlyphVector(fontRenderContext, this.aci);
        }
    }

    @Override
    public GVTGlyphVector getGlyphVector() {
        return this.gv;
    }

    @Override
    public Point2D getOffset() {
        return this.offset;
    }

    @Override
    public void setScale(float f, float f2, boolean bl) {
        if (this.vertical) {
            f = 1.0f;
        } else {
            f2 = 1.0f;
        }
        if (f != this.xScale || f2 != this.yScale || bl != this.adjSpacing) {
            this.xScale = f;
            this.yScale = f2;
            this.adjSpacing = bl;
            this.spacingApplied = false;
            this.glyphAdvances = null;
            this.pathApplied = false;
        }
    }

    @Override
    public void setOffset(Point2D point2D) {
        if (point2D.getX() != this.offset.getX() || point2D.getY() != this.offset.getY()) {
            if (this.layoutApplied || this.spacingApplied) {
                float f = (float)(point2D.getX() - this.offset.getX());
                float f2 = (float)(point2D.getY() - this.offset.getY());
                int n = this.gv.getNumGlyphs();
                float[] fArray = this.gv.getGlyphPositions(0, n + 1, null);
                Point2D.Float float_ = new Point2D.Float();
                for (int i = 0; i <= n; ++i) {
                    float_.x = fArray[2 * i] + f;
                    float_.y = fArray[2 * i + 1] + f2;
                    this.gv.setGlyphPosition(i, float_);
                }
            }
            this.offset = point2D;
            this.pathApplied = false;
        }
    }

    @Override
    public GVTGlyphMetrics getGlyphMetrics(int n) {
        return this.gv.getGlyphMetrics(n);
    }

    @Override
    public GVTLineMetrics getLineMetrics() {
        return this.metrics;
    }

    @Override
    public boolean isVertical() {
        return this.vertical;
    }

    @Override
    public boolean isOnATextPath() {
        return this.textPath != null;
    }

    @Override
    public int getGlyphCount() {
        return this.gv.getNumGlyphs();
    }

    @Override
    public int getCharacterCount(int n, int n2) {
        return this.gv.getCharacterCount(n, n2);
    }

    @Override
    public boolean isLeftToRight() {
        this.aci.first();
        int n = (Integer)this.aci.getAttribute(GVTAttributedCharacterIterator.TextAttribute.BIDI_LEVEL);
        return (n & 1) == 0;
    }

    private final void syncLayout() {
        if (!this.pathApplied) {
            this.doPathLayout();
        }
    }

    @Override
    public void draw(Graphics2D graphics2D) {
        this.syncLayout();
        this.gv.draw(graphics2D, this.aci);
    }

    @Override
    public Point2D getAdvance2D() {
        this.adjustTextSpacing();
        return this.advance;
    }

    @Override
    public Shape getOutline() {
        this.syncLayout();
        return this.gv.getOutline();
    }

    @Override
    public float[] getGlyphAdvances() {
        if (this.glyphAdvances != null) {
            return this.glyphAdvances;
        }
        if (!this.spacingApplied) {
            this.adjustTextSpacing();
        }
        int n = this.gv.getNumGlyphs();
        float[] fArray = this.gv.getGlyphPositions(0, n + 1, null);
        this.glyphAdvances = new float[n + 1];
        int n2 = 0;
        if (this.isVertical()) {
            n2 = 1;
        }
        float f = fArray[n2];
        for (int i = 0; i < n + 1; ++i) {
            this.glyphAdvances[i] = fArray[2 * i + n2] - f;
        }
        return this.glyphAdvances;
    }

    @Override
    public Shape getDecorationOutline(int n) {
        this.syncLayout();
        GeneralPath generalPath = new GeneralPath();
        if ((n & 1) != 0) {
            generalPath.append(this.getUnderlineShape(), false);
        }
        if ((n & 2) != 0) {
            generalPath.append(this.getStrikethroughShape(), false);
        }
        if ((n & 4) != 0) {
            generalPath.append(this.getOverlineShape(), false);
        }
        return generalPath;
    }

    @Override
    public Rectangle2D getBounds2D() {
        this.syncLayout();
        return this.gv.getBounds2D(this.aci);
    }

    @Override
    public Rectangle2D getGeometricBounds() {
        this.syncLayout();
        Rectangle2D rectangle2D = this.gv.getGeometricBounds();
        Rectangle2D rectangle2D2 = this.getDecorationOutline(7).getBounds2D();
        return rectangle2D.createUnion(rectangle2D2);
    }

    @Override
    public Point2D getTextPathAdvance() {
        this.syncLayout();
        if (this.textPath != null) {
            return this.textPathAdvance;
        }
        return this.getAdvance2D();
    }

    @Override
    public int getGlyphIndex(int n) {
        int n2 = this.getGlyphCount();
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            int n4 = this.getCharacterCount(i, i);
            for (int j = 0; j < n4; ++j) {
                int n5;
                if (n == (n5 = this.charMap[n3++])) {
                    return i;
                }
                if (n3 < this.charMap.length) continue;
                return -1;
            }
        }
        return -1;
    }

    public int getLastGlyphIndex(int n) {
        int n2 = this.getGlyphCount();
        int n3 = this.charMap.length - 1;
        for (int i = n2 - 1; i >= 0; --i) {
            int n4 = this.getCharacterCount(i, i);
            for (int j = 0; j < n4; ++j) {
                int n5;
                if (n == (n5 = this.charMap[n3--])) {
                    return i;
                }
                if (n3 >= 0) continue;
                return -1;
            }
        }
        return -1;
    }

    @Override
    public double getComputedOrientationAngle(int n) {
        if (this.isGlyphOrientationAuto()) {
            if (this.isVertical()) {
                char c = this.aci.setIndex(n);
                if (this.isLatinChar(c)) {
                    return 90.0;
                }
                return 0.0;
            }
            return 0.0;
        }
        return this.getGlyphOrientationAngle();
    }

    @Override
    public Shape getHighlightShape(int n, int n2) {
        this.syncLayout();
        if (n > n2) {
            int n3 = n;
            n = n2;
            n2 = n3;
        }
        GeneralPath generalPath = null;
        int n4 = this.getGlyphCount();
        Point2D.Float[] floatArray = new Point2D.Float[2 * n4];
        Point2D.Float[] floatArray2 = new Point2D.Float[2 * n4];
        int n5 = 0;
        int n6 = 0;
        for (int i = 0; i < n4; ++i) {
            Shape shape;
            int n7 = this.charMap[n6];
            if (n7 >= n && n7 <= n2 && this.gv.isGlyphVisible(i) && (shape = this.gv.getGlyphLogicalBounds(i)) != null) {
                if (generalPath == null) {
                    generalPath = new GeneralPath();
                }
                float[] fArray = new float[6];
                int n8 = 0;
                int n9 = -1;
                PathIterator pathIterator = shape.getPathIterator(null);
                Point2D.Float float_ = null;
                while (!pathIterator.isDone()) {
                    n9 = pathIterator.currentSegment(fArray);
                    if (n9 == 0 || n9 == 1) {
                        if (n8 > 4) break;
                        if (n8 == 4) {
                            if (float_ == null || float_.x != fArray[0] || float_.y != fArray[1]) {
                                break;
                            }
                        } else {
                            Point2D.Float float_2 = new Point2D.Float(fArray[0], fArray[1]);
                            if (n8 == 0) {
                                float_ = float_2;
                            }
                            switch (n8) {
                                case 0: {
                                    floatArray2[n5] = float_2;
                                    break;
                                }
                                case 1: {
                                    floatArray[n5] = float_2;
                                    break;
                                }
                                case 2: {
                                    floatArray[n5 + 1] = float_2;
                                    break;
                                }
                                case 3: {
                                    floatArray2[n5 + 1] = float_2;
                                }
                            }
                        }
                    } else if (n9 != 4 || n8 < 4 || n8 > 5) break;
                    ++n8;
                    pathIterator.next();
                }
                if (pathIterator.isDone()) {
                    if (floatArray2[n5] != null && (floatArray[n5].x != floatArray[n5 + 1].x || floatArray[n5].y != floatArray[n5 + 1].y)) {
                        n5 += 2;
                    }
                } else {
                    GlyphLayout.addPtsToPath(generalPath, floatArray, floatArray2, n5);
                    n5 = 0;
                    generalPath.append(shape, false);
                }
            }
            if ((n6 += this.getCharacterCount(i, i)) < this.charMap.length) continue;
            n6 = this.charMap.length - 1;
        }
        GlyphLayout.addPtsToPath(generalPath, floatArray, floatArray2, n5);
        return generalPath;
    }

    public static boolean epsEQ(double d, double d2) {
        return d + 1.0E-5 > d2 && d - 1.0E-5 < d2;
    }

    public static int makeConvexHull(Point2D.Float[] floatArray, int n) {
        float f;
        float f2;
        float f3;
        for (int i = 1; i < n; ++i) {
            if (!(floatArray[i].x < floatArray[i - 1].x) && (floatArray[i].x != floatArray[i - 1].x || !(floatArray[i].y < floatArray[i - 1].y))) continue;
            Point2D.Float float_ = floatArray[i];
            floatArray[i] = floatArray[i - 1];
            floatArray[i - 1] = float_;
            i = 0;
        }
        Point2D.Float float_ = floatArray[0];
        Point2D.Float float_2 = floatArray[n - 1];
        Point2D.Float float_3 = new Point2D.Float(float_2.x - float_.x, float_2.y - float_.y);
        float f4 = float_3.y * float_.x - float_3.x * float_.y;
        Point2D.Float[] floatArray2 = new Point2D.Float[n];
        Point2D.Float[] floatArray3 = new Point2D.Float[n];
        floatArray3[0] = floatArray2[0] = floatArray[0];
        int n2 = 1;
        int n3 = 1;
        for (int i = 1; i < n - 1; ++i) {
            float f5;
            Point2D.Float float_4 = floatArray[i];
            f3 = float_3.x * float_4.y - float_3.y * float_4.x + f4;
            if (f3 < 0.0f) {
                while (n3 >= 2) {
                    float_ = floatArray3[n3 - 2];
                    float_2 = floatArray3[n3 - 1];
                    f2 = float_2.x - float_.x;
                    f = float_2.y - float_.y;
                    f5 = f * float_.x - f2 * float_.y;
                    f3 = f2 * float_4.y - f * float_4.x + f5;
                    if ((double)f3 > 1.0E-5) break;
                    if ((double)f3 > -1.0E-5) {
                        if (float_2.y < float_4.y) {
                            float_4 = float_2;
                        }
                        break;
                    }
                    --n3;
                }
                int n4 = --n3;
                ++n3;
                floatArray3[n4] = float_4;
                continue;
            }
            while (n2 >= 2) {
                float_ = floatArray2[n2 - 2];
                float_2 = floatArray2[n2 - 1];
                f2 = float_2.x - float_.x;
                f = float_2.y - float_.y;
                f5 = f * float_.x - f2 * float_.y;
                f3 = f2 * float_4.y - f * float_4.x + f5;
                if ((double)f3 < -1.0E-5) break;
                if ((double)f3 < 1.0E-5) {
                    if (float_2.y > float_4.y) {
                        float_4 = float_2;
                    }
                    break;
                }
                --n2;
            }
            int n5 = --n2;
            ++n2;
            floatArray2[n5] = float_4;
        }
        Point2D.Float float_5 = floatArray[n - 1];
        while (n3 >= 2) {
            float_ = floatArray3[n3 - 2];
            float_2 = floatArray3[n3 - 1];
            float f6 = float_2.x - float_.x;
            f2 = float_2.y - float_.y;
            f = f2 * float_.x - f6 * float_.y;
            f3 = f6 * float_5.y - f2 * float_5.x + f;
            if ((double)f3 > 1.0E-5) break;
            if ((double)f3 > -1.0E-5) {
                if (!(float_2.y >= float_5.y)) break;
                --n3;
                break;
            }
            --n3;
        }
        while (n2 >= 2) {
            float_ = floatArray2[n2 - 2];
            float_2 = floatArray2[n2 - 1];
            float f7 = float_2.x - float_.x;
            f2 = float_2.y - float_.y;
            f = f2 * float_.x - f7 * float_.y;
            f3 = f7 * float_5.y - f2 * float_5.x + f;
            if ((double)f3 < -1.0E-5) break;
            if ((double)f3 < 1.0E-5) {
                if (!(float_2.y <= float_5.y)) break;
                --n2;
                break;
            }
            --n2;
        }
        System.arraycopy(floatArray2, 0, floatArray, 0, n2);
        int n6 = n2;
        floatArray[n6++] = floatArray[n - 1];
        int n7 = n3 - 1;
        while (n7 > 0) {
            floatArray[n6] = floatArray3[n7];
            --n7;
            ++n6;
        }
        return n6;
    }

    public static void addPtsToPath(GeneralPath generalPath, Point2D.Float[] floatArray, Point2D.Float[] floatArray2, int n) {
        if (n < 2) {
            return;
        }
        if (n == 2) {
            generalPath.moveTo(floatArray[0].x, floatArray[0].y);
            generalPath.lineTo(floatArray[1].x, floatArray[1].y);
            generalPath.lineTo(floatArray2[1].x, floatArray2[1].y);
            generalPath.lineTo(floatArray2[0].x, floatArray2[0].y);
            generalPath.lineTo(floatArray[0].x, floatArray[0].y);
            return;
        }
        Point2D.Float[] floatArray3 = new Point2D.Float[8];
        Point2D.Float[] floatArray4 = new Point2D.Float[8];
        floatArray3[4] = floatArray[0];
        floatArray3[5] = floatArray[1];
        floatArray3[6] = floatArray2[1];
        floatArray3[7] = floatArray2[0];
        Area[] areaArray = new Area[n / 2];
        int n2 = 0;
        for (int i = 2; i < n; i += 2) {
            floatArray3[0] = floatArray3[4];
            floatArray3[1] = floatArray3[5];
            floatArray3[2] = floatArray3[6];
            floatArray3[3] = floatArray3[7];
            floatArray3[4] = floatArray[i];
            floatArray3[5] = floatArray[i + 1];
            floatArray3[6] = floatArray2[i + 1];
            floatArray3[7] = floatArray2[i];
            float f = floatArray3[2].x - floatArray3[0].x;
            float f2 = f * f;
            f = floatArray3[2].y - floatArray3[0].y;
            float f3 = (float)Math.sqrt(f2 += f * f);
            f = floatArray3[6].x - floatArray3[4].x;
            f2 = f * f;
            f = floatArray3[6].y - floatArray3[4].y;
            f3 += (float)Math.sqrt(f2 += f * f);
            f = (floatArray3[0].x + floatArray3[1].x + floatArray3[2].x + floatArray3[3].x - (floatArray3[4].x + floatArray3[5].x + floatArray3[6].x + floatArray3[7].x)) / 4.0f;
            f2 = f * f;
            f = (floatArray3[0].y + floatArray3[1].y + floatArray3[2].y + floatArray3[3].y - (floatArray3[4].y + floatArray3[5].y + floatArray3[6].y + floatArray3[7].y)) / 4.0f;
            f2 += f * f;
            f2 = (float)Math.sqrt(f2);
            GeneralPath generalPath2 = new GeneralPath();
            if (f2 < f3) {
                System.arraycopy(floatArray3, 0, floatArray4, 0, 8);
                int n3 = GlyphLayout.makeConvexHull(floatArray4, 8);
                generalPath2.moveTo(floatArray4[0].x, floatArray4[0].y);
                for (int j = 1; j < n3; ++j) {
                    generalPath2.lineTo(floatArray4[j].x, floatArray4[j].y);
                }
                generalPath2.closePath();
            } else {
                GlyphLayout.mergeAreas(generalPath, areaArray, n2);
                n2 = 0;
                if (i == 2) {
                    generalPath2.moveTo(floatArray3[0].x, floatArray3[0].y);
                    generalPath2.lineTo(floatArray3[1].x, floatArray3[1].y);
                    generalPath2.lineTo(floatArray3[2].x, floatArray3[2].y);
                    generalPath2.lineTo(floatArray3[3].x, floatArray3[3].y);
                    generalPath2.closePath();
                    generalPath.append(generalPath2, false);
                    generalPath2.reset();
                }
                generalPath2.moveTo(floatArray3[4].x, floatArray3[4].y);
                generalPath2.lineTo(floatArray3[5].x, floatArray3[5].y);
                generalPath2.lineTo(floatArray3[6].x, floatArray3[6].y);
                generalPath2.lineTo(floatArray3[7].x, floatArray3[7].y);
                generalPath2.closePath();
            }
            areaArray[n2++] = new Area(generalPath2);
        }
        GlyphLayout.mergeAreas(generalPath, areaArray, n2);
    }

    public static void mergeAreas(GeneralPath generalPath, Area[] areaArray, int n) {
        while (n > 1) {
            int n2 = 0;
            for (int i = 1; i < n; i += 2) {
                areaArray[i - 1].add(areaArray[i]);
                areaArray[n2++] = areaArray[i - 1];
                areaArray[i] = null;
            }
            if ((n & 1) == 1) {
                areaArray[n2 - 1].add(areaArray[n - 1]);
            }
            n /= 2;
        }
        if (n == 1) {
            generalPath.append(areaArray[0], false);
        }
    }

    @Override
    public TextHit hitTestChar(float f, float f2) {
        this.syncLayout();
        TextHit textHit = null;
        int n = 0;
        for (int i = 0; i < this.gv.getNumGlyphs(); ++i) {
            Shape shape = this.gv.getGlyphLogicalBounds(i);
            if (shape != null) {
                Rectangle2D rectangle2D = shape.getBounds2D();
                if (shape.contains(f, f2)) {
                    boolean bl = (double)f > rectangle2D.getX() + rectangle2D.getWidth() / 2.0;
                    boolean bl2 = !bl;
                    int n2 = this.charMap[n];
                    textHit = new TextHit(n2, bl2);
                    return textHit;
                }
            }
            if ((n += this.getCharacterCount(i, i)) < this.charMap.length) continue;
            n = this.charMap.length - 1;
        }
        return textHit;
    }

    protected GVTFont getFont() {
        this.aci.first();
        GVTFont gVTFont = (GVTFont)this.aci.getAttribute(GVT_FONT);
        if (gVTFont != null) {
            return gVTFont;
        }
        return new AWTGVTFont(this.aci.getAttributes());
    }

    protected Shape getOverlineShape() {
        double d = this.metrics.getOverlineOffset();
        float f = this.metrics.getOverlineThickness();
        d += (double)f;
        this.aci.first();
        Float f2 = (Float)this.aci.getAttribute(DY);
        if (f2 != null) {
            d += (double)f2.floatValue();
        }
        BasicStroke basicStroke = new BasicStroke(f);
        Rectangle2D rectangle2D = this.gv.getLogicalBounds();
        return basicStroke.createStrokedShape(new Line2D.Double(rectangle2D.getMinX() + (double)f / 2.0, this.offset.getY() + d, rectangle2D.getMaxX() - (double)f / 2.0, this.offset.getY() + d));
    }

    protected Shape getUnderlineShape() {
        double d = this.metrics.getUnderlineOffset();
        float f = this.metrics.getUnderlineThickness();
        d += (double)f * 1.5;
        BasicStroke basicStroke = new BasicStroke(f);
        this.aci.first();
        Float f2 = (Float)this.aci.getAttribute(DY);
        if (f2 != null) {
            d += (double)f2.floatValue();
        }
        Rectangle2D rectangle2D = this.gv.getLogicalBounds();
        return basicStroke.createStrokedShape(new Line2D.Double(rectangle2D.getMinX() + (double)f / 2.0, this.offset.getY() + d, rectangle2D.getMaxX() - (double)f / 2.0, this.offset.getY() + d));
    }

    protected Shape getStrikethroughShape() {
        double d = this.metrics.getStrikethroughOffset();
        float f = this.metrics.getStrikethroughThickness();
        BasicStroke basicStroke = new BasicStroke(f);
        this.aci.first();
        Float f2 = (Float)this.aci.getAttribute(DY);
        if (f2 != null) {
            d += (double)f2.floatValue();
        }
        Rectangle2D rectangle2D = this.gv.getLogicalBounds();
        return basicStroke.createStrokedShape(new Line2D.Double(rectangle2D.getMinX() + (double)f / 2.0, this.offset.getY() + d, rectangle2D.getMaxX() - (double)f / 2.0, this.offset.getY() + d));
    }

    protected void doExplicitGlyphLayout() {
        int n;
        this.gv.performDefaultLayout();
        float f = this.vertical ? (float)this.gv.getLogicalBounds().getWidth() : this.metrics.getAscent() + Math.abs(this.metrics.getDescent());
        int n2 = this.gv.getNumGlyphs();
        float[] fArray = this.gv.getGlyphPositions(0, n2 + 1, null);
        float f2 = 0.0f;
        float f3 = 0.0f;
        boolean bl = this.isGlyphOrientationAuto();
        int n3 = 0;
        if (!bl) {
            n3 = this.getGlyphOrientationAngle();
        }
        int n4 = this.aci.getBeginIndex();
        int n5 = 0;
        char c = this.aci.first();
        int n6 = n5 + n4;
        Float f4 = null;
        Float f5 = null;
        Float f6 = null;
        Float f7 = null;
        Float f8 = null;
        Object object = null;
        float f9 = 0.0f;
        float f10 = 0.0f;
        float f11 = (float)this.offset.getX();
        float f12 = (float)this.offset.getY();
        Point2D.Float float_ = new Point2D.Float();
        boolean bl2 = false;
        for (n = 0; n < n2; ++n) {
            Cloneable cloneable;
            float f13;
            float f14;
            float f15;
            float f16;
            if (n5 + n4 >= n6) {
                n6 = this.aci.getRunLimit(runAtts);
                f4 = (Float)this.aci.getAttribute(X);
                f5 = (Float)this.aci.getAttribute(Y);
                f6 = (Float)this.aci.getAttribute(DX);
                f7 = (Float)this.aci.getAttribute(DY);
                f8 = (Float)this.aci.getAttribute(ROTATION);
                object = this.aci.getAttribute(BASELINE_SHIFT);
            }
            GVTGlyphMetrics gVTGlyphMetrics = this.gv.getGlyphMetrics(n);
            if (n == 0) {
                if (this.isVertical()) {
                    if (bl) {
                        if (this.isLatinChar(c)) {
                            f2 = 0.0f;
                        } else {
                            f16 = gVTGlyphMetrics.getVerticalAdvance();
                            f15 = this.metrics.getAscent();
                            f14 = this.metrics.getDescent();
                            f2 = f15 + (f16 - (f15 + f14)) / 2.0f;
                        }
                    } else if (n3 == 0) {
                        f16 = gVTGlyphMetrics.getVerticalAdvance();
                        f15 = this.metrics.getAscent();
                        f14 = this.metrics.getDescent();
                        f2 = f15 + (f16 - (f15 + f14)) / 2.0f;
                    } else {
                        f2 = 0.0f;
                    }
                } else {
                    f3 = n3 == 270 ? (float)gVTGlyphMetrics.getBounds2D().getHeight() : 0.0f;
                }
            } else if (bl && f2 == 0.0f && !this.isLatinChar(c)) {
                f16 = gVTGlyphMetrics.getVerticalAdvance();
                f15 = this.metrics.getAscent();
                f14 = this.metrics.getDescent();
                f2 = f15 + (f16 - (f15 + f14)) / 2.0f;
            }
            f16 = 0.0f;
            f15 = 0.0f;
            f14 = 0.0f;
            float f17 = 0.0f;
            if (c != '\uffff') {
                if (this.vertical) {
                    f14 = bl ? (this.isLatinChar(c) ? 1.5707964f : 0.0f) : (float)Math.toRadians(n3);
                    if (this.textPath != null) {
                        f4 = null;
                    }
                } else {
                    f14 = (float)Math.toRadians(n3);
                    if (this.textPath != null) {
                        f5 = null;
                    }
                }
                f17 = f8 == null || f8.isNaN() ? f14 : f8.floatValue() + f14;
                if (f4 != null && !f4.isNaN()) {
                    if (n == 0) {
                        f9 = (float)((double)f4.floatValue() - this.offset.getX());
                    }
                    f11 = f4.floatValue() - f9;
                }
                if (f6 != null && !f6.isNaN()) {
                    f11 += f6.floatValue();
                }
                if (f5 != null && !f5.isNaN()) {
                    if (n == 0) {
                        f10 = (float)((double)f5.floatValue() - this.offset.getY());
                    }
                    f12 = f5.floatValue() - f10;
                }
                if (f7 != null && !f7.isNaN()) {
                    f12 += f7.floatValue();
                } else if (n > 0) {
                    f12 += fArray[n * 2 + 1] - fArray[n * 2 - 1];
                }
                f13 = 0.0f;
                if (object != null) {
                    if (object instanceof Integer) {
                        if (object == TextAttribute.SUPERSCRIPT_SUPER) {
                            f13 = f * 0.5f;
                        } else if (object == TextAttribute.SUPERSCRIPT_SUB) {
                            f13 = -f * 0.5f;
                        }
                    } else if (object instanceof Float) {
                        f13 = ((Float)object).floatValue();
                    }
                    if (this.vertical) {
                        f16 = f13;
                    } else {
                        f15 = -f13;
                    }
                }
                if (this.vertical) {
                    f15 += f2;
                    if (bl) {
                        if (this.isLatinChar(c)) {
                            f16 += this.metrics.getStrikethroughOffset();
                        } else {
                            cloneable = this.gv.getGlyphVisualBounds(n).getBounds2D();
                            f16 -= (float)(((RectangularShape)cloneable).getMaxX() - (double)fArray[2 * n] - ((RectangularShape)cloneable).getWidth() / 2.0);
                        }
                    } else {
                        cloneable = this.gv.getGlyphVisualBounds(n).getBounds2D();
                        f16 = n3 == 0 ? (f16 -= (float)(((RectangularShape)cloneable).getMaxX() - (double)fArray[2 * n] - ((RectangularShape)cloneable).getWidth() / 2.0)) : (n3 == 180 ? (f16 += (float)(((RectangularShape)cloneable).getMaxX() - (double)fArray[2 * n] - ((RectangularShape)cloneable).getWidth() / 2.0)) : (n3 == 90 ? (f16 += this.metrics.getStrikethroughOffset()) : (f16 -= this.metrics.getStrikethroughOffset())));
                    }
                } else {
                    f16 += f3;
                    if (n3 == 90) {
                        f15 -= gVTGlyphMetrics.getHorizontalAdvance();
                    } else if (n3 == 180) {
                        f15 -= this.metrics.getAscent();
                    }
                }
            }
            float_.x = f11 + f16;
            float_.y = f12 + f15;
            this.gv.setGlyphPosition(n, float_);
            if (ArabicTextHandler.arabicCharTransparent(c)) {
                bl2 = true;
            } else if (this.vertical) {
                f13 = 0.0f;
                if (bl) {
                    f13 = this.isLatinChar(c) ? gVTGlyphMetrics.getHorizontalAdvance() : gVTGlyphMetrics.getVerticalAdvance();
                } else if (n3 == 0 || n3 == 180) {
                    f13 = gVTGlyphMetrics.getVerticalAdvance();
                } else if (n3 == 90) {
                    f13 = gVTGlyphMetrics.getHorizontalAdvance();
                } else {
                    f13 = gVTGlyphMetrics.getHorizontalAdvance();
                    this.gv.setGlyphTransform(n, AffineTransform.getTranslateInstance(0.0, f13));
                }
                f12 += f13;
            } else {
                f13 = 0.0f;
                if (n3 == 0) {
                    f13 = gVTGlyphMetrics.getHorizontalAdvance();
                } else if (n3 == 180) {
                    f13 = gVTGlyphMetrics.getHorizontalAdvance();
                    this.gv.setGlyphTransform(n, AffineTransform.getTranslateInstance(f13, 0.0));
                } else {
                    f13 = gVTGlyphMetrics.getVerticalAdvance();
                }
                f11 += f13;
            }
            if (!GlyphLayout.epsEQ(f17, 0.0)) {
                AffineTransform affineTransform = this.gv.getGlyphTransform(n);
                if (affineTransform == null) {
                    affineTransform = new AffineTransform();
                }
                cloneable = GlyphLayout.epsEQ(f17, 1.5707963267948966) ? new AffineTransform(0.0f, 1.0f, -1.0f, 0.0f, 0.0f, 0.0f) : (GlyphLayout.epsEQ(f17, Math.PI) ? new AffineTransform(-1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f) : (GlyphLayout.epsEQ(f17, 4.71238898038469) ? new AffineTransform(0.0f, -1.0f, 1.0f, 0.0f, 0.0f, 0.0f) : AffineTransform.getRotateInstance(f17)));
                affineTransform.concatenate((AffineTransform)cloneable);
                this.gv.setGlyphTransform(n, affineTransform);
            }
            if ((n5 += this.gv.getCharacterCount(n, n)) >= this.charMap.length) {
                n5 = this.charMap.length - 1;
            }
            c = this.aci.setIndex(n5 + n4);
        }
        float_.x = f11;
        float_.y = f12;
        this.gv.setGlyphPosition(n, float_);
        this.advance = new Point2D.Float((float)((double)f11 - this.offset.getX()), (float)((double)f12 - this.offset.getY()));
        if (bl2) {
            c = this.aci.first();
            n5 = 0;
            int n7 = -1;
            for (n = 0; n < n2; ++n) {
                if (ArabicTextHandler.arabicCharTransparent(c)) {
                    if (n7 == -1) {
                        n7 = n;
                    }
                } else if (n7 != -1) {
                    Point2D point2D = this.gv.getGlyphPosition(n);
                    GVTGlyphMetrics gVTGlyphMetrics = this.gv.getGlyphMetrics(n);
                    boolean bl3 = false;
                    boolean bl4 = false;
                    float f18 = 0.0f;
                    float f19 = 0.0f;
                    if (this.vertical) {
                        if (bl || n3 == 90) {
                            f19 = gVTGlyphMetrics.getHorizontalAdvance();
                        } else if (n3 == 270) {
                            f19 = 0.0f;
                        } else {
                            f18 = n3 == 0 ? gVTGlyphMetrics.getHorizontalAdvance() : -gVTGlyphMetrics.getHorizontalAdvance();
                        }
                    } else if (n3 == 0) {
                        f18 = gVTGlyphMetrics.getHorizontalAdvance();
                    } else if (n3 == 90) {
                        f19 = gVTGlyphMetrics.getHorizontalAdvance();
                    } else if (n3 == 180) {
                        f18 = 0.0f;
                    } else {
                        f19 = -gVTGlyphMetrics.getHorizontalAdvance();
                    }
                    float f20 = (float)(point2D.getX() + (double)f18);
                    float f21 = (float)(point2D.getY() + (double)f19);
                    for (int i = n7; i < n; ++i) {
                        Point2D point2D2 = this.gv.getGlyphPosition(i);
                        GVTGlyphMetrics gVTGlyphMetrics2 = this.gv.getGlyphMetrics(i);
                        float f22 = (float)point2D2.getX();
                        float f23 = (float)point2D2.getY();
                        float f24 = 0.0f;
                        float f25 = 0.0f;
                        float f26 = gVTGlyphMetrics2.getHorizontalAdvance();
                        if (this.vertical) {
                            if (bl || n3 == 90) {
                                f23 = f21 - f26;
                            } else if (n3 == 270) {
                                f23 = f21 + f26;
                            } else {
                                f22 = n3 == 0 ? f20 - f26 : f20 + f26;
                            }
                        } else if (n3 == 0) {
                            f22 = f20 - f26;
                        } else if (n3 == 90) {
                            f23 = f21 - f26;
                        } else if (n3 == 180) {
                            f22 = f20 + f26;
                        } else {
                            f23 = f21 + f26;
                        }
                        point2D2 = new Point2D.Double(f22, f23);
                        this.gv.setGlyphPosition(i, point2D2);
                        if (!bl4 && !bl3) continue;
                        AffineTransform affineTransform = AffineTransform.getTranslateInstance(f24, f25);
                        affineTransform.concatenate(this.gv.getGlyphTransform(n));
                        this.gv.setGlyphTransform(n, affineTransform);
                    }
                    n7 = -1;
                }
                if ((n5 += this.gv.getCharacterCount(n, n)) >= this.charMap.length) {
                    n5 = this.charMap.length - 1;
                }
                c = this.aci.setIndex(n5 + n4);
            }
        }
        this.layoutApplied = true;
        this.spacingApplied = false;
        this.glyphAdvances = null;
        this.pathApplied = false;
    }

    protected void adjustTextSpacing() {
        if (this.spacingApplied) {
            return;
        }
        if (!this.layoutApplied) {
            this.doExplicitGlyphLayout();
        }
        this.aci.first();
        Boolean bl = (Boolean)this.aci.getAttribute(GVTAttributedCharacterIterator.TextAttribute.CUSTOM_SPACING);
        if (bl != null && bl.booleanValue()) {
            this.advance = this.doSpacing((Float)this.aci.getAttribute(GVTAttributedCharacterIterator.TextAttribute.KERNING), (Float)this.aci.getAttribute(GVTAttributedCharacterIterator.TextAttribute.LETTER_SPACING), (Float)this.aci.getAttribute(GVTAttributedCharacterIterator.TextAttribute.WORD_SPACING));
            this.layoutApplied = false;
        }
        this.applyStretchTransform(!this.adjSpacing);
        this.spacingApplied = true;
        this.pathApplied = false;
    }

    protected Point2D doSpacing(Float f, Float f2, Float f3) {
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = false;
        float f4 = 0.0f;
        float f5 = 0.0f;
        if (f != null && !f.isNaN()) {
            f4 = f.floatValue();
            bl = false;
        }
        if (f2 != null && !f2.isNaN()) {
            f5 = f2.floatValue();
            bl3 = true;
        }
        if (f3 != null && !f3.isNaN()) {
            bl2 = true;
        }
        int n = this.gv.getNumGlyphs();
        float f6 = 0.0f;
        float f7 = 0.0f;
        Point2D[] point2DArray = new Point2D[n + 1];
        Point2D point2D = this.gv.getGlyphPosition(0);
        int n2 = this.gv.getGlyphCode(0);
        float f8 = (float)point2D.getX();
        float f9 = (float)point2D.getY();
        Point2D.Double double_ = new Point2D.Double(this.advance.getX() - (this.gv.getGlyphPosition(n - 1).getX() - (double)f8), this.advance.getY() - (this.gv.getGlyphPosition(n - 1).getY() - (double)f9));
        try {
            int n3;
            Point2D point2D2;
            int n4;
            GVTFont gVTFont = this.gv.getFont();
            if (n > 1 && (bl3 || !bl)) {
                for (n4 = 1; n4 <= n; ++n4) {
                    float f10;
                    point2D2 = this.gv.getGlyphPosition(n4);
                    n3 = n4 == n ? -1 : this.gv.getGlyphCode(n4);
                    f6 = (float)point2D2.getX() - (float)point2D.getX();
                    f7 = (float)point2D2.getY() - (float)point2D.getY();
                    if (bl) {
                        if (this.vertical) {
                            f7 += f5;
                        } else {
                            f6 += f5;
                        }
                    } else if (this.vertical) {
                        f10 = 0.0f;
                        if (n3 != -1) {
                            f10 = gVTFont.getVKern(n2, n3);
                        }
                        f7 += f4 - f10 + f5;
                    } else {
                        f10 = 0.0f;
                        if (n3 != -1) {
                            f10 = gVTFont.getHKern(n2, n3);
                        }
                        f6 += f4 - f10 + f5;
                    }
                    point2DArray[n4] = new Point2D.Float(f8 += f6, f9 += f7);
                    point2D = point2D2;
                    n2 = n3;
                }
                for (n4 = 1; n4 <= n; ++n4) {
                    if (point2DArray[n4] == null) continue;
                    this.gv.setGlyphPosition(n4, point2DArray[n4]);
                }
            }
            if (this.vertical) {
                ((Point2D)double_).setLocation(((Point2D)double_).getX(), ((Point2D)double_).getY() + (double)f4 + (double)f5);
            } else {
                ((Point2D)double_).setLocation(((Point2D)double_).getX() + (double)f4 + (double)f5, ((Point2D)double_).getY());
            }
            f6 = 0.0f;
            f7 = 0.0f;
            point2D = this.gv.getGlyphPosition(0);
            f8 = (float)point2D.getX();
            f9 = (float)point2D.getY();
            if (n > 1 && bl2) {
                for (n4 = 1; n4 < n; ++n4) {
                    point2D2 = this.gv.getGlyphPosition(n4);
                    f6 = (float)point2D2.getX() - (float)point2D.getX();
                    f7 = (float)point2D2.getY() - (float)point2D.getY();
                    n3 = 0;
                    int n5 = n4;
                    int n6 = n4;
                    GVTGlyphMetrics gVTGlyphMetrics = this.gv.getGlyphMetrics(n4);
                    while (gVTGlyphMetrics.getBounds2D().getWidth() < 0.01 || gVTGlyphMetrics.isWhitespace()) {
                        if (n3 == 0) {
                            n3 = 1;
                        }
                        if (n4 == n - 1) break;
                        ++n6;
                        point2D2 = this.gv.getGlyphPosition(++n4);
                        gVTGlyphMetrics = this.gv.getGlyphMetrics(n4);
                    }
                    if (n3 != 0) {
                        int n7 = n6 - n5;
                        float f11 = (float)point2D.getX();
                        float f12 = (float)point2D.getY();
                        f6 = (float)(point2D2.getX() - (double)f11) / (float)(n7 + 1);
                        f7 = (float)(point2D2.getY() - (double)f12) / (float)(n7 + 1);
                        if (this.vertical) {
                            f7 += f3.floatValue() / (float)(n7 + 1);
                        } else {
                            f6 += f3.floatValue() / (float)(n7 + 1);
                        }
                        for (int i = n5; i <= n6; ++i) {
                            point2DArray[i] = new Point2D.Float(f8 += f6, f9 += f7);
                        }
                    } else {
                        f6 = (float)(point2D2.getX() - point2D.getX());
                        f7 = (float)(point2D2.getY() - point2D.getY());
                        point2DArray[n4] = new Point2D.Float(f8 += f6, f9 += f7);
                    }
                    point2D = point2D2;
                }
                Point2D point2D3 = this.gv.getGlyphPosition(n);
                point2DArray[n] = new Point2D.Float(f8 += (float)(point2D3.getX() - point2D.getX()), f9 += (float)(point2D3.getY() - point2D.getY()));
                for (int i = 1; i <= n; ++i) {
                    if (point2DArray[i] == null) continue;
                    this.gv.setGlyphPosition(i, point2DArray[i]);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        double d = this.gv.getGlyphPosition(n - 1).getX() - this.gv.getGlyphPosition(0).getX();
        double d2 = this.gv.getGlyphPosition(n - 1).getY() - this.gv.getGlyphPosition(0).getY();
        Point2D.Double double_2 = new Point2D.Double(d + ((Point2D)double_).getX(), d2 + ((Point2D)double_).getY());
        return double_2;
    }

    protected void applyStretchTransform(boolean bl) {
        if (this.xScale == 1.0f && this.yScale == 1.0f) {
            return;
        }
        AffineTransform affineTransform = AffineTransform.getScaleInstance(this.xScale, this.yScale);
        int n = this.gv.getNumGlyphs();
        float[] fArray = this.gv.getGlyphPositions(0, n + 1, null);
        float f = fArray[0];
        float f2 = fArray[1];
        Point2D.Float float_ = new Point2D.Float();
        for (int i = 0; i <= n; ++i) {
            float f3 = fArray[2 * i] - f;
            float f4 = fArray[2 * i + 1] - f2;
            float_.x = f + f3 * this.xScale;
            float_.y = f2 + f4 * this.yScale;
            this.gv.setGlyphPosition(i, float_);
            if (!bl || i == n) continue;
            AffineTransform affineTransform2 = this.gv.getGlyphTransform(i);
            if (affineTransform2 != null) {
                affineTransform2.preConcatenate(affineTransform);
                this.gv.setGlyphTransform(i, affineTransform2);
                continue;
            }
            this.gv.setGlyphTransform(i, affineTransform);
        }
        this.advance = new Point2D.Float((float)(this.advance.getX() * (double)this.xScale), (float)(this.advance.getY() * (double)this.yScale));
        this.layoutApplied = false;
    }

    protected void doPathLayout() {
        float f;
        if (this.pathApplied) {
            return;
        }
        if (!this.spacingApplied) {
            this.adjustTextSpacing();
        }
        this.getGlyphAdvances();
        if (this.textPath == null) {
            this.pathApplied = true;
            return;
        }
        boolean bl = !this.isVertical();
        boolean bl2 = this.isGlyphOrientationAuto();
        int n = 0;
        if (!bl2) {
            n = this.getGlyphOrientationAngle();
        }
        float f2 = this.textPath.lengthOfPath();
        float f3 = this.textPath.getStartOffset();
        int n2 = this.gv.getNumGlyphs();
        for (int i = 0; i < n2; ++i) {
            this.gv.setGlyphVisible(i, true);
        }
        float f4 = bl ? (float)this.gv.getLogicalBounds().getWidth() : (float)this.gv.getLogicalBounds().getHeight();
        if (f2 == 0.0f || f4 == 0.0f) {
            this.pathApplied = true;
            this.textPathAdvance = this.advance;
            return;
        }
        Point2D point2D = this.gv.getGlyphPosition(0);
        float f5 = 0.0f;
        if (bl) {
            f5 = (float)point2D.getY();
            f = (float)(point2D.getX() + (double)f3);
        } else {
            f5 = (float)point2D.getX();
            f = (float)(point2D.getY() + (double)f3);
        }
        char c = this.aci.first();
        int n3 = this.aci.getBeginIndex();
        int n4 = 0;
        int n5 = -1;
        float f6 = 0.0f;
        for (int i = 0; i < n2; ++i) {
            float f7;
            Point2D point2D2;
            Point2D point2D3 = this.gv.getGlyphPosition(i);
            float f8 = 0.0f;
            float f9 = 0.0f;
            Point2D point2D4 = this.gv.getGlyphPosition(i + 1);
            if (bl) {
                f8 = (float)(point2D4.getX() - point2D3.getX());
                f9 = (float)(point2D4.getY() - point2D3.getY());
            } else {
                f8 = (float)(point2D4.getY() - point2D3.getY());
                f9 = (float)(point2D4.getX() - point2D3.getX());
            }
            Rectangle2D rectangle2D = this.gv.getGlyphOutline(i).getBounds2D();
            float f10 = (float)rectangle2D.getWidth();
            float f11 = (float)rectangle2D.getHeight();
            float f12 = 0.0f;
            if (f10 > 0.0f) {
                f12 = (float)(rectangle2D.getX() + (double)(f10 / 2.0f));
                f12 -= (float)point2D3.getX();
            }
            float f13 = 0.0f;
            if (f11 > 0.0f) {
                f13 = (float)(rectangle2D.getY() + (double)(f11 / 2.0f));
                f13 -= (float)point2D3.getY();
            }
            if ((point2D2 = this.textPath.pointAtLength(f7 = bl ? f + f12 : f + f13)) != null) {
                float f14 = this.textPath.angleAtLength(f7);
                AffineTransform affineTransform = new AffineTransform();
                if (bl) {
                    affineTransform.rotate(f14);
                } else {
                    affineTransform.rotate((double)f14 - 1.5707963267948966);
                }
                if (bl) {
                    affineTransform.translate(0.0, f5);
                } else {
                    affineTransform.translate(f5, 0.0);
                }
                if (bl) {
                    affineTransform.translate(-f12, 0.0);
                } else {
                    affineTransform.translate(0.0, -f13);
                }
                AffineTransform affineTransform2 = this.gv.getGlyphTransform(i);
                if (affineTransform2 != null) {
                    affineTransform.concatenate(affineTransform2);
                }
                this.gv.setGlyphTransform(i, affineTransform);
                this.gv.setGlyphPosition(i, point2D2);
                n5 = i;
                f6 = f8;
            } else {
                this.gv.setGlyphVisible(i, false);
            }
            f += f8;
            f5 += f9;
            if ((n4 += this.gv.getCharacterCount(i, i)) >= this.charMap.length) {
                n4 = this.charMap.length - 1;
            }
            c = this.aci.setIndex(n4 + n3);
        }
        if (n5 > -1) {
            Point2D point2D5 = this.gv.getGlyphPosition(n5);
            this.textPathAdvance = bl ? new Point2D.Double(point2D5.getX() + (double)f6, point2D5.getY()) : new Point2D.Double(point2D5.getX(), point2D5.getY() + (double)f6);
        } else {
            this.textPathAdvance = new Point2D.Double(0.0, 0.0);
        }
        this.layoutApplied = false;
        this.spacingApplied = false;
        this.pathApplied = true;
    }

    protected boolean isLatinChar(char c) {
        if (c < '\u00ff' && Character.isLetterOrDigit(c)) {
            return true;
        }
        Character.UnicodeBlock unicodeBlock = Character.UnicodeBlock.of(c);
        return unicodeBlock == Character.UnicodeBlock.BASIC_LATIN || unicodeBlock == Character.UnicodeBlock.LATIN_1_SUPPLEMENT || unicodeBlock == Character.UnicodeBlock.LATIN_EXTENDED_ADDITIONAL || unicodeBlock == Character.UnicodeBlock.LATIN_EXTENDED_A || unicodeBlock == Character.UnicodeBlock.LATIN_EXTENDED_B || unicodeBlock == Character.UnicodeBlock.ARABIC || unicodeBlock == Character.UnicodeBlock.ARABIC_PRESENTATION_FORMS_A || unicodeBlock == Character.UnicodeBlock.ARABIC_PRESENTATION_FORMS_B;
    }

    protected boolean isGlyphOrientationAuto() {
        if (!this.isVertical()) {
            return false;
        }
        this.aci.first();
        Integer n = (Integer)this.aci.getAttribute(VERTICAL_ORIENTATION);
        if (n != null) {
            return n == ORIENTATION_AUTO;
        }
        return true;
    }

    protected int getGlyphOrientationAngle() {
        int n = 0;
        this.aci.first();
        Float f = this.isVertical() ? (Float)this.aci.getAttribute(VERTICAL_ORIENTATION_ANGLE) : (Float)this.aci.getAttribute(HORIZONTAL_ORIENTATION_ANGLE);
        if (f != null) {
            n = (int)f.floatValue();
        }
        if (n != 0 || n != 90 || n != 180 || n != 270) {
            while (n < 0) {
                n += 360;
            }
            while (n >= 360) {
                n -= 360;
            }
            n = n <= 45 || n > 315 ? 0 : (n > 45 && n <= 135 ? 90 : (n > 135 && n <= 225 ? 180 : 270));
        }
        return n;
    }

    @Override
    public boolean hasCharacterIndex(int n) {
        for (int i = 0; i < this.charMap.length; ++i) {
            if (n != this.charMap[i]) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isAltGlyph() {
        return this.isAltGlyph;
    }

    @Override
    public boolean isReversed() {
        return this.gv.isReversed();
    }

    @Override
    public void maybeReverse(boolean bl) {
        this.gv.maybeReverse(bl);
    }

    static {
        runAtts.add(X);
        runAtts.add(Y);
        runAtts.add(DX);
        runAtts.add(DY);
        runAtts.add(ROTATION);
        runAtts.add(BASELINE_SHIFT);
        szAtts = new HashSet();
        szAtts.add(TextAttribute.SIZE);
        szAtts.add(GVT_FONT);
        szAtts.add(LINE_HEIGHT);
    }
}

