/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language.supercall;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.array.ArrayToObjectArrayNode;
import org.jruby.truffle.core.array.ArrayToObjectArrayNodeGen;
import org.jruby.truffle.core.array.ArrayUtils;
import org.jruby.truffle.language.RubyGuards;
import org.jruby.truffle.language.RubyNode;

public class ReadZSuperArgumentsNode
extends RubyNode {
    @Node.Children
    private final RubyNode[] reloadNodes;
    @Node.Child
    private ArrayToObjectArrayNode unsplatNode;
    private final boolean hasRestParameter;

    public ReadZSuperArgumentsNode(RubyContext context, SourceSection sourceSection, boolean hasRestParameter, RubyNode[] reloadNodes) {
        super(context, sourceSection);
        this.hasRestParameter = hasRestParameter;
        this.reloadNodes = reloadNodes;
    }

    @Override
    @ExplodeLoop
    public final Object execute(VirtualFrame frame) {
        CompilerAsserts.compilationConstant(this.reloadNodes.length);
        Object[] superArguments = new Object[this.reloadNodes.length];
        for (int n = 0; n < superArguments.length; ++n) {
            superArguments[n] = this.reloadNodes[n].execute(frame);
        }
        if (this.hasRestParameter) {
            int restArgIndex = this.reloadNodes.length - 1;
            Object restArg = superArguments[restArgIndex];
            assert (RubyGuards.isRubyArray(restArg));
            Object[] restArgs = this.unsplat((DynamicObject)restArg);
            superArguments = ArrayUtils.copyOf(superArguments, restArgIndex + restArgs.length);
            ArrayUtils.arraycopy(restArgs, 0, superArguments, restArgIndex, restArgs.length);
        }
        return superArguments;
    }

    private Object[] unsplat(DynamicObject array) {
        if (this.unsplatNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.unsplatNode = this.insert(ArrayToObjectArrayNodeGen.create(null));
        }
        return this.unsplatNode.executeToObjectArray(array);
    }
}

