/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.classloader;

import com.google.common.base.Charsets;
import com.google.common.hash.HashCode;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.gradle.internal.classloader.ClassPathSnapshotter;
import org.gradle.internal.classloader.DefaultClassLoaderFactory;
import org.gradle.internal.classloader.FilteringClassLoader;
import org.gradle.internal.classloader.HashingClassLoaderFactory;
import org.gradle.internal.classpath.ClassPath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultHashingClassLoaderFactory
extends DefaultClassLoaderFactory
implements HashingClassLoaderFactory {
    private final ClassPathSnapshotter snapshotter;
    private final Map<ClassLoader, HashCode> hashCodes = new WeakHashMap<ClassLoader, HashCode>();

    public DefaultHashingClassLoaderFactory(ClassPathSnapshotter snapshotter) {
        this.snapshotter = snapshotter;
    }

    @Override
    protected ClassLoader doCreateClassLoader(ClassLoader parent, ClassPath classPath) {
        ClassLoader classLoader = super.doCreateClassLoader(parent, classPath);
        this.hashCodes.put(classLoader, this.calculateClassLoaderHash(classPath));
        return classLoader;
    }

    @Override
    protected ClassLoader doCreateFilteringClassLoader(ClassLoader parent, FilteringClassLoader.Spec spec) {
        ClassLoader classLoader = super.doCreateFilteringClassLoader(parent, spec);
        this.hashCodes.put(classLoader, DefaultHashingClassLoaderFactory.calculateFilterSpecHash(spec));
        return classLoader;
    }

    @Override
    public ClassLoader createChildClassLoader(ClassLoader parent, ClassPath classPath, HashCode overrideHashCode) {
        HashCode hashCode = overrideHashCode != null ? overrideHashCode : this.calculateClassLoaderHash(classPath);
        ClassLoader classLoader = super.doCreateClassLoader(parent, classPath);
        this.hashCodes.put(classLoader, hashCode);
        return classLoader;
    }

    @Override
    public HashCode getHash(ClassLoader classLoader) {
        return this.hashCodes.get(classLoader);
    }

    private HashCode calculateClassLoaderHash(ClassPath classPath) {
        return this.snapshotter.snapshot(classPath).getStrongHash();
    }

    private static HashCode calculateFilterSpecHash(FilteringClassLoader.Spec spec) {
        Hasher hasher = Hashing.md5().newHasher();
        DefaultHashingClassLoaderFactory.addToHash(hasher, spec.getClassNames());
        DefaultHashingClassLoaderFactory.addToHash(hasher, spec.getPackageNames());
        DefaultHashingClassLoaderFactory.addToHash(hasher, spec.getPackagePrefixes());
        DefaultHashingClassLoaderFactory.addToHash(hasher, spec.getResourcePrefixes());
        DefaultHashingClassLoaderFactory.addToHash(hasher, spec.getResourceNames());
        DefaultHashingClassLoaderFactory.addToHash(hasher, spec.getDisallowedClassNames());
        DefaultHashingClassLoaderFactory.addToHash(hasher, spec.getDisallowedPackagePrefixes());
        return hasher.hash();
    }

    private static void addToHash(Hasher hasher, Set<String> items) {
        int count = items.size();
        hasher.putInt(count);
        if (count == 0) {
            return;
        }
        Object[] sortedItems = items.toArray(new String[count]);
        Arrays.sort(sortedItems);
        for (Object item : sortedItems) {
            hasher.putInt(0);
            hasher.putString((CharSequence)item, Charsets.UTF_8);
        }
    }
}

