/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.serialization.js;

import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.serialization.js.KotlinJavascriptSerializationUtil;
import org.jetbrains.kotlin.serialization.js.KotlinJavascriptSerializedResourcePaths;

@Metadata(mv={1, 1, 2}, bv={1, 0, 1}, k=2, d1={"\u0000\u001a\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0005\u001a\u0010\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0001H\u0002\u001a\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0002\u001a\u0010\u0010\t\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\u0007H\u0002\u001a\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u0001H\u0002\u001a\u0010\u0010\f\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u0001H\u0002\u001a\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\u0001\u001a\u000e\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\u0001\u001a\u000e\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\u0001\u001a\u000e\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\u0001\u001a\n\u0010\u0013\u001a\u00020\u000f*\u00020\u0007\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"DEFAULT_PACKAGE_CLASS_NAME", "", "DEFAULT_PACKAGE_METAFILE_NAME", "PACKAGE_CLASS_NAME_SUFFIX", "capitalizeNonEmptyString", "s", "getPackageClassFqName", "Lorg/jetbrains/kotlin/name/FqName;", "packageFQN", "getPackageClassName", "getPackageFqName", "fileName", "getPackageName", "filePath", "isClassesInPackageFile", "", "isDefaultPackageMetafile", "isPackageMetadataFile", "isStringTableFile", "isPackageClassFqName", "kotlin-compiler"})
public final class KotlinJavascriptSerializedResourcePathsKt {
    private static final String PACKAGE_CLASS_NAME_SUFFIX = "Package";
    private static final String DEFAULT_PACKAGE_CLASS_NAME = "_DefaultPackage";
    private static final String DEFAULT_PACKAGE_METAFILE_NAME = "_DefaultPackage.kjsm";

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isPackageClassFqName(@NotNull FqName $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        if ($receiver.isRoot()) return false;
        FqName fqName2 = $receiver.parent();
        Intrinsics.checkExpressionValueIsNotNull(fqName2, "this.parent()");
        if (!Intrinsics.areEqual(KotlinJavascriptSerializedResourcePathsKt.getPackageClassFqName(fqName2), $receiver)) return false;
        return true;
    }

    public static final boolean isDefaultPackageMetafile(@NotNull String fileName) {
        Intrinsics.checkParameterIsNotNull(fileName, "fileName");
        return Intrinsics.areEqual(fileName, DEFAULT_PACKAGE_METAFILE_NAME);
    }

    public static final boolean isPackageMetadataFile(@NotNull String fileName) {
        Intrinsics.checkParameterIsNotNull(fileName, "fileName");
        return Intrinsics.areEqual(KotlinJavascriptSerializedResourcePaths.INSTANCE.getPackageFilePath(KotlinJavascriptSerializedResourcePathsKt.getPackageFqName(fileName)), fileName);
    }

    public static final boolean isStringTableFile(@NotNull String fileName) {
        Intrinsics.checkParameterIsNotNull(fileName, "fileName");
        return Intrinsics.areEqual(KotlinJavascriptSerializedResourcePaths.INSTANCE.getStringTableFilePath(KotlinJavascriptSerializedResourcePathsKt.getPackageFqName(fileName)), fileName);
    }

    public static final boolean isClassesInPackageFile(@NotNull String fileName) {
        Intrinsics.checkParameterIsNotNull(fileName, "fileName");
        return Intrinsics.areEqual(KotlinJavascriptSerializedResourcePaths.INSTANCE.getClassesInPackageFilePath(KotlinJavascriptSerializedResourcePathsKt.getPackageFqName(fileName)), fileName);
    }

    private static final FqName getPackageFqName(String fileName) {
        return new FqName(KotlinJavascriptSerializedResourcePathsKt.getPackageName(fileName));
    }

    private static final String getPackageName(String filePath) {
        return StringsKt.indexOf$default((CharSequence)filePath, '/', 0, false, 6, null) >= 0 ? StringsKt.replace$default(StringsKt.substringBeforeLast$default(filePath, '/', null, 2, null), '/', '.', false, 4, null) : "";
    }

    private static final FqName getPackageClassFqName(FqName packageFQN) {
        FqName fqName2 = packageFQN.child(Name.identifier(KotlinJavascriptSerializedResourcePathsKt.getPackageClassName(packageFQN)));
        Intrinsics.checkExpressionValueIsNotNull(fqName2, "packageFQN.child(Name.id\u2026geClassName(packageFQN)))");
        return fqName2;
    }

    private static final String getPackageClassName(FqName packageFQN) {
        String string;
        if (packageFQN.isRoot()) {
            string = DEFAULT_PACKAGE_CLASS_NAME;
        } else {
            StringBuilder stringBuilder = new StringBuilder();
            String string2 = packageFQN.shortName().asString();
            Intrinsics.checkExpressionValueIsNotNull(string2, "packageFQN.shortName().asString()");
            string = stringBuilder.append(KotlinJavascriptSerializedResourcePathsKt.capitalizeNonEmptyString(string2)).append(PACKAGE_CLASS_NAME_SUFFIX).toString();
        }
        return string;
    }

    private static final String capitalizeNonEmptyString(String s) {
        String string;
        char c = s.charAt(0);
        if (Character.isUpperCase(c)) {
            string = s;
        } else {
            c = s.charAt(0);
            c = Character.toUpperCase(c);
            String string2 = s;
            int n = 1;
            String string3 = string2;
            if (string3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string4 = string3.substring(n);
            Intrinsics.checkExpressionValueIsNotNull(string4, "(this as java.lang.String).substring(startIndex)");
            string2 = string4;
            string = String.valueOf(c) + string2;
        }
        return string;
    }

    static {
        PACKAGE_CLASS_NAME_SUFFIX = PACKAGE_CLASS_NAME_SUFFIX;
        DEFAULT_PACKAGE_CLASS_NAME = "_Default" + PACKAGE_CLASS_NAME_SUFFIX;
        DEFAULT_PACKAGE_METAFILE_NAME = DEFAULT_PACKAGE_CLASS_NAME + "." + KotlinJavascriptSerializationUtil.INSTANCE.getCLASS_METADATA_FILE_EXTENSION();
    }

    @NotNull
    public static final /* synthetic */ FqName access$getPackageClassFqName(@NotNull FqName packageFQN) {
        return KotlinJavascriptSerializedResourcePathsKt.getPackageClassFqName(packageFQN);
    }
}

