/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile;

import com.google.common.base.Joiner;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.tasks.compile.JavaCompileSpec;
import org.gradle.api.tasks.compile.CompileOptions;
import org.gradle.api.tasks.compile.ForkOptions;

public class JavaCompilerArgumentsBuilder {
    public static final String USE_UNSHARED_COMPILER_TABLE_OPTION = "-XDuseUnsharedTable=true";
    public static final String EMPTY_SOURCE_PATH_REF_DIR = "emptySourcePathRef";
    private final JavaCompileSpec spec;
    private boolean includeLauncherOptions;
    private boolean includeMainOptions = true;
    private boolean includeClasspath = true;
    private boolean includeSourceFiles;
    private boolean includeCustomizations = true;
    private List<String> args;

    public JavaCompilerArgumentsBuilder(JavaCompileSpec spec) {
        this.spec = spec;
    }

    public JavaCompilerArgumentsBuilder includeLauncherOptions(boolean flag) {
        this.includeLauncherOptions = flag;
        return this;
    }

    public JavaCompilerArgumentsBuilder includeMainOptions(boolean flag) {
        this.includeMainOptions = flag;
        return this;
    }

    public JavaCompilerArgumentsBuilder includeClasspath(boolean flag) {
        this.includeClasspath = flag;
        return this;
    }

    public JavaCompilerArgumentsBuilder includeSourceFiles(boolean flag) {
        this.includeSourceFiles = flag;
        return this;
    }

    public JavaCompilerArgumentsBuilder includeCustomizations(boolean flag) {
        this.includeCustomizations = flag;
        return this;
    }

    public List<String> build() {
        this.args = new ArrayList<String>();
        this.addLauncherOptions();
        this.addMainOptions();
        this.addClasspath();
        this.addSourceFiles();
        this.addCustomizations();
        return this.args;
    }

    private void addCustomizations() {
        if (this.includeCustomizations) {
            this.args.add(USE_UNSHARED_COMPILER_TABLE_OPTION);
        }
    }

    private void addLauncherOptions() {
        if (!this.includeLauncherOptions) {
            return;
        }
        ForkOptions forkOptions = this.spec.getCompileOptions().getForkOptions();
        if (forkOptions.getMemoryInitialSize() != null) {
            this.args.add("-J-Xms" + forkOptions.getMemoryInitialSize().trim());
        }
        if (forkOptions.getMemoryMaximumSize() != null) {
            this.args.add("-J-Xmx" + forkOptions.getMemoryMaximumSize().trim());
        }
        if (forkOptions.getJvmArgs() != null) {
            this.args.addAll(forkOptions.getJvmArgs());
        }
    }

    private void addMainOptions() {
        File destinationDir;
        if (!this.includeMainOptions) {
            return;
        }
        CompileOptions compileOptions = this.spec.getCompileOptions();
        List<String> compilerArgs = compileOptions.getCompilerArgs();
        if (!this.releaseOptionIsSet(compilerArgs)) {
            String targetCompatibility;
            String sourceCompatibility = this.spec.getSourceCompatibility();
            if (sourceCompatibility != null) {
                this.args.add("-source");
                this.args.add(sourceCompatibility);
            }
            if ((targetCompatibility = this.spec.getTargetCompatibility()) != null) {
                this.args.add("-target");
                this.args.add(targetCompatibility);
            }
        }
        if ((destinationDir = this.spec.getDestinationDir()) != null) {
            this.args.add("-d");
            this.args.add(destinationDir.getPath());
        }
        if (compileOptions.isVerbose()) {
            this.args.add("-verbose");
        }
        if (compileOptions.isDeprecation()) {
            this.args.add("-deprecation");
        }
        if (!compileOptions.isWarnings()) {
            this.args.add("-nowarn");
        }
        if (compileOptions.isDebug()) {
            if (compileOptions.getDebugOptions().getDebugLevel() != null) {
                this.args.add("-g:" + compileOptions.getDebugOptions().getDebugLevel().trim());
            } else {
                this.args.add("-g");
            }
        } else {
            this.args.add("-g:none");
        }
        if (compileOptions.getEncoding() != null) {
            this.args.add("-encoding");
            this.args.add(compileOptions.getEncoding());
        }
        if (compileOptions.getBootClasspath() != null) {
            this.args.add("-bootclasspath");
            this.args.add(compileOptions.getBootClasspath());
        }
        if (compileOptions.getExtensionDirs() != null) {
            this.args.add("-extdirs");
            this.args.add(compileOptions.getExtensionDirs());
        }
        FileCollection sourcepath = compileOptions.getSourcepath();
        Iterable classpath = this.spec.getClasspath();
        if (sourcepath != null && !sourcepath.isEmpty() || this.includeClasspath && classpath != null && classpath.iterator().hasNext()) {
            this.args.add("-sourcepath");
            this.args.add(sourcepath == null ? this.emptyFolder(this.spec.getTempDir()) : sourcepath.getAsPath());
        }
        if (compilerArgs != null) {
            this.args.addAll(compilerArgs);
        }
    }

    private boolean releaseOptionIsSet(List<String> compilerArgs) {
        return compilerArgs != null && compilerArgs.contains("-release");
    }

    private String emptyFolder(File parent) {
        File emptySourcePath = new File(parent, EMPTY_SOURCE_PATH_REF_DIR);
        emptySourcePath.mkdirs();
        return emptySourcePath.getAbsolutePath();
    }

    private void addClasspath() {
        if (!this.includeClasspath) {
            return;
        }
        Iterable classpath = this.spec.getClasspath();
        if (classpath != null && classpath.iterator().hasNext()) {
            this.args.add("-classpath");
            this.args.add(Joiner.on((char)File.pathSeparatorChar).join(classpath));
        }
    }

    private void addSourceFiles() {
        if (!this.includeSourceFiles) {
            return;
        }
        for (File file : this.spec.getSource()) {
            this.args.add(file.getPath());
        }
    }
}

