// -*- c++ -*-
// Generated by gmmproc 2.46.1 -- DO NOT MODIFY!
#ifndef _GTKSOURCEVIEWMM_COMPLETION_H
#define _GTKSOURCEVIEWMM_COMPLETION_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* completion.h
 *
 * Copyright (C) 2009, 2010, 2011 Krzesimir Nowak
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <vector>

#include <glibmm/object.h>

#include <gtksourceviewmm/completioncontext.h>
#include <gtksourceviewmm/completionprovider.h>
#include <gtksourceviewmm/view.h>
#include <gtksourceviewmm/completioninfo.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GtkSourceCompletion GtkSourceCompletion;
typedef struct _GtkSourceCompletionClass GtkSourceCompletionClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Gsv
{ class Completion_Class; } // namespace Gsv
#endif //DOXYGEN_SHOULD_SKIP_THIS

namespace Gsv
{

class CompletionContext;
class CompletionProvider;

class SourceCompletionError : public Glib::Error
{
public:
  /** 
   */
  enum Code
  {
    ALREADY_BOUND,
    NOT_BOUND
  };

  SourceCompletionError(Code error_code, const Glib::ustring& error_message);
  explicit SourceCompletionError(GError* gobject);
  Code code() const;

#ifndef DOXYGEN_SHOULD_SKIP_THIS
private:

  static void throw_func(GError* gobject);

  friend void wrap_init(); // uses throw_func()

  #endif //DOXYGEN_SHOULD_SKIP_THIS
};

} // namespace Gsv

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gsv::SourceCompletionError::Code> : public Glib::Value_Enum<Gsv::SourceCompletionError::Code>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gsv
{


/** Main Completion Object
 *
 * @newin{2,10}
 */

class Completion : public Glib::Object
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef Completion CppObjectType;
  typedef Completion_Class CppClassType;
  typedef GtkSourceCompletion BaseObjectType;
  typedef GtkSourceCompletionClass BaseClassType;

  // noncopyable
  Completion(const Completion&) = delete;
  Completion& operator=(const Completion&) = delete;

private:  friend class Completion_Class;
  static CppClassType completion_class_;

protected:
  explicit Completion(const Glib::ConstructParams& construct_params);
  explicit Completion(GtkSourceCompletion* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:

  Completion(Completion&& src) noexcept;
  Completion& operator=(Completion&& src) noexcept;

  virtual ~Completion() noexcept;

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type()      G_GNUC_CONST;

#ifndef DOXYGEN_SHOULD_SKIP_THIS


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GtkSourceCompletion*       gobj()       { return reinterpret_cast<GtkSourceCompletion*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GtkSourceCompletion* gobj() const { return reinterpret_cast<GtkSourceCompletion*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GtkSourceCompletion* gobj_copy();

private:

public:

  
  /** Add a new CompletionProvider to the completion object.
   *
   * This will add a reference provider.
   *
   * @param provider A CompletionProvider.
   *
   * @return @c true if provider was successfully added, otherwise error is
   * thrown.
   *
   * @newin{2,10}
   */
  bool add_provider(const Glib::RefPtr<CompletionProvider>& provider);

  
  /** Remove provider from the completion.
   *
   * @param provider A CompletionProvider.
   *
   * @return @c true if provider was successfully removed, otherwise error is
   * thrown.
   *
   * @newin{2,10}
   */
  bool remove_provider(const Glib::RefPtr<CompletionProvider>& provider);

 
  /** Get list of providers registered on completion.
   *
   * @return List of CompletionProvider.
   *
   * @newin{2,10}
   */
  std::vector<Glib::RefPtr<CompletionProvider> > get_providers() const;

 
  /** Starts a new completion with the specified CompletionContext and
   *  a list of potential candidate providers for completion.
   *
   * @param providers A list of CompletionProvider.
   * @param context The CompletionContext with which to start the
   * completion.
   *
   * @return @c true if it was possible to the show completion window.
   *
   * @newin{2,10}
   */
  bool show(const std::vector<Glib::RefPtr<CompletionProvider> >& providers, const Glib::RefPtr<CompletionContext>& context);

  
  /** Hides the completion if it is active (visible).
   *
   * @newin{2,10}
   */
  void hide();

  
  /** Gets the CompletionInfo window.
   *
   * The info widget is the window where the completion displays optional extra information of the proposal.
   *
   * @return The CompletionInfo window.
   *
   * @newin{2,10}
   */
  CompletionInfo* get_info_window();

  
  /** Gets the CompletionInfo window.
   *
   * The info widget is the window where the completion displays optional extra information of the proposal.
   *
   * @return The CompletionInfo window.
   *
   * @newin{2,10}
   */
  const CompletionInfo* get_info_window() const;

  
  /** Gets the View associated with completion.
   *
   * @return The View associated with completion.
   *
   * @newin{2,10}
   */
  View* get_view();

  
  /** Gets the View associated with completion.
   *
   * @return The View associated with completion.
   *
   * @newin{2,10}
   */
  const View* get_view() const;

  // TODO: Does "The reference being returned is a 'floating' reference, so if you invoke gtk_source_completion_show with this context you don't need to unref it." something mean for us? krnowak
 

  /** Create a new CompletionContext for completion.
   *
   * The position at which the completion using the new context will consider
   * completion can be provided by @a position.
   *
   * @param position A Gtk::TextIter.
   *
   * @return A new CompletionContext.
   *
   * @newin{2,10}
   */
  Glib::RefPtr<CompletionContext> create_context(const Gtk::TextIter& position);

  // TODO: better wording could be used here - it is too convoluted. krnowak
  /** Create a new CompletionContext for completion.
   *
   * The position at which the completion using the new context will consider
   * completion is current cursor position.
   *
   * @return A new CompletionContext.
   *
   * @newin{2,10}
   */
  Glib::RefPtr<CompletionContext> create_context();

  
#ifndef GTKSOURCEVIEWMM_DISABLE_DEPRECATED

  /** Move the completion window to a specific iter.
   *
   * @param iter A Gtk::TextIter.
   *
   * @newin{2,10}
   */
  void move_window(const Gtk::TextIter& iter);
#endif // GTKSOURCEVIEWMM_DISABLE_DEPRECATED


  /** Block interactive completion.
   *
   * This can be used to disable interactive completion when inserting or
   * deleting text from the buffer associated with the completion. Use
   * unblock_interactive() to enable interactive completion again.
   *
   * @newin{2,10}
   */
  void block_interactive();

  
  /** Unblock interactive completion.
   *
   * This can be used after using block_interactive() to enable interactive
   * completion again.
   *
   * @newin{2,10}
   */
  void unblock_interactive();

  
  /** Emitted when the completion window is hidden.
   *
   * The default handler will actually hide the window.
   *
   * @newin{2,10}
   *
   * @par Slot Prototype:
   * <tt>void on_my_%hide()</tt>
   *
   */

  Glib::SignalProxy0< void > signal_hide();


  /** Emitted just before starting to populate the completion with providers.
   *
   * You can use this signal to add additional attributes in the context.
   *
   * @par Handler parameters:
   * context The context for current completion.
   *
   * @newin{2,10}
   *
   * @par Slot Prototype:
   * <tt>void on_my_%populate_context(const Glib::RefPtr<CompletionContext>& context)</tt>
   *
   */

  Glib::SignalProxy1< void,const Glib::RefPtr<CompletionContext>& > signal_populate_context();

 
  /** Emitted when the completion window is shown.
   *
   * The default handler will actually show the window.
   *
   * @newin{2,10}
   *
   * @par Slot Prototype:
   * <tt>void on_my_%show()</tt>
   *
   */

  Glib::SignalProxy0< void > signal_show();

// those are keybinding signals, so ignore them
  
  
  /** Number of proposal accelerators to show.
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< guint > property_accelerators() ;

/** Number of proposal accelerators to show.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< guint > property_accelerators() const;

  /** Completion popup delay for interactive completion.
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< guint > property_auto_complete_delay() ;

/** Completion popup delay for interactive completion.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< guint > property_auto_complete_delay() const;

  /** Proposal scrolling page size.
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< guint > property_proposal_page_size() ;

/** Proposal scrolling page size.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< guint > property_proposal_page_size() const;

  /** Provider scrolling page size.
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< guint > property_provider_page_size() ;

/** Provider scrolling page size.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< guint > property_provider_page_size() const;

  /** Remember the last info window visibility state.
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_remember_info_visibility() ;

/** Remember the last info window visibility state.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_remember_info_visibility() const;

  /** Select first proposal when completion is shown.
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_select_on_show() ;

/** Select first proposal when completion is shown.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_select_on_show() const;

  /** Show provider headers when proposals from multiple providers are available.
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_show_headers() ;

/** Show provider headers when proposals from multiple providers are available.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_show_headers() const;

  /** Show provider and proposal icons in the completion popup.
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_show_icons() ;

/** Show provider and proposal icons in the completion popup.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_show_icons() const;

  /** The GtkSourceView bound to the completion.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< View* > property_view() const;


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::
  /// This is a default handler for the signal signal_hide().
  virtual void on_hide();
  /// This is a default handler for the signal signal_populate_context().
  virtual void on_populate_context(const Glib::RefPtr<CompletionContext>& context);
  /// This is a default handler for the signal signal_show().
  virtual void on_show();


};

} /* namespace Gsv */


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gsv::Completion
   */
  Glib::RefPtr<Gsv::Completion> wrap(GtkSourceCompletion* object, bool take_copy = false);
}


#endif /* _GTKSOURCEVIEWMM_COMPLETION_H */

