/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.format.format;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.object.DynamicObject;
import java.math.BigInteger;
import org.jruby.truffle.Layouts;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.format.FormatNode;
import org.jruby.truffle.core.format.printf.PrintfSimpleTreeBuilder;
import org.jruby.util.ByteList;
import org.jruby.util.ConvertBytes;

@NodeChildren(value={@NodeChild(value="width", type=FormatNode.class), @NodeChild(value="precision", type=FormatNode.class), @NodeChild(value="value", type=FormatNode.class)})
public abstract class FormatIntegerNode
extends FormatNode {
    private static final byte[] PREFIX_OCTAL = new byte[]{48};
    private static final byte[] PREFIX_HEX_LC = new byte[]{48, 120};
    private static final byte[] PREFIX_HEX_UC = new byte[]{48, 88};
    private static final byte[] PREFIX_BINARY_LC = new byte[]{48, 98};
    private static final byte[] PREFIX_BINARY_UC = new byte[]{48, 66};
    private static final byte[] PREFIX_NEGATIVE = new byte[]{46, 46};
    private static final BigInteger BIG_32 = BigInteger.valueOf(0x100000000L);
    private static final BigInteger BIG_64 = BIG_32.shiftLeft(32);
    private static final BigInteger BIG_MINUS_32 = BigInteger.valueOf(-4294967296L);
    private static final BigInteger BIG_MINUS_64 = BIG_MINUS_32.shiftLeft(32);
    private final char format;
    private final boolean hasSpaceFlag;
    private final boolean hasZeroFlag;
    private final boolean hasPlusFlag;
    private final boolean hasMinusFlag;
    private final boolean hasFSharp;

    public FormatIntegerNode(RubyContext context, char format, boolean hasSpaceFlag, boolean hasZeroFlag, boolean hasPlusFlag, boolean hasMinusFlag, boolean hasFSharp) {
        super(context);
        this.format = format;
        this.hasSpaceFlag = hasSpaceFlag;
        this.hasZeroFlag = hasZeroFlag;
        this.hasPlusFlag = hasPlusFlag;
        this.hasMinusFlag = hasMinusFlag;
        this.hasFSharp = hasFSharp;
    }

    @CompilerDirectives.TruffleBoundary
    @Specialization
    public byte[] format(int width, int precision, int arg) {
        return this.format(width, precision, (long)arg);
    }

    @CompilerDirectives.TruffleBoundary
    @Specialization
    public byte[] format(int width, int precision, long arg) {
        boolean negative;
        char fchar = this.getFormatCharacter();
        boolean sign = this.getSign(fchar);
        int base = FormatIntegerNode.getBase(fchar);
        boolean zero = arg == 0L;
        boolean bl = negative = arg < 0L;
        byte[] bytes = negative && fchar == 'u' ? FormatIntegerNode.getUnsignedNegativeBytes(arg) : FormatIntegerNode.getFixnumBytes(arg, base, sign, fchar == 'X');
        return this.formatBytes(width, precision, fchar, sign, base, zero, negative, bytes);
    }

    @CompilerDirectives.TruffleBoundary
    @Specialization(guards={"isRubyBignum(value)"})
    public byte[] format(int width, int precision, DynamicObject value) {
        BigInteger bigInteger = Layouts.BIGNUM.getValue(value);
        boolean negative = bigInteger.signum() < 0;
        boolean zero = bigInteger.equals(BigInteger.ZERO);
        char fchar = this.getFormatCharacter();
        boolean sign = this.getSign(fchar);
        int base = FormatIntegerNode.getBase(fchar);
        byte[] bytes = negative && fchar == 'u' ? this.getUnsignedNegativeBytes(bigInteger) : FormatIntegerNode.getBignumBytes(bigInteger, base, sign, fchar == 'X');
        return this.formatBytes(width, precision, fchar, sign, base, zero, negative, bytes);
    }

    private byte[] formatBytes(int width, int precision, char fchar, boolean sign, int base, boolean zero, boolean negative, byte[] bytes) {
        boolean hasPrecisionFlag;
        boolean hasMinusFlag = this.hasMinusFlag;
        if (width == PrintfSimpleTreeBuilder.DEFAULT) {
            width = 0;
        } else if (width < 0) {
            hasMinusFlag = true;
            width = -width;
        }
        if (precision < 0) {
            precision = PrintfSimpleTreeBuilder.DEFAULT;
        }
        int first = 0;
        byte[] prefix = null;
        byte signChar = 0;
        byte leadChar = 0;
        ByteList buf = new ByteList();
        if (this.hasFSharp) {
            if (!zero) {
                switch (fchar) {
                    case 'o': {
                        prefix = PREFIX_OCTAL;
                        break;
                    }
                    case 'x': {
                        prefix = PREFIX_HEX_LC;
                        break;
                    }
                    case 'X': {
                        prefix = PREFIX_HEX_UC;
                        break;
                    }
                    case 'b': {
                        prefix = PREFIX_BINARY_LC;
                        break;
                    }
                    case 'B': {
                        prefix = PREFIX_BINARY_UC;
                    }
                }
            }
            if (prefix != null) {
                width -= prefix.length;
            }
        }
        int len = 0;
        if (sign) {
            if (negative) {
                signChar = 45;
                --width;
                first = 1;
            } else if (this.hasPlusFlag) {
                signChar = 43;
                --width;
            } else if (this.hasSpaceFlag) {
                signChar = 32;
                --width;
            }
        } else if (negative) {
            if (base == 10) {
                leadChar = 46;
                len += 2;
            } else {
                if (!this.hasZeroFlag && precision == PrintfSimpleTreeBuilder.DEFAULT) {
                    len += 2;
                }
                first = FormatIntegerNode.skipSignBits(bytes, base);
                switch (fchar) {
                    case 'B': 
                    case 'b': {
                        leadChar = 49;
                        break;
                    }
                    case 'o': {
                        leadChar = 55;
                        break;
                    }
                    case 'x': {
                        leadChar = 102;
                        break;
                    }
                    case 'X': {
                        leadChar = 70;
                    }
                }
                if (leadChar != 0) {
                    ++len;
                }
            }
        }
        int numlen = bytes.length - first;
        len += numlen;
        boolean bl = hasPrecisionFlag = precision != PrintfSimpleTreeBuilder.DEFAULT;
        if (this.hasZeroFlag && !hasPrecisionFlag) {
            precision = width;
            width = 0;
        } else {
            if (precision < len) {
                precision = len;
            }
            width -= precision;
        }
        if (!hasMinusFlag) {
            buf.fill(32, width);
            width = 0;
        }
        if (signChar != 0) {
            buf.append(signChar);
        }
        if (prefix != null) {
            buf.append(prefix);
        }
        if (len < precision) {
            if (leadChar == 0) {
                if (fchar != 'd' || !negative || hasPrecisionFlag || this.hasZeroFlag && !hasMinusFlag) {
                    buf.fill(48, precision - len);
                }
            } else if (leadChar == 46) {
                buf.fill((int)leadChar, precision - len);
                buf.append(PREFIX_NEGATIVE);
            } else {
                buf.append(PREFIX_NEGATIVE);
                buf.fill((int)leadChar, precision - len - 1);
            }
        } else if (leadChar != 0) {
            if ("xXbBo".indexOf(fchar) != -1) {
                buf.append(PREFIX_NEGATIVE);
            }
            if (leadChar != 46) {
                buf.append(leadChar);
            }
        }
        buf.append(bytes, first, numlen);
        if (width > 0) {
            buf.fill(32, width);
        }
        if (len < precision && fchar == 'd' && negative && hasMinusFlag) {
            buf.fill(32, precision - len);
        }
        return buf.bytes();
    }

    private boolean getSign(char fchar) {
        return fchar == 'd' || this.hasSpaceFlag || this.hasPlusFlag;
    }

    private static int getBase(char fchar) {
        int base;
        switch (fchar) {
            case 'o': {
                base = 8;
                break;
            }
            case 'X': 
            case 'x': {
                base = 16;
                break;
            }
            case 'B': 
            case 'b': {
                base = 2;
                break;
            }
            default: {
                base = 10;
            }
        }
        return base;
    }

    private static byte[] getFixnumBytes(long arg, int base, boolean sign, boolean upper) {
        long val = arg;
        if (val >= Integer.MIN_VALUE && val <= Integer.MAX_VALUE) {
            if (sign) {
                return ConvertBytes.intToByteArray((int)((int)val), (int)base, (boolean)upper);
            }
            switch (base) {
                case 2: {
                    return ConvertBytes.intToBinaryBytes((int)((int)val));
                }
                case 8: {
                    return ConvertBytes.intToOctalBytes((int)((int)val));
                }
                default: {
                    return ConvertBytes.intToCharBytes((int)((int)val));
                }
                case 16: 
            }
            return ConvertBytes.intToHexBytes((int)((int)val), (boolean)upper);
        }
        if (sign) {
            return ConvertBytes.longToByteArray((long)val, (int)base, (boolean)upper);
        }
        switch (base) {
            case 2: {
                return ConvertBytes.longToBinaryBytes((long)val);
            }
            case 8: {
                return ConvertBytes.longToOctalBytes((long)val);
            }
            default: {
                return ConvertBytes.longToCharBytes((long)val);
            }
            case 16: 
        }
        return ConvertBytes.longToHexBytes((long)val, (boolean)upper);
    }

    private static int skipSignBits(byte[] bytes, int base) {
        int skip;
        int length = bytes.length;
        switch (base) {
            case 2: {
                for (skip = 0; skip < length && bytes[skip] == 49; ++skip) {
                }
                break;
            }
            case 8: {
                if (length > 0 && bytes[0] == 51) {
                    ++skip;
                }
                while (skip < length && bytes[skip] == 55) {
                    ++skip;
                }
                break;
            }
            case 10: {
                if (length <= 0 || bytes[0] != 45) break;
                ++skip;
                break;
            }
            case 16: {
                byte b;
                while (skip < length && ((b = bytes[skip]) == 102 || b == 70)) {
                    ++skip;
                }
                break;
            }
        }
        return skip;
    }

    private static byte[] getUnsignedNegativeBytes(long arg) {
        return ConvertBytes.longToCharBytes((long)(0L + arg));
    }

    private char getFormatCharacter() {
        int fchar = this.format;
        if (fchar == 105) {
            fchar = 100;
        }
        if (fchar == 117 && (this.hasSpaceFlag || this.hasPlusFlag)) {
            fchar = 100;
        }
        return (char)fchar;
    }

    private byte[] getUnsignedNegativeBytes(BigInteger bigval) {
        int shift = 0;
        BigInteger minus = BIG_MINUS_64;
        while (bigval.compareTo(minus) < 0) {
            minus = minus.shiftLeft(32);
            ++shift;
        }
        BigInteger nPower32 = shift > 0 ? BIG_64.shiftLeft(32 * shift) : BIG_64;
        return FormatIntegerNode.stringToBytes(nPower32.add(bigval).toString(), false);
    }

    private static byte[] getBignumBytes(BigInteger val, int base, boolean sign, boolean upper) {
        if (sign || base == 10 || val.signum() >= 0) {
            return FormatIntegerNode.stringToBytes(val.toString(base), upper);
        }
        byte[] bytes = val.toByteArray();
        switch (base) {
            case 2: {
                return ConvertBytes.twosComplementToBinaryBytes((byte[])bytes);
            }
            case 8: {
                return ConvertBytes.twosComplementToOctalBytes((byte[])bytes);
            }
            case 16: {
                return ConvertBytes.twosComplementToHexBytes((byte[])bytes, (boolean)upper);
            }
        }
        return FormatIntegerNode.stringToBytes(val.toString(base), upper);
    }

    private static byte[] stringToBytes(CharSequence s, boolean upper) {
        int len = s.length();
        byte[] bytes = new byte[len];
        if (upper) {
            int i = len;
            while (--i >= 0) {
                byte b = (byte)(s.charAt(i) & 0xFF);
                if (b >= 97 && b <= 122) {
                    bytes[i] = (byte)(b & 0xFFFFFFDF);
                    continue;
                }
                bytes[i] = b;
            }
        } else {
            int i = len;
            while (--i >= 0) {
                bytes[i] = (byte)(s.charAt(i) & 0xFF);
            }
        }
        return bytes;
    }
}

