/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.socket;

import java.io.IOException;
import java.nio.channels.SelectableChannel;
import jnr.unixsocket.UnixServerSocketChannel;
import jnr.unixsocket.UnixSocketChannel;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.ast.util.ArgsUtil;
import org.jruby.ext.socket.RubyUNIXSocket;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

@JRubyClass(name={"UNIXServer"}, parent="UNIXSocket")
public class RubyUNIXServer
extends RubyUNIXSocket {
    private static ObjectAllocator UNIXSERVER_ALLOCATOR = new ObjectAllocator(){

        @Override
        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return new RubyUNIXServer(runtime, klass);
        }
    };

    static void createUNIXServer(Ruby runtime) {
        RubyClass rb_cUNIXServer = runtime.defineClass("UNIXServer", runtime.getClass("UNIXSocket"), UNIXSERVER_ALLOCATOR);
        runtime.getObject().setConstant("UNIXserver", rb_cUNIXServer);
        rb_cUNIXServer.defineAnnotatedMethods(RubyUNIXServer.class);
    }

    public RubyUNIXServer(Ruby runtime, RubyClass type2) {
        super(runtime, type2);
    }

    @Override
    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, IRubyObject path2) {
        this.init_unixsock(context.runtime, path2, true);
        return this;
    }

    @JRubyMethod
    public IRubyObject accept(ThreadContext context) {
        Ruby runtime = context.runtime;
        try {
            boolean ready2;
            while (!(ready2 = context.getThread().select(this, 16))) {
                context.pollThreadEvents();
            }
            UnixSocketChannel socketChannel = this.asUnixServer().accept();
            RubyUNIXSocket sock = (RubyUNIXSocket)Helpers.invoke(context, runtime.getClass("UNIXSocket"), "allocate");
            sock.init_sock(context.runtime, socketChannel, "");
            return sock;
        }
        catch (IOException ioe) {
            throw context.runtime.newIOErrorFromException(ioe);
        }
    }

    @JRubyMethod
    public IRubyObject accept_nonblock(ThreadContext context) {
        return this.accept_nonblock(context, context.runtime, true);
    }

    @JRubyMethod
    public IRubyObject accept_nonblock(ThreadContext context, IRubyObject _opts) {
        Ruby runtime = context.runtime;
        boolean exception2 = ArgsUtil.extractKeywordArg(context, "exception", _opts) != runtime.getFalse();
        return this.accept_nonblock(context, runtime, exception2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject accept_nonblock(ThreadContext context, Ruby runtime, boolean ex) {
        SelectableChannel selectable = (SelectableChannel)this.getChannel();
        Object object = selectable.blockingLock();
        synchronized (object) {
            RubyUNIXSocket rubyUNIXSocket;
            boolean oldBlocking = selectable.isBlocking();
            selectable.configureBlocking(false);
            try {
                UnixSocketChannel socketChannel = ((UnixServerSocketChannel)selectable).accept();
                RubyUNIXSocket sock = (RubyUNIXSocket)Helpers.invoke(context, runtime.getClass("UNIXSocket"), "allocate");
                sock.init_sock(context.runtime, socketChannel, "");
                rubyUNIXSocket = sock;
            }
            catch (Throwable throwable) {
                try {
                    selectable.configureBlocking(oldBlocking);
                    throw throwable;
                }
                catch (IOException ioe) {
                    if (ioe.getMessage().equals("accept failed: Resource temporarily unavailable")) {
                        if (!ex) {
                            return runtime.newSymbol("wait_readable");
                        }
                        throw runtime.newErrnoEAGAINReadableError("accept");
                    }
                    throw context.runtime.newIOErrorFromException(ioe);
                }
            }
            selectable.configureBlocking(oldBlocking);
            return rubyUNIXSocket;
        }
    }

    @JRubyMethod
    public IRubyObject listen(ThreadContext context, IRubyObject log) {
        return context.runtime.newFixnum(0);
    }

    @JRubyMethod
    public IRubyObject sysaccept(ThreadContext context) {
        return this.accept(context);
    }

    @Override
    @JRubyMethod
    public IRubyObject path(ThreadContext context) {
        return context.runtime.newString(this.openFile.getPath());
    }

    @Override
    @JRubyMethod
    public IRubyObject addr(ThreadContext context) {
        Ruby runtime = context.runtime;
        return runtime.newArray((IRubyObject)runtime.newString("AF_UNIX"), (IRubyObject)runtime.newString(this.openFile.getPath()));
    }

    @Override
    @JRubyMethod
    public IRubyObject peeraddr(ThreadContext context) {
        throw context.runtime.newErrnoENOTCONNError();
    }

    private UnixServerSocketChannel asUnixServer() {
        return (UnixServerSocketChannel)this.getChannel();
    }
}

