/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient.contrib.ssl;

import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpHost;
import org.apache.commons.httpclient.HttpsURL;
import org.apache.commons.httpclient.contrib.ssl.EasySSLProtocolSocketFactory;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;

public class HttpHostFactory {
    public static final HttpHostFactory DEFAULT = new HttpHostFactory(null, new Protocol(new String(HttpsURL.DEFAULT_SCHEME), (ProtocolSocketFactory)new EasySSLProtocolSocketFactory(), 443));
    protected final Protocol httpProtocol;
    protected final Protocol httpsProtocol;

    public HttpHostFactory(Protocol httpProtocol, Protocol httpsProtocol) {
        this.httpProtocol = httpProtocol;
        this.httpsProtocol = httpsProtocol;
    }

    public HttpHost getHost(HostConfiguration old, String scheme, String host, int port) {
        return new HttpHost(host, port, this.getProtocol(old, scheme, host, port));
    }

    protected Protocol getProtocol(HostConfiguration old, String scheme, String host, int port) {
        Protocol newProtocol;
        String oldScheme;
        Protocol oldProtocol = old.getProtocol();
        if (oldProtocol != null && ((oldScheme = oldProtocol.getScheme()) == scheme || oldScheme != null && oldScheme.equalsIgnoreCase(scheme))) {
            return oldProtocol;
        }
        Protocol protocol = newProtocol = scheme != null && scheme.toLowerCase().endsWith("s") ? this.httpsProtocol : this.httpProtocol;
        if (newProtocol == null) {
            newProtocol = Protocol.getProtocol((String)scheme);
        }
        return newProtocol;
    }
}

