/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.stdlib.bigdecimal;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.ConditionProfile;
import java.math.BigDecimal;
import java.math.MathContext;
import org.jruby.truffle.Layouts;
import org.jruby.truffle.stdlib.bigdecimal.BigDecimalOpNode;
import org.jruby.truffle.stdlib.bigdecimal.BigDecimalType;

public abstract class AbstractMultNode
extends BigDecimalOpNode {
    private final ConditionProfile zeroNormal = ConditionProfile.createBinaryProfile();

    private Object multBigDecimalConsideringSignum(DynamicObject a, DynamicObject b, MathContext mathContext) {
        BigDecimal bBigDecimal = Layouts.BIG_DECIMAL.getValue(b);
        if (this.zeroNormal.profile(AbstractMultNode.isNormalZero(a) && bBigDecimal.signum() == -1)) {
            return BigDecimalType.NEGATIVE_ZERO;
        }
        return this.multBigDecimal(Layouts.BIG_DECIMAL.getValue(a), bBigDecimal, mathContext);
    }

    @CompilerDirectives.TruffleBoundary
    private Object multBigDecimal(BigDecimal a, BigDecimal b, MathContext mathContext) {
        return a.multiply(b, mathContext);
    }

    protected Object mult(VirtualFrame frame, DynamicObject a, DynamicObject b, int precision) {
        return this.createBigDecimal(frame, this.multBigDecimalConsideringSignum(a, b, new MathContext(precision, this.getRoundMode(frame))));
    }

    protected Object multNormalSpecial(VirtualFrame frame, DynamicObject a, DynamicObject b, int precision) {
        return this.multSpecialNormal(frame, b, a, precision);
    }

    protected Object multSpecialNormal(VirtualFrame frame, DynamicObject a, DynamicObject b, int precision) {
        Object value = null;
        switch (Layouts.BIG_DECIMAL.getType(a)) {
            case NAN: {
                value = BigDecimalType.NAN;
                break;
            }
            case NEGATIVE_ZERO: {
                switch (Layouts.BIG_DECIMAL.getValue(b).signum()) {
                    case 0: 
                    case 1: {
                        value = BigDecimalType.NEGATIVE_ZERO;
                        break;
                    }
                    case -1: {
                        value = BigDecimal.ZERO;
                    }
                }
                break;
            }
            case POSITIVE_INFINITY: {
                switch (Layouts.BIG_DECIMAL.getValue(b).signum()) {
                    case 1: {
                        value = BigDecimalType.POSITIVE_INFINITY;
                        break;
                    }
                    case 0: {
                        value = BigDecimalType.NAN;
                        break;
                    }
                    case -1: {
                        value = BigDecimalType.NEGATIVE_INFINITY;
                    }
                }
                break;
            }
            case NEGATIVE_INFINITY: {
                switch (Layouts.BIG_DECIMAL.getValue(b).signum()) {
                    case 1: {
                        value = BigDecimalType.NEGATIVE_INFINITY;
                        break;
                    }
                    case 0: {
                        value = BigDecimalType.NAN;
                        break;
                    }
                    case -1: {
                        value = BigDecimalType.POSITIVE_INFINITY;
                    }
                }
                break;
            }
            default: {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw new UnsupportedOperationException("unreachable code branch");
            }
        }
        return this.createBigDecimal(frame, value);
    }

    protected Object multSpecial(VirtualFrame frame, DynamicObject a, DynamicObject b, int precision) {
        BigDecimalType aType = Layouts.BIG_DECIMAL.getType(a);
        BigDecimalType bType = Layouts.BIG_DECIMAL.getType(b);
        if (aType == BigDecimalType.NAN || bType == BigDecimalType.NAN) {
            return this.createBigDecimal(frame, (Object)BigDecimalType.NAN);
        }
        if (aType == BigDecimalType.NEGATIVE_ZERO && bType == BigDecimalType.NEGATIVE_ZERO) {
            return this.createBigDecimal(frame, BigDecimal.ZERO);
        }
        if (aType == BigDecimalType.NEGATIVE_ZERO || bType == BigDecimalType.NEGATIVE_ZERO) {
            return this.createBigDecimal(frame, (Object)BigDecimalType.NAN);
        }
        if (aType == BigDecimalType.POSITIVE_INFINITY) {
            if (bType == BigDecimalType.POSITIVE_INFINITY) {
                return a;
            }
            return this.createBigDecimal(frame, (Object)BigDecimalType.NEGATIVE_INFINITY);
        }
        if (aType == BigDecimalType.NEGATIVE_INFINITY) {
            if (bType == BigDecimalType.POSITIVE_INFINITY) {
                return a;
            }
            return this.createBigDecimal(frame, (Object)BigDecimalType.POSITIVE_INFINITY);
        }
        throw new UnsupportedOperationException("unreachable code branch");
    }
}

