/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.ldap;

import com.sun.jndi.ldap.Ber;
import com.sun.jndi.ldap.BerDecoder;
import com.sun.jndi.ldap.BerEncoder;
import com.sun.jndi.ldap.LdapClient;
import com.sun.jndi.ldap.LdapRequest;
import com.sun.jndi.ldap.Obj;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.Socket;
import java.util.Arrays;
import javax.naming.CommunicationException;
import javax.naming.InterruptedNamingException;
import javax.naming.NamingException;
import javax.naming.ServiceUnavailableException;
import javax.naming.ldap.Control;
import javax.net.ssl.SSLSocket;
import sun.misc.IOUtils;

public final class Connection
implements Runnable {
    private static final boolean debug = false;
    private static final int dump = 0;
    private final Thread worker;
    private boolean v3 = true;
    public final String host;
    public final int port;
    private boolean bound = false;
    private OutputStream traceFile = null;
    private String traceTagIn = null;
    private String traceTagOut = null;
    public InputStream inStream;
    public OutputStream outStream;
    public Socket sock;
    private final LdapClient parent;
    private int outMsgId = 0;
    private LdapRequest pendingRequests = null;
    volatile IOException closureReason = null;
    volatile boolean useable = true;
    int readTimeout;
    int connectTimeout;
    private Object pauseLock = new Object();
    private boolean paused = false;

    void setV3(boolean bl) {
        this.v3 = bl;
    }

    void setBound() {
        this.bound = true;
    }

    Connection(LdapClient ldapClient, String string, int n, String string2, int n2, int n3, OutputStream outputStream) throws NamingException {
        this.host = string;
        this.port = n;
        this.parent = ldapClient;
        this.readTimeout = n3;
        this.connectTimeout = n2;
        if (outputStream != null) {
            this.traceFile = outputStream;
            this.traceTagIn = "<- " + string + ":" + n + "\n\n";
            this.traceTagOut = "-> " + string + ":" + n + "\n\n";
        }
        try {
            this.sock = this.createSocket(string, n, string2, n2);
            this.inStream = new BufferedInputStream(this.sock.getInputStream());
            this.outStream = new BufferedOutputStream(this.sock.getOutputStream());
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            CommunicationException communicationException = new CommunicationException(string + ":" + n);
            communicationException.setRootCause(throwable);
            throw communicationException;
        }
        catch (Exception exception) {
            CommunicationException communicationException = new CommunicationException(string + ":" + n);
            communicationException.setRootCause(exception);
            throw communicationException;
        }
        this.worker = Obj.helper.createThread(this);
        this.worker.setDaemon(true);
        this.worker.start();
    }

    private Object createInetSocketAddress(String string, int n) throws NoSuchMethodException {
        try {
            Class<?> clazz = Class.forName("java.net.InetSocketAddress");
            Constructor<?> constructor = clazz.getConstructor(String.class, Integer.TYPE);
            return constructor.newInstance(string, new Integer(n));
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | InvocationTargetException reflectiveOperationException) {
            throw new NoSuchMethodException();
        }
    }

    private Socket createSocket(String string, int n, String string2, int n2) throws Exception {
        Method method;
        Object object;
        Socket socket = null;
        if (string2 != null) {
            object = Obj.helper.loadClass(string2);
            method = ((Class)object).getMethod("getDefault", new Class[0]);
            Object object2 = method.invoke(null, new Object[0]);
            Method method2 = null;
            if (n2 > 0) {
                try {
                    method2 = ((Class)object).getMethod("createSocket", new Class[0]);
                    Method method3 = Socket.class.getMethod("connect", Class.forName("java.net.SocketAddress"), Integer.TYPE);
                    Object object3 = this.createInetSocketAddress(string, n);
                    socket = (Socket)method2.invoke(object2, new Object[0]);
                    method3.invoke(socket, object3, new Integer(n2));
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
            if (socket == null) {
                method2 = ((Class)object).getMethod("createSocket", String.class, Integer.TYPE);
                socket = (Socket)method2.invoke(object2, string, new Integer(n));
            }
        } else {
            if (n2 > 0) {
                try {
                    object = Socket.class.getConstructor(new Class[0]);
                    method = Socket.class.getMethod("connect", Class.forName("java.net.SocketAddress"), Integer.TYPE);
                    Object object4 = this.createInetSocketAddress(string, n);
                    socket = (Socket)((Constructor)object).newInstance(new Object[0]);
                    method.invoke(socket, object4, new Integer(n2));
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
            if (socket == null) {
                socket = new Socket(string, n);
            }
        }
        if (n2 > 0 && socket instanceof SSLSocket) {
            object = (SSLSocket)socket;
            int n3 = ((Socket)object).getSoTimeout();
            ((Socket)object).setSoTimeout(n2);
            ((SSLSocket)object).startHandshake();
            ((Socket)object).setSoTimeout(n3);
        }
        return socket;
    }

    synchronized int getMsgId() {
        return ++this.outMsgId;
    }

    LdapRequest writeRequest(BerEncoder berEncoder, int n) throws IOException {
        return this.writeRequest(berEncoder, n, false, -1);
    }

    LdapRequest writeRequest(BerEncoder berEncoder, int n, boolean bl) throws IOException {
        return this.writeRequest(berEncoder, n, bl, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    LdapRequest writeRequest(BerEncoder berEncoder, int n, boolean bl, int n2) throws IOException {
        LdapRequest ldapRequest = new LdapRequest(n, bl, n2);
        this.addRequest(ldapRequest);
        if (this.traceFile != null) {
            Ber.dumpBER(this.traceFile, this.traceTagOut, berEncoder.getBuf(), 0, berEncoder.getDataLen());
        }
        this.unpauseReader();
        try {
            Connection connection = this;
            synchronized (connection) {
                this.outStream.write(berEncoder.getBuf(), 0, berEncoder.getDataLen());
                this.outStream.flush();
            }
        }
        catch (IOException iOException) {
            this.cleanup(null, true);
            this.closureReason = iOException;
            throw this.closureReason;
        }
        return ldapRequest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BerDecoder readReply(LdapRequest ldapRequest) throws IOException, NamingException {
        BerDecoder berDecoder;
        long l = 0L;
        long l2 = 0L;
        while ((berDecoder = ldapRequest.getReplyBer()) == null && (this.readTimeout <= 0 || l < (long)this.readTimeout)) {
            try {
                Object object = this;
                synchronized (object) {
                    if (this.sock == null) {
                        throw new ServiceUnavailableException(this.host + ":" + this.port + "; socket closed");
                    }
                }
                object = ldapRequest;
                synchronized (object) {
                    berDecoder = ldapRequest.getReplyBer();
                    if (berDecoder != null) {
                        break;
                    }
                    if (this.readTimeout > 0) {
                        long l3 = System.nanoTime();
                        ldapRequest.wait((long)this.readTimeout - l);
                        l += (l2 += System.nanoTime() - l3) / 1000000L;
                        l2 %= 1000000L;
                    } else {
                        ldapRequest.wait();
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                throw new InterruptedNamingException("Interrupted during LDAP operation");
            }
        }
        if (berDecoder == null && l >= (long)this.readTimeout) {
            this.abandonRequest(ldapRequest, null);
            throw new NamingException("LDAP response read timed out, timeout used:" + this.readTimeout + "ms.");
        }
        return berDecoder;
    }

    private synchronized void addRequest(LdapRequest ldapRequest) {
        LdapRequest ldapRequest2 = this.pendingRequests;
        if (ldapRequest2 == null) {
            this.pendingRequests = ldapRequest;
            ldapRequest.next = null;
        } else {
            ldapRequest.next = this.pendingRequests;
            this.pendingRequests = ldapRequest;
        }
    }

    synchronized LdapRequest findRequest(int n) {
        LdapRequest ldapRequest = this.pendingRequests;
        while (ldapRequest != null) {
            if (ldapRequest.msgId == n) {
                return ldapRequest;
            }
            ldapRequest = ldapRequest.next;
        }
        return null;
    }

    synchronized void removeRequest(LdapRequest ldapRequest) {
        LdapRequest ldapRequest2 = this.pendingRequests;
        LdapRequest ldapRequest3 = null;
        while (ldapRequest2 != null) {
            if (ldapRequest2 == ldapRequest) {
                ldapRequest2.cancel();
                if (ldapRequest3 != null) {
                    ldapRequest3.next = ldapRequest2.next;
                } else {
                    this.pendingRequests = ldapRequest2.next;
                }
                ldapRequest2.next = null;
            }
            ldapRequest3 = ldapRequest2;
            ldapRequest2 = ldapRequest2.next;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void abandonRequest(LdapRequest ldapRequest, Control[] controlArray) {
        this.removeRequest(ldapRequest);
        BerEncoder berEncoder = new BerEncoder(256);
        int n = this.getMsgId();
        try {
            berEncoder.beginSeq(48);
            berEncoder.encodeInt(n);
            berEncoder.encodeInt(ldapRequest.msgId, 80);
            if (this.v3) {
                LdapClient.encodeControls(berEncoder, controlArray);
            }
            berEncoder.endSeq();
            if (this.traceFile != null) {
                Ber.dumpBER(this.traceFile, this.traceTagOut, berEncoder.getBuf(), 0, berEncoder.getDataLen());
            }
            Connection connection = this;
            synchronized (connection) {
                this.outStream.write(berEncoder.getBuf(), 0, berEncoder.getDataLen());
                this.outStream.flush();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    synchronized void abandonOutstandingReqs(Control[] controlArray) {
        LdapRequest ldapRequest = this.pendingRequests;
        while (ldapRequest != null) {
            this.abandonRequest(ldapRequest, controlArray);
            this.pendingRequests = ldapRequest = ldapRequest.next;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ldapUnbind(Control[] controlArray) {
        BerEncoder berEncoder = new BerEncoder(256);
        int n = this.getMsgId();
        try {
            berEncoder.beginSeq(48);
            berEncoder.encodeInt(n);
            berEncoder.encodeByte(66);
            berEncoder.encodeByte(0);
            if (this.v3) {
                LdapClient.encodeControls(berEncoder, controlArray);
            }
            berEncoder.endSeq();
            if (this.traceFile != null) {
                Ber.dumpBER(this.traceFile, this.traceTagOut, berEncoder.getBuf(), 0, berEncoder.getDataLen());
            }
            Connection connection = this;
            synchronized (connection) {
                this.outStream.write(berEncoder.getBuf(), 0, berEncoder.getDataLen());
                this.outStream.flush();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    void cleanup(Control[] controlArray, boolean bl) {
        boolean bl2 = false;
        Connection connection = this;
        synchronized (connection) {
            LdapRequest ldapRequest;
            block21: {
                block22: {
                    block20: {
                        this.useable = false;
                        if (this.sock == null) break block21;
                        if (!bl) {
                            this.abandonOutstandingReqs(controlArray);
                        }
                        if (!this.bound) break block20;
                        this.ldapUnbind(controlArray);
                    }
                    try {
                        this.outStream.flush();
                        this.sock.close();
                        this.unpauseReader();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    if (!bl) {
                        ldapRequest = this.pendingRequests;
                        while (ldapRequest != null) {
                            ldapRequest.cancel();
                            ldapRequest = ldapRequest.next;
                        }
                    }
                    break block22;
                    catch (Throwable throwable) {
                        try {
                            this.outStream.flush();
                            this.sock.close();
                            this.unpauseReader();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        if (!bl) {
                            LdapRequest ldapRequest2 = this.pendingRequests;
                            while (ldapRequest2 != null) {
                                ldapRequest2.cancel();
                                ldapRequest2 = ldapRequest2.next;
                            }
                        }
                        this.sock = null;
                        throw throwable;
                    }
                }
                this.sock = null;
                bl2 = bl;
            }
            if (bl2) {
                ldapRequest = this.pendingRequests;
                while (ldapRequest != null) {
                    LdapRequest ldapRequest3 = ldapRequest;
                    synchronized (ldapRequest3) {
                        ldapRequest.notify();
                        ldapRequest = ldapRequest.next;
                    }
                }
            }
        }
        if (bl2) {
            this.parent.processConnectionClosure();
        }
    }

    public synchronized void replaceStreams(InputStream inputStream, OutputStream outputStream) {
        this.inStream = inputStream;
        try {
            this.outStream.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.outStream = outputStream;
    }

    private synchronized InputStream getInputStream() {
        return this.inStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unpauseReader() throws IOException {
        Object object = this.pauseLock;
        synchronized (object) {
            if (this.paused) {
                this.paused = false;
                this.pauseLock.notify();
            }
        }
    }

    private void pauseReader() throws IOException {
        this.paused = true;
        try {
            while (this.paused) {
                this.pauseLock.wait();
            }
        }
        catch (InterruptedException interruptedException) {
            throw new InterruptedIOException("Pause/unpause reader has problems.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block25: {
            InputStream inputStream = null;
            block12: while (true) {
                try {
                    while (true) {
                        try {
                            while (true) {
                                byte[] byArray = new byte[129];
                                int n = 0;
                                int n2 = 0;
                                int n3 = 0;
                                inputStream = this.getInputStream();
                                int n4 = inputStream.read(byArray, n, 1);
                                if (n4 < 0) {
                                    if (inputStream != this.getInputStream()) {
                                        continue;
                                    }
                                    break block25;
                                }
                                if (byArray[n++] != 48) continue;
                                n4 = inputStream.read(byArray, n, 1);
                                if (n4 < 0) {
                                    break block25;
                                }
                                if (((n2 = byArray[n++]) & 0x80) == 128) {
                                    int n5;
                                    n3 = n2 & 0x7F;
                                    boolean bl = false;
                                    for (n4 = 0; n4 < n3; n4 += n5) {
                                        n5 = inputStream.read(byArray, n + n4, n3 - n4);
                                        if (n5 >= 0) continue;
                                        bl = true;
                                        break;
                                    }
                                    if (bl) {
                                        break block25;
                                    }
                                    n2 = 0;
                                    for (int i = 0; i < n3; ++i) {
                                        n2 = (n2 << 8) + (byArray[n + i] & 0xFF);
                                    }
                                    n += n4;
                                }
                                byte[] byArray2 = IOUtils.readFully(inputStream, n2, false);
                                byArray = Arrays.copyOf(byArray, n + byArray2.length);
                                System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
                                n += byArray2.length;
                                try {
                                    BerDecoder berDecoder = new BerDecoder(byArray, 0, n);
                                    if (this.traceFile != null) {
                                        Ber.dumpBER(this.traceFile, this.traceTagIn, byArray, 0, n);
                                    }
                                    berDecoder.parseSeq(null);
                                    int n6 = berDecoder.parseInt();
                                    berDecoder.reset();
                                    boolean bl = false;
                                    if (n6 == 0) {
                                        this.parent.processUnsolicited(berDecoder);
                                        continue block12;
                                    }
                                    LdapRequest ldapRequest = this.findRequest(n6);
                                    if (ldapRequest == null) continue block12;
                                    Object object = this.pauseLock;
                                    synchronized (object) {
                                        bl = ldapRequest.addReplyBer(berDecoder);
                                        if (bl) {
                                            this.pauseReader();
                                        }
                                        continue block12;
                                    }
                                }
                                catch (Ber.DecodeException decodeException) {
                                    continue;
                                }
                                break;
                            }
                        }
                        catch (IOException iOException) {
                            if (inputStream != this.getInputStream()) continue;
                            throw iOException;
                        }
                        break;
                    }
                }
                catch (IOException iOException) {
                    this.closureReason = iOException;
                    break block25;
                }
            }
            finally {
                this.cleanup(null, true);
            }
        }
    }
}

