/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5.internal.rcache;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.SeekableByteChannel;
import java.nio.charset.StandardCharsets;
import java.util.StringTokenizer;
import sun.security.krb5.internal.rcache.AuthTimeWithHash;

public class AuthTime {
    final int ctime;
    final int cusec;
    final String client;
    final String server;

    public AuthTime(String string, String string2, int n, int n2) {
        this.ctime = n;
        this.cusec = n2;
        this.client = string;
        this.server = string2;
    }

    public String toString() {
        return String.format("%d/%06d/----/%s", this.ctime, this.cusec, this.client);
    }

    private static String readStringWithLength(SeekableByteChannel seekableByteChannel) throws IOException {
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        byteBuffer.order(ByteOrder.nativeOrder());
        seekableByteChannel.read(byteBuffer);
        byteBuffer.flip();
        int n = byteBuffer.getInt();
        if (n > 1024) {
            throw new IOException("Invalid string length");
        }
        byteBuffer = ByteBuffer.allocate(n);
        if (seekableByteChannel.read(byteBuffer) != n) {
            throw new IOException("Not enough string");
        }
        byte[] byArray = byteBuffer.array();
        return byArray[n - 1] == 0 ? new String(byArray, 0, n - 1, StandardCharsets.UTF_8) : new String(byArray, StandardCharsets.UTF_8);
    }

    public static AuthTime readFrom(SeekableByteChannel seekableByteChannel) throws IOException {
        String string = AuthTime.readStringWithLength(seekableByteChannel);
        String string2 = AuthTime.readStringWithLength(seekableByteChannel);
        ByteBuffer byteBuffer = ByteBuffer.allocate(8);
        seekableByteChannel.read(byteBuffer);
        byteBuffer.order(ByteOrder.nativeOrder());
        int n = byteBuffer.getInt(0);
        int n2 = byteBuffer.getInt(4);
        if (string.isEmpty()) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, " :");
            if (stringTokenizer.countTokens() != 6) {
                throw new IOException("Incorrect rcache style");
            }
            stringTokenizer.nextToken();
            String string3 = stringTokenizer.nextToken();
            stringTokenizer.nextToken();
            string = stringTokenizer.nextToken();
            stringTokenizer.nextToken();
            string2 = stringTokenizer.nextToken();
            return new AuthTimeWithHash(string, string2, n2, n, string3);
        }
        return new AuthTime(string, string2, n2, n);
    }

    protected byte[] encode0(String string, String string2) {
        byte[] byArray = string.getBytes(StandardCharsets.UTF_8);
        byte[] byArray2 = string2.getBytes(StandardCharsets.UTF_8);
        byte[] byArray3 = new byte[1];
        int n = 4 + byArray.length + 1 + 4 + byArray2.length + 1 + 4 + 4;
        ByteBuffer byteBuffer = ByteBuffer.allocate(n).order(ByteOrder.nativeOrder());
        byteBuffer.putInt(byArray.length + 1).put(byArray).put(byArray3).putInt(byArray2.length + 1).put(byArray2).put(byArray3).putInt(this.cusec).putInt(this.ctime);
        return byteBuffer.array();
    }

    public byte[] encode(boolean bl) {
        return this.encode0(this.client, this.server);
    }
}

