/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.script;

import java.io.File;
import java.io.Serializable;
import java.nio.file.Path;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.script.AbstractScript;
import org.apache.logging.log4j.core.script.ScriptFile;
import org.apache.logging.log4j.core.util.FileWatcher;
import org.apache.logging.log4j.core.util.WatchManager;
import org.apache.logging.log4j.status.StatusLogger;

public class ScriptManager
implements FileWatcher,
Serializable {
    private static final long serialVersionUID = -2534169384971965196L;
    private static final String KEY_THREADING = "THREADING";
    private static final Logger logger = StatusLogger.getLogger();
    private final ScriptEngineManager manager = new ScriptEngineManager();
    private final ConcurrentMap<String, ScriptRunner> scripts = new ConcurrentHashMap<String, ScriptRunner>();
    private final String languages;
    private final WatchManager watchManager;
    private static final SecurityManager SECURITY_MANAGER = System.getSecurityManager();

    public ScriptManager(WatchManager watchManager) {
        this.watchManager = watchManager;
        List<ScriptEngineFactory> factories = this.manager.getEngineFactories();
        if (logger.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder();
            logger.debug("Installed script engines");
            for (ScriptEngineFactory factory : factories) {
                String threading = (String)factory.getParameter(KEY_THREADING);
                if (threading == null) {
                    threading = "Not Thread Safe";
                }
                StringBuilder names = new StringBuilder();
                for (String name : factory.getNames()) {
                    if (names.length() > 0) {
                        names.append(", ");
                    }
                    names.append(name);
                }
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append((CharSequence)names);
                boolean compiled = factory.getScriptEngine() instanceof Compilable;
                logger.debug(factory.getEngineName() + " Version: " + factory.getEngineVersion() + ", Language: " + factory.getLanguageName() + ", Threading: " + threading + ", Compile: " + compiled + ", Names: {" + names.toString() + "}");
            }
            this.languages = sb.toString();
        } else {
            StringBuilder names = new StringBuilder();
            for (ScriptEngineFactory factory : factories) {
                for (String name : factory.getNames()) {
                    if (names.length() > 0) {
                        names.append(", ");
                    }
                    names.append(name);
                }
            }
            this.languages = names.toString();
        }
    }

    public void addScript(AbstractScript script) {
        ScriptEngine engine = this.manager.getEngineByName(script.getLanguage());
        if (engine == null) {
            logger.error("No ScriptEngine found for language " + script.getLanguage() + ". Available languages are: " + this.languages);
            return;
        }
        if (engine.getFactory().getParameter(KEY_THREADING) == null) {
            this.scripts.put(script.getName(), new ThreadLocalScriptRunner(script));
        } else {
            this.scripts.put(script.getName(), new MainScriptRunner(engine, script));
        }
        if (script instanceof ScriptFile) {
            ScriptFile scriptFile = (ScriptFile)script;
            Path path = scriptFile.getPath();
            if (scriptFile.isWatched() && path != null) {
                this.watchManager.watchFile(path.toFile(), this);
            }
        }
    }

    public AbstractScript getScript(String name) {
        ScriptRunner runner = (ScriptRunner)this.scripts.get(name);
        return runner != null ? runner.getScript() : null;
    }

    @Override
    public void fileModified(File file) {
        ScriptRunner runner = (ScriptRunner)this.scripts.get(file.toString());
        if (runner == null) {
            logger.info("{} is not a running script");
            return;
        }
        ScriptEngine engine = runner.getScriptEngine();
        AbstractScript script = runner.getScript();
        if (engine.getFactory().getParameter(KEY_THREADING) == null) {
            this.scripts.put(script.getName(), new ThreadLocalScriptRunner(script));
        } else {
            this.scripts.put(script.getName(), new MainScriptRunner(engine, script));
        }
    }

    public Object execute(String name, final Bindings bindings) {
        final ScriptRunner scriptRunner = (ScriptRunner)this.scripts.get(name);
        if (scriptRunner == null) {
            logger.warn("No script named {} could be found");
            return null;
        }
        return AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return scriptRunner.execute(bindings);
            }
        });
    }

    private class ThreadLocalScriptRunner
    implements ScriptRunner {
        private final AbstractScript script;
        private final ThreadLocal<MainScriptRunner> runners = new ThreadLocal<MainScriptRunner>(){

            @Override
            protected MainScriptRunner initialValue() {
                ScriptEngine engine = ScriptManager.this.manager.getEngineByName(ThreadLocalScriptRunner.this.script.getLanguage());
                return new MainScriptRunner(engine, ThreadLocalScriptRunner.this.script);
            }
        };

        public ThreadLocalScriptRunner(AbstractScript script) {
            this.script = script;
        }

        @Override
        public Object execute(Bindings bindings) {
            return this.runners.get().execute(bindings);
        }

        @Override
        public AbstractScript getScript() {
            return this.script;
        }

        @Override
        public ScriptEngine getScriptEngine() {
            return this.runners.get().getScriptEngine();
        }
    }

    private class MainScriptRunner
    implements ScriptRunner {
        private final AbstractScript script;
        private final CompiledScript compiledScript;
        private final ScriptEngine scriptEngine;

        public MainScriptRunner(final ScriptEngine scriptEngine, final AbstractScript script) {
            this.script = script;
            this.scriptEngine = scriptEngine;
            CompiledScript compiled = null;
            if (scriptEngine instanceof Compilable) {
                logger.debug("Script {} is compilable", (Object)script.getName());
                compiled = AccessController.doPrivileged(new PrivilegedAction<CompiledScript>(){

                    @Override
                    public CompiledScript run() {
                        try {
                            return ((Compilable)((Object)scriptEngine)).compile(script.getScriptText());
                        }
                        catch (Throwable ex) {
                            logger.warn("Error compiling script", ex);
                            return null;
                        }
                    }
                });
            }
            this.compiledScript = compiled;
        }

        @Override
        public ScriptEngine getScriptEngine() {
            return this.scriptEngine;
        }

        @Override
        public Object execute(Bindings bindings) {
            if (this.compiledScript != null) {
                try {
                    return this.compiledScript.eval(bindings);
                }
                catch (ScriptException ex) {
                    logger.error("Error running script " + this.script.getName(), (Throwable)ex);
                    return null;
                }
            }
            try {
                return this.scriptEngine.eval(this.script.getScriptText(), bindings);
            }
            catch (ScriptException ex) {
                logger.error("Error running script " + this.script.getName(), (Throwable)ex);
                return null;
            }
        }

        @Override
        public AbstractScript getScript() {
            return this.script;
        }
    }

    private static interface ScriptRunner {
        public Object execute(Bindings var1);

        public AbstractScript getScript();

        public ScriptEngine getScriptEngine();
    }
}

