/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.admin.indices;

import com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.get.GetIndexRequest;
import org.elasticsearch.action.admin.indices.get.GetIndexResponse;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.cluster.metadata.AliasMetaData;
import org.elasticsearch.cluster.metadata.MappingMetaData;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsFilter;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.RestBuilderListener;

public class RestGetIndicesAction
extends BaseRestHandler {
    private final IndexScopedSettings indexScopedSettings;
    private final SettingsFilter settingsFilter;

    @Inject
    public RestGetIndicesAction(Settings settings, RestController controller, IndexScopedSettings indexScopedSettings, SettingsFilter settingsFilter) {
        super(settings);
        this.indexScopedSettings = indexScopedSettings;
        controller.registerHandler(RestRequest.Method.GET, "/{index}", this);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/{type}", this);
        this.settingsFilter = settingsFilter;
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(final RestRequest request, NodeClient client) throws IOException {
        String[] indices = Strings.splitStringByCommaToArray(request.param("index"));
        String[] featureParams = request.paramAsStringArray("type", null);
        if (featureParams == null && indices.length > 0 && indices[0] != null && indices[0].startsWith("_") && !"_all".equals(indices[0])) {
            featureParams = indices;
            indices = new String[]{"_all"};
        }
        final GetIndexRequest getIndexRequest = new GetIndexRequest();
        getIndexRequest.indices(indices);
        if (featureParams != null) {
            GetIndexRequest.Feature[] features = GetIndexRequest.Feature.convertToFeatures(featureParams);
            getIndexRequest.features(features);
        }
        getIndexRequest.indicesOptions(IndicesOptions.fromRequest(request, getIndexRequest.indicesOptions()));
        getIndexRequest.local(request.paramAsBoolean("local", getIndexRequest.local()));
        getIndexRequest.humanReadable(request.paramAsBoolean("human", false));
        final boolean defaults = request.paramAsBoolean("include_defaults", false);
        return channel -> client.admin().indices().getIndex(getIndexRequest, (ActionListener<GetIndexResponse>)new RestBuilderListener<GetIndexResponse>(channel){

            @Override
            public RestResponse buildResponse(GetIndexResponse response, XContentBuilder builder) throws Exception {
                GetIndexRequest.Feature[] features = getIndexRequest.features();
                String[] indices = response.indices();
                builder.startObject();
                for (String index : indices) {
                    builder.startObject(index);
                    block6: for (GetIndexRequest.Feature feature : features) {
                        switch (feature) {
                            case ALIASES: {
                                this.writeAliases(response.aliases().get(index), builder, request);
                                continue block6;
                            }
                            case MAPPINGS: {
                                this.writeMappings(response.mappings().get(index), builder, request);
                                continue block6;
                            }
                            case SETTINGS: {
                                this.writeSettings(response.settings().get(index), builder, request, defaults);
                                continue block6;
                            }
                            default: {
                                throw new IllegalStateException("feature [" + (Object)((Object)feature) + "] is not valid");
                            }
                        }
                    }
                    builder.endObject();
                }
                builder.endObject();
                return new BytesRestResponse(RestStatus.OK, builder);
            }

            private void writeAliases(List<AliasMetaData> aliases, XContentBuilder builder, ToXContent.Params params) throws IOException {
                builder.startObject("aliases");
                if (aliases != null) {
                    for (AliasMetaData alias : aliases) {
                        AliasMetaData.Builder.toXContent(alias, builder, params);
                    }
                }
                builder.endObject();
            }

            private void writeMappings(ImmutableOpenMap<String, MappingMetaData> mappings, XContentBuilder builder, ToXContent.Params params) throws IOException {
                builder.startObject("mappings");
                if (mappings != null) {
                    for (ObjectObjectCursor<String, MappingMetaData> objectObjectCursor : mappings) {
                        builder.field((String)objectObjectCursor.key);
                        builder.map(((MappingMetaData)objectObjectCursor.value).sourceAsMap());
                    }
                }
                builder.endObject();
            }

            private void writeSettings(Settings settings, XContentBuilder builder, ToXContent.Params params, boolean defaults2) throws IOException {
                builder.startObject("settings");
                settings.toXContent(builder, params);
                builder.endObject();
                if (defaults2) {
                    builder.startObject("defaults");
                    RestGetIndicesAction.this.settingsFilter.filter(RestGetIndicesAction.this.indexScopedSettings.diff(settings, RestGetIndicesAction.this.settings)).toXContent(builder, request);
                    builder.endObject();
                }
            }
        });
    }

    @Override
    protected Set<String> responseParams() {
        return Settings.FORMAT_PARAMS;
    }

    static class Fields {
        static final String ALIASES = "aliases";
        static final String MAPPINGS = "mappings";
        static final String SETTINGS = "settings";

        Fields() {
        }
    }
}

