/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation.tests;

import java.util.Locale;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.AbstractPrimitive;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.tools.I18n;

public class UntaggedNode
extends Test
implements AbstractPrimitive.KeyValueVisitor {
    protected static final int UNTAGGED_NODE_BLANK = 201;
    protected static final int UNTAGGED_NODE_FIXME = 202;
    protected static final int UNTAGGED_NODE_NOTE = 203;
    protected static final int UNTAGGED_NODE_CREATED_BY = 204;
    protected static final int UNTAGGED_NODE_WATCH = 205;
    protected static final int UNTAGGED_NODE_SOURCE = 206;
    protected static final int UNTAGGED_NODE_OTHER = 207;
    protected static final String ERROR_MESSAGE = I18n.tr("Unconnected nodes without physical tags", new Object[0]);

    public UntaggedNode() {
        super(I18n.tr("Untagged and unconnected nodes", new Object[0]), I18n.tr("This test checks for untagged nodes that are not part of any way.", new Object[0]));
    }

    @Override
    public void visit(Node node) {
        if (node.isUsable() && !node.isTagged() && node.getReferrers().isEmpty()) {
            if (!node.hasKeys() && IN_DOWNLOADED_AREA.test(node)) {
                this.errors.add(TestError.builder(this, Severity.WARNING, 201).message(ERROR_MESSAGE, I18n.marktr("No tags"), new Object[0]).primitives(node).build());
                return;
            }
            node.visitKeys(this);
        }
    }

    @Override
    public void visitKeyValue(AbstractPrimitive abstractPrimitive, String string, String string2) {
        if (string.toLowerCase(Locale.ENGLISH).contains("fixme") || string2.toLowerCase(Locale.ENGLISH).contains("fixme")) {
            this.errors.add(TestError.builder(this, Severity.WARNING, 202).message(ERROR_MESSAGE, I18n.marktr("Has tag containing ''fixme'' or ''FIXME''"), new Object[0]).primitives((OsmPrimitive)abstractPrimitive).build());
            return;
        }
        String string3 = null;
        int n = 0;
        if (string.startsWith("note") || string.startsWith("comment") || string.startsWith("description")) {
            string3 = I18n.marktr("Has key ''note'' or ''comment'' or ''description''");
            n = 203;
        } else if (string.startsWith("created_by") || string.startsWith("converted_by")) {
            string3 = I18n.marktr("Has key ''created_by'' or ''converted_by''");
            n = 204;
        } else if (string.startsWith("watch")) {
            string3 = I18n.marktr("Has key ''watch''");
            n = 205;
        } else if (string.startsWith("source")) {
            string3 = I18n.marktr("Has key ''source''");
            n = 206;
        }
        if (string3 != null) {
            this.errors.add(TestError.builder(this, Severity.WARNING, n).message(ERROR_MESSAGE, string3, new Object[0]).primitives((OsmPrimitive)abstractPrimitive).build());
            return;
        }
        this.errors.add(TestError.builder(this, Severity.WARNING, 207).message(ERROR_MESSAGE, I18n.marktr("Other"), new Object[0]).primitives((OsmPrimitive)abstractPrimitive).build());
    }

    @Override
    public Command fixError(TestError testError) {
        return this.deletePrimitivesIfNeeded(testError.getPrimitives());
    }

    @Override
    public boolean isFixable(TestError testError) {
        if (testError.getTester() instanceof UntaggedNode) {
            int n = testError.getCode();
            switch (n) {
                case 201: 
                case 204: 
                case 205: 
                case 206: {
                    return true;
                }
            }
        }
        return false;
    }
}

