/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.cast;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.BranchProfile;
import org.jruby.truffle.Layouts;
import org.jruby.truffle.core.cast.NameToJavaStringNodeGen;
import org.jruby.truffle.core.rope.Rope;
import org.jruby.truffle.core.string.StringCachingGuards;
import org.jruby.truffle.core.string.StringOperations;
import org.jruby.truffle.language.RubyGuards;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.control.RaiseException;
import org.jruby.truffle.language.dispatch.CallDispatchHeadNode;

@ImportStatic(value={StringCachingGuards.class})
@NodeChild(value="value", type=RubyNode.class)
public abstract class NameToJavaStringNode
extends RubyNode {
    public static NameToJavaStringNode create() {
        return NameToJavaStringNodeGen.create(null);
    }

    public abstract String executeToJavaString(VirtualFrame var1, Object var2);

    @Specialization(guards={"isRubyString(value)", "ropesEqual(value, cachedRope)"}, limit="getLimit()")
    String stringCached(DynamicObject value, @Cached(value="privatizeRope(value)") Rope cachedRope, @Cached(value="value.toString()") String convertedString) {
        return convertedString;
    }

    @Specialization(guards={"isRubyString(value)"}, contains={"stringCached"})
    public String stringUncached(DynamicObject value) {
        return StringOperations.getString(value);
    }

    @Specialization(guards={"symbol == cachedSymbol", "isRubySymbol(cachedSymbol)"}, limit="getLimit()")
    public String symbolCached(DynamicObject symbol, @Cached(value="symbol") DynamicObject cachedSymbol, @Cached(value="symbolToString(symbol)") String convertedString) {
        return convertedString;
    }

    @Specialization(guards={"isRubySymbol(symbol)"}, contains={"symbolCached"})
    public String symbolUncached(DynamicObject symbol) {
        return this.symbolToString(symbol);
    }

    @Specialization(guards={"string == cachedString"}, limit="getLimit()")
    public String javaStringCached(String string, @Cached(value="string") String cachedString) {
        return cachedString;
    }

    @Specialization(contains={"javaStringCached"})
    public String javaStringUncached(String value) {
        return value;
    }

    @Specialization(guards={"!isString(object)", "!isRubySymbol(object)", "!isRubyString(object)"})
    public String coerceObjectToStr(VirtualFrame frame, Object object, @Cached(value="create()") BranchProfile errorProfile, @Cached(value="createMethodCall()") CallDispatchHeadNode toStr) {
        Object coerced;
        try {
            coerced = toStr.call(frame, object, "to_str", new Object[0]);
        }
        catch (RaiseException e) {
            errorProfile.enter();
            if (Layouts.BASIC_OBJECT.getLogicalClass(e.getException()) == this.coreLibrary().getNoMethodErrorClass()) {
                throw new RaiseException(this.coreExceptions().typeErrorNoImplicitConversion(object, "String", this));
            }
            throw e;
        }
        if (RubyGuards.isRubyString(coerced)) {
            return StringOperations.getString((DynamicObject)coerced);
        }
        errorProfile.enter();
        throw new RaiseException(this.coreExceptions().typeErrorBadCoercion(object, "String", "to_str", coerced, this));
    }

    protected String symbolToString(DynamicObject symbol) {
        return Layouts.SYMBOL.getString(symbol);
    }

    protected int getLimit() {
        return this.getContext().getOptions().INTEROP_CONVERT_CACHE;
    }
}

