/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language.globals;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.basicobject.BasicObjectNodes;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.globals.GlobalVariableStorage;

@NodeChild(value="value")
public abstract class WriteGlobalVariableNode
extends RubyNode {
    private final String name;

    public WriteGlobalVariableNode(RubyContext context, SourceSection sourceSection, String name) {
        super(context, sourceSection);
        this.name = name;
    }

    @Specialization(assumptions={"storage.getUnchangedAssumption()"})
    public Object writeTryToKeepConstant(Object value, @Cached(value="getStorage()") GlobalVariableStorage storage, @Cached(value="storage.getValue()") Object previousValue, @Cached(value="create()") BasicObjectNodes.ReferenceEqualNode referenceEqualNode) {
        if (referenceEqualNode.executeReferenceEqual(value, previousValue)) {
            return previousValue;
        }
        storage.setValue(value);
        return value;
    }

    @Specialization
    public Object write(Object value, @Cached(value="getStorage()") GlobalVariableStorage storage) {
        storage.setValue(value);
        return value;
    }

    protected GlobalVariableStorage getStorage() {
        return this.getContext().getCoreLibrary().getGlobalVariables().getStorage(this.name);
    }

    @Override
    public Object isDefined(VirtualFrame frame) {
        return this.coreStrings().ASSIGNMENT.createInstance();
    }
}

