/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.ajp;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.ByteBuffer;
import org.apache.coyote.ActionCode;
import org.apache.coyote.ErrorState;
import org.apache.coyote.RequestInfo;
import org.apache.coyote.ajp.AbstractAjpProcessor;
import org.apache.coyote.ajp.AjpMessage;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.jni.Socket;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.net.AbstractEndpoint;
import org.apache.tomcat.util.net.AprEndpoint;
import org.apache.tomcat.util.net.SocketStatus;
import org.apache.tomcat.util.net.SocketWrapper;

public class AjpAprProcessor
extends AbstractAjpProcessor<Long> {
    private static final Log log = LogFactory.getLog(AjpAprProcessor.class);
    protected ByteBuffer inputBuffer = null;
    protected ByteBuffer outputBuffer = null;

    @Override
    protected Log getLog() {
        return log;
    }

    public AjpAprProcessor(int packetSize, AprEndpoint endpoint) {
        super(packetSize, endpoint);
        this.response.setOutputBuffer(new AbstractAjpProcessor.SocketOutputBuffer());
        this.inputBuffer = ByteBuffer.allocateDirect(packetSize * 2);
        this.inputBuffer.limit(0);
        this.outputBuffer = ByteBuffer.allocateDirect(packetSize * 2);
    }

    @Override
    public AbstractEndpoint.Handler.SocketState process(SocketWrapper<Long> socket) throws IOException {
        RequestInfo rp = this.request.getRequestProcessor();
        rp.setStage(1);
        this.socketWrapper = socket;
        long socketRef = socket.getSocket();
        Socket.setrbb(socketRef, this.inputBuffer);
        Socket.setsbb(socketRef, this.outputBuffer);
        boolean cping = false;
        boolean keptAlive = false;
        while (!this.getErrorState().isError() && !this.endpoint.isPaused()) {
            try {
                if (!this.readMessage(this.requestHeaderMessage, true, keptAlive)) break;
                byte type = this.requestHeaderMessage.getByte();
                if (type == 10) {
                    if (this.endpoint.isPaused()) {
                        this.recycle(true);
                        break;
                    }
                    cping = true;
                    if (Socket.send(socketRef, pongMessageArray, 0, pongMessageArray.length) >= 0) continue;
                    this.setErrorState(ErrorState.CLOSE_NOW, null);
                    continue;
                }
                if (type != 2) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Unexpected message: " + type));
                    }
                    this.setErrorState(ErrorState.CLOSE_NOW, null);
                    break;
                }
                keptAlive = true;
                this.request.setStartTime(System.currentTimeMillis());
            }
            catch (IOException e) {
                this.setErrorState(ErrorState.CLOSE_NOW, e);
                break;
            }
            catch (Throwable t) {
                ExceptionUtils.handleThrowable(t);
                log.debug((Object)sm.getString("ajpprocessor.header.error"), t);
                this.response.setStatus(400);
                this.setErrorState(ErrorState.CLOSE_CLEAN, t);
                this.getAdapter().log(this.request, this.response, 0L);
            }
            if (!this.getErrorState().isError()) {
                rp.setStage(2);
                try {
                    this.prepareRequest();
                }
                catch (Throwable t) {
                    ExceptionUtils.handleThrowable(t);
                    log.debug((Object)sm.getString("ajpprocessor.request.prepare"), t);
                    this.response.setStatus(500);
                    this.setErrorState(ErrorState.CLOSE_CLEAN, t);
                    this.getAdapter().log(this.request, this.response, 0L);
                }
            }
            if (!this.getErrorState().isError() && !cping && this.endpoint.isPaused()) {
                this.response.setStatus(503);
                this.setErrorState(ErrorState.CLOSE_CLEAN, null);
                this.getAdapter().log(this.request, this.response, 0L);
            }
            cping = false;
            if (!this.getErrorState().isError()) {
                try {
                    rp.setStage(3);
                    this.adapter.service(this.request, this.response);
                }
                catch (InterruptedIOException e) {
                    this.setErrorState(ErrorState.CLOSE_NOW, e);
                }
                catch (Throwable t) {
                    ExceptionUtils.handleThrowable(t);
                    log.error((Object)sm.getString("ajpprocessor.request.process"), t);
                    this.response.setStatus(500);
                    this.setErrorState(ErrorState.CLOSE_CLEAN, t);
                    this.getAdapter().log(this.request, this.response, 0L);
                }
            }
            if (this.isAsync() && !this.getErrorState().isError()) break;
            if (!this.finished && this.getErrorState().isIoAllowed()) {
                try {
                    this.finish();
                }
                catch (Throwable t) {
                    ExceptionUtils.handleThrowable(t);
                    this.setErrorState(ErrorState.CLOSE_NOW, t);
                }
            }
            if (this.getErrorState().isError()) {
                this.response.setStatus(500);
            }
            this.request.updateCounters();
            rp.setStage(6);
            this.recycle(false);
        }
        rp.setStage(7);
        if (!this.getErrorState().isError() && !this.endpoint.isPaused()) {
            if (this.isAsync()) {
                return AbstractEndpoint.Handler.SocketState.LONG;
            }
            return AbstractEndpoint.Handler.SocketState.OPEN;
        }
        return AbstractEndpoint.Handler.SocketState.CLOSED;
    }

    @Override
    protected void actionInternal(ActionCode actionCode, Object param) {
        switch (actionCode) {
            case ASYNC_COMPLETE: {
                if (!this.asyncStateMachine.asyncComplete()) break;
                ((AprEndpoint)this.endpoint).processSocketAsync(this.socketWrapper, SocketStatus.OPEN_READ);
                break;
            }
            case ASYNC_SETTIMEOUT: {
                if (param == null) {
                    return;
                }
                long timeout = (Long)param;
                this.socketWrapper.setTimeout(timeout);
                break;
            }
            case ASYNC_DISPATCH: {
                if (!this.asyncStateMachine.asyncDispatch()) break;
                ((AprEndpoint)this.endpoint).processSocketAsync(this.socketWrapper, SocketStatus.OPEN_READ);
            }
        }
    }

    @Override
    protected void resetTimeouts() {
    }

    @Override
    protected void output(byte[] src, int offset, int length) throws IOException {
        this.outputBuffer.put(src, offset, length);
        long socketRef = (Long)this.socketWrapper.getSocket();
        if (this.outputBuffer.position() > 0) {
            if (socketRef != 0L && Socket.sendbb(socketRef, 0, this.outputBuffer.position()) < 0) {
                this.outputBuffer.clear();
                throw new IOException(sm.getString("ajpprocessor.failedsend"));
            }
            this.outputBuffer.clear();
        }
    }

    protected boolean read(int n) throws IOException {
        if (this.inputBuffer.capacity() - this.inputBuffer.limit() <= n - this.inputBuffer.remaining()) {
            this.inputBuffer.compact();
            this.inputBuffer.limit(this.inputBuffer.position());
            this.inputBuffer.position(0);
        }
        while (this.inputBuffer.remaining() < n) {
            int nRead = Socket.recvbb((Long)this.socketWrapper.getSocket(), this.inputBuffer.limit(), this.inputBuffer.capacity() - this.inputBuffer.limit());
            if (nRead > 0) {
                this.inputBuffer.limit(this.inputBuffer.limit() + nRead);
                continue;
            }
            throw new IOException(sm.getString("ajpprocessor.failedread"));
        }
        return true;
    }

    protected boolean readt(int n, boolean useAvailableData) throws IOException {
        if (useAvailableData && this.inputBuffer.remaining() == 0) {
            return false;
        }
        if (this.inputBuffer.capacity() - this.inputBuffer.limit() <= n - this.inputBuffer.remaining()) {
            this.inputBuffer.compact();
            this.inputBuffer.limit(this.inputBuffer.position());
            this.inputBuffer.position(0);
        }
        while (this.inputBuffer.remaining() < n) {
            int nRead = Socket.recvbb((Long)this.socketWrapper.getSocket(), this.inputBuffer.limit(), this.inputBuffer.capacity() - this.inputBuffer.limit());
            if (nRead > 0) {
                this.inputBuffer.limit(this.inputBuffer.limit() + nRead);
                continue;
            }
            if (-nRead == 120005 || -nRead == 120001) {
                return false;
            }
            throw new IOException(sm.getString("ajpprocessor.failedread"));
        }
        return true;
    }

    @Override
    public boolean receive() throws IOException {
        this.first = false;
        this.bodyMessage.reset();
        if (!this.readMessage(this.bodyMessage, false, false)) {
            return false;
        }
        if (this.bodyMessage.getLen() == 0) {
            return false;
        }
        int blen = this.bodyMessage.peekInt();
        if (blen == 0) {
            return false;
        }
        this.bodyMessage.getBodyBytes(this.bodyBytes);
        this.empty = false;
        return true;
    }

    protected boolean readMessage(AjpMessage message, boolean first, boolean useAvailableData) throws IOException {
        int headerLength = message.getHeaderLength();
        if (first) {
            if (!this.readt(headerLength, useAvailableData)) {
                return false;
            }
        } else {
            this.read(headerLength);
        }
        this.inputBuffer.get(message.getBuffer(), 0, headerLength);
        int messageLength = message.processHeader(true);
        if (messageLength < 0) {
            return false;
        }
        if (messageLength == 0) {
            return true;
        }
        if (messageLength > message.getBuffer().length) {
            throw new IllegalArgumentException(sm.getString("ajpprocessor.header.tooLong", messageLength, message.getBuffer().length));
        }
        this.read(messageLength);
        this.inputBuffer.get(message.getBuffer(), headerLength, messageLength);
        return true;
    }

    @Override
    public void recycle(boolean socketClosing) {
        super.recycle(socketClosing);
        this.inputBuffer.clear();
        this.inputBuffer.limit(0);
        this.outputBuffer.clear();
    }
}

