/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.db.sql;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import org.apache.log4j.Logger;
import org.hsqldb.Server;
import org.parosproxy.paros.db.DatabaseServer;
import org.zaproxy.zap.db.sql.DbSQL;

public class SqlDatabaseServer
implements DatabaseServer {
    public static final int DEFAULT_SERVER_PORT = 9001;
    private static final Logger logger = Logger.getLogger(SqlDatabaseServer.class);
    private String dbUrl = null;
    private String dbUser = null;
    private String dbPassword = null;
    private Server dbServer = null;
    private Connection dbConn = null;

    SqlDatabaseServer(String string) throws ClassNotFoundException, Exception {
        this.start(string);
    }

    private void start(String string) throws ClassNotFoundException, Exception {
        this.setDbUrl(DbSQL.getSingleton().getDbUrl());
        this.setDbUser(DbSQL.getSingleton().getDbUser());
        this.setDbPassword(DbSQL.getSingleton().getDbPassword());
    }

    void shutdown(boolean bl) throws SQLException {
        if (this.dbConn != null) {
            this.dbConn.close();
            this.dbConn = null;
        }
    }

    public Connection getNewConnection() throws SQLException {
        Connection connection = null;
        for (int i = 0; i < 5; ++i) {
            try {
                connection = DriverManager.getConnection(this.dbUrl, this.dbUser, this.dbPassword);
                return connection;
            }
            catch (SQLException sQLException) {
                logger.warn((Object)sQLException.getMessage(), (Throwable)sQLException);
                if (i == 4) {
                    throw sQLException;
                }
                logger.warn((Object)("Recovering " + i + " times."));
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug((Object)interruptedException.getMessage(), (Throwable)interruptedException);
                }
                continue;
            }
        }
        return connection;
    }

    public Connection getSingletonConnection() throws SQLException {
        if (this.dbConn == null) {
            this.dbConn = this.getNewConnection();
        }
        return this.dbConn;
    }

    public String getDbUrl() {
        return this.dbUrl;
    }

    public String getDbUser() {
        return this.dbUser;
    }

    public String getDbPassword() {
        return this.dbPassword;
    }

    public Server getDbServer() {
        return this.dbServer;
    }

    public void setDbUrl(String string) {
        this.dbUrl = string;
    }

    public void setDbUser(String string) {
        this.dbUser = string;
    }

    public void setDbPassword(String string) {
        this.dbPassword = string;
    }

    public void setDbServer(Server server) {
        this.dbServer = server;
    }
}

