/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.utils;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.Arrays;
import org.apache.log4j.Logger;

public class ByteBuilder {
    private static final Logger logger = Logger.getLogger(ByteBuilder.class);
    private byte[] array;
    private int size;

    public ByteBuilder() {
        this(10);
    }

    public ByteBuilder(int n) {
        this.array = new byte[n];
        this.size = 0;
    }

    public ByteBuilder(byte[] byArray) {
        this.array = Arrays.copyOf(byArray, byArray.length * 2);
        this.size = byArray.length;
    }

    public void ensureCapacity(int n) {
        if (n > this.array.length) {
            this.array = Arrays.copyOf(this.array, n);
        }
    }

    private void testAddition(int n) {
        while (this.size + n >= this.array.length) {
            this.array = Arrays.copyOf(this.array, this.array.length * 2);
        }
    }

    private void copyIntoArray(byte[] byArray) {
        for (int i = 0; i < byArray.length; ++i) {
            this.array[this.size + i] = byArray[i];
        }
        this.size += byArray.length;
    }

    public int capacity() {
        return this.array.length;
    }

    public int size() {
        return this.size;
    }

    public void truncate(int n) {
        this.array = Arrays.copyOf(this.array, n);
    }

    public byte[] subSequence(int n, int n2) {
        return Arrays.copyOfRange(this.array, n, n2);
    }

    public byte[] toByteArray() {
        return Arrays.copyOf(this.array, this.size);
    }

    public String toString() {
        return new String(this.array);
    }

    public ByteBuilder append(byte by) {
        this.testAddition(1);
        this.array[this.size++] = by;
        return this;
    }

    public ByteBuilder append(byte[] byArray) {
        return this.append(byArray, 0, byArray.length);
    }

    public ByteBuilder append(byte[] byArray, int n, int n2) {
        if (n + n2 > byArray.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.testAddition(n2);
        for (int i = 0; i < n2; ++i) {
            this.array[this.size + i] = byArray[i + n];
        }
        this.size += n2;
        return this;
    }

    public ByteBuilder append(char c) {
        this.testAddition(1);
        this.array[this.size++] = (byte)c;
        return this;
    }

    public ByteBuilder append(char[] cArray) {
        return this.append(cArray, 0, cArray.length);
    }

    public ByteBuilder append(char[] cArray, int n, int n2) {
        if (n + n2 > cArray.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.testAddition(n2);
        for (int i = 0; i < n2; ++i) {
            this.array[this.size + i] = (byte)cArray[i + n];
        }
        this.size += n2;
        return this;
    }

    public ByteBuilder append(boolean bl) {
        this.testAddition(1);
        this.array[this.size++] = (byte)(bl ? 1 : 0);
        return this;
    }

    public ByteBuilder append(short s) {
        this.testAddition(2);
        byte[] byArray = new byte[2];
        for (int i = 0; i < 2; ++i) {
            int n = (byArray.length - 1 - i) * 8;
            byArray[i] = (byte)(s >>> n & 0xFF);
        }
        this.copyIntoArray(byArray);
        return this;
    }

    public ByteBuilder append(int n) {
        this.testAddition(4);
        byte[] byArray = new byte[4];
        for (int i = 0; i < 4; ++i) {
            int n2 = (byArray.length - 1 - i) * 8;
            byArray[i] = (byte)(n >>> n2 & 0xFF);
        }
        this.copyIntoArray(byArray);
        return this;
    }

    public ByteBuilder append(long l) {
        this.testAddition(8);
        byte[] byArray = new byte[8];
        for (int i = 0; i < 8; ++i) {
            int n = (byArray.length - 1 - i) * 8;
            byArray[i] = (byte)(l >>> n & 0xFFL);
        }
        this.copyIntoArray(byArray);
        return this;
    }

    public ByteBuilder append(float f) {
        this.testAddition(4);
        int n = Float.floatToRawIntBits(f);
        byte[] byArray = new byte[4];
        for (int i = 0; i < 4; ++i) {
            int n2 = (byArray.length - 1 - i) * 8;
            byArray[i] = (byte)(n >>> n2 & 0xFF);
        }
        this.copyIntoArray(byArray);
        return this;
    }

    public ByteBuilder append(double d) {
        this.testAddition(8);
        long l = Double.doubleToRawLongBits(d);
        byte[] byArray = new byte[8];
        for (int i = 0; i < 8; ++i) {
            int n = (byArray.length - 1 - i) * 8;
            byArray[i] = (byte)(l >>> n & 0xFFL);
        }
        this.copyIntoArray(byArray);
        return this;
    }

    public ByteBuilder append(Object object) {
        try {
            Method method = object.getClass().getMethod("toByteStructure", null);
            byte[] byArray = (byte[])method.invoke(object, new Object[0]);
            return this.append(byArray);
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException exception) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)exception.getMessage(), (Throwable)exception);
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return this.append(object.toString());
    }

    public ByteBuilder append(String string) {
        byte[] byArray = string.getBytes(Charset.defaultCharset());
        this.testAddition(byArray.length + 4);
        return this.append(byArray.length).append(byArray);
    }

    public ByteBuilder append(StringBuffer stringBuffer) {
        byte[] byArray = stringBuffer.toString().getBytes(Charset.defaultCharset());
        this.testAddition(byArray.length + 4);
        return this.append(byArray.length).append(byArray);
    }

    public ByteBuilder append(ByteBuilder byteBuilder) {
        this.testAddition(byteBuilder.size);
        return this.append(byteBuilder.array, 0, byteBuilder.size);
    }

    public ByteBuilder appendSpecial(long l, int n, boolean bl) {
        this.testAddition(n);
        byte[] byArray = new byte[n];
        for (int i = 0; i < n; ++i) {
            int n2 = (byArray.length - 1 - i) * 8;
            byArray[i] = (byte)(l >>> n2 & 0xFFL);
            if (!bl || i != 0) continue;
            if (l < 0L) {
                int n3 = i;
                byArray[n3] = (byte)(byArray[n3] | 0x80);
                continue;
            }
            int n4 = i;
            byArray[n4] = (byte)(byArray[n4] & 0x7F);
        }
        this.copyIntoArray(byArray);
        return this;
    }
}

