/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless;

import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.MutableCallSite;
import java.lang.invoke.WrongMethodTypeException;
import org.elasticsearch.common.SuppressForbidden;
import org.elasticsearch.painless.Def;
import org.elasticsearch.painless.DefMath;

public final class DefBootstrap {
    public static final int METHOD_CALL = 0;
    public static final int LOAD = 1;
    public static final int STORE = 2;
    public static final int ARRAY_LOAD = 3;
    public static final int ARRAY_STORE = 4;
    public static final int ITERATOR = 5;
    public static final int REFERENCE = 6;
    public static final int UNARY_OPERATOR = 7;
    public static final int BINARY_OPERATOR = 8;
    public static final int SHIFT_OPERATOR = 9;
    public static final int OPERATOR_ALLOWS_NULL = 1;
    public static final int OPERATOR_COMPOUND_ASSIGNMENT = 2;
    public static final int OPERATOR_EXPLICIT_CAST = 4;

    private DefBootstrap() {
    }

    public static CallSite bootstrap(MethodHandles.Lookup lookup, String name, MethodType type, int initialDepth, int flavor, Object ... args) {
        switch (flavor) {
            case 0: {
                if (args.length == 0) {
                    throw new BootstrapMethodError("Invalid number of parameters for method call");
                }
                if (!(args[0] instanceof String)) {
                    throw new BootstrapMethodError("Illegal parameter for method call: " + args[0]);
                }
                String recipe = (String)args[0];
                int numLambdas = recipe.length();
                if (numLambdas > type.parameterCount()) {
                    throw new BootstrapMethodError("Illegal recipe for method call: too many bits");
                }
                if (args.length != numLambdas + 1) {
                    throw new BootstrapMethodError("Illegal number of parameters: expected " + numLambdas + " references");
                }
                return new PIC(lookup, name, type, initialDepth, flavor, args);
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                if (args.length > 0) {
                    throw new BootstrapMethodError("Illegal static bootstrap parameters for flavor: " + flavor);
                }
                return new PIC(lookup, name, type, initialDepth, flavor, args);
            }
            case 6: {
                if (args.length != 1) {
                    throw new BootstrapMethodError("Invalid number of parameters for reference call");
                }
                if (!(args[0] instanceof String)) {
                    throw new BootstrapMethodError("Illegal parameter for reference call: " + args[0]);
                }
                return new PIC(lookup, name, type, initialDepth, flavor, args);
            }
            case 7: 
            case 8: 
            case 9: {
                if (args.length != 1) {
                    throw new BootstrapMethodError("Invalid number of parameters for operator call");
                }
                if (!(args[0] instanceof Integer)) {
                    throw new BootstrapMethodError("Illegal parameter for reference call: " + args[0]);
                }
                int flags = (Integer)args[0];
                if ((flags & 1) != 0 && flavor != 8) {
                    throw new BootstrapMethodError("This parameter is only supported for BINARY_OPERATORs");
                }
                if ((flags & 2) != 0 && flavor != 8 && flavor != 9) {
                    throw new BootstrapMethodError("This parameter is only supported for BINARY/SHIFT_OPERATORs");
                }
                return new MIC(name, type, initialDepth, flavor, flags);
            }
        }
        throw new BootstrapMethodError("Illegal static bootstrap parameter for flavor: " + flavor);
    }

    static final class MIC
    extends MutableCallSite {
        private boolean initialized;
        private final String name;
        private final int flavor;
        private final int flags;
        private static final MethodHandle CHECK_LHS;
        private static final MethodHandle CHECK_RHS;
        private static final MethodHandle CHECK_BOTH;
        private static final MethodHandle FALLBACK;

        MIC(String name, MethodType type, int initialDepth, int flavor, int flags) {
            super(type);
            this.name = name;
            this.flavor = flavor;
            this.flags = flags;
            if (initialDepth > 0) {
                this.initialized = true;
            }
            MethodHandle fallback = FALLBACK.bindTo(this).asCollector(Object[].class, type.parameterCount()).asType(type);
            this.setTarget(fallback);
        }

        private MethodHandle lookup(Object[] args) throws Throwable {
            switch (this.flavor) {
                case 7: 
                case 9: {
                    MethodHandle unary = DefMath.lookupUnary(args[0].getClass(), this.name);
                    if ((this.flags & 4) != 0) {
                        unary = DefMath.cast(this.type().returnType(), unary);
                    } else if ((this.flags & 2) != 0) {
                        unary = DefMath.cast(args[0].getClass(), unary);
                    }
                    return unary;
                }
                case 8: {
                    if (args[0] == null || args[1] == null) {
                        return this.lookupGeneric();
                    }
                    MethodHandle binary = DefMath.lookupBinary(args[0].getClass(), args[1].getClass(), this.name);
                    if ((this.flags & 4) != 0) {
                        binary = DefMath.cast(this.type().returnType(), binary);
                    } else if ((this.flags & 2) != 0) {
                        binary = DefMath.cast(args[0].getClass(), binary);
                    }
                    return binary;
                }
            }
            throw new AssertionError();
        }

        private MethodHandle lookupGeneric() {
            MethodHandle target = DefMath.lookupGeneric(this.name);
            if ((this.flags & 4) != 0) {
                target = DefMath.dynamicCast(target, this.type().returnType());
            } else if ((this.flags & 2) != 0) {
                target = DefMath.dynamicCast(target);
            }
            return target;
        }

        @SuppressForbidden(reason="slow path")
        Object fallback(Object[] args) throws Throwable {
            MethodHandle test;
            if (this.initialized) {
                MethodHandle generic = this.lookupGeneric();
                this.setTarget(generic.asType(this.type()));
                return generic.invokeWithArguments(args);
            }
            MethodType type = this.type();
            MethodHandle target = this.lookup(args);
            try {
                target = target.asType(type);
            }
            catch (WrongMethodTypeException e) {
                ClassCastException exc = new ClassCastException("Cannot cast from: " + target.type().returnType() + " to " + type.returnType());
                exc.initCause(e);
                throw exc;
            }
            if (this.flavor == 8 || this.flavor == 9) {
                Class<?> clazz1;
                Class<?> clazz0 = args[0] == null ? null : args[0].getClass();
                Class<?> clazz = clazz1 = args[1] == null ? null : args[1].getClass();
                if (type.parameterType(1) != Object.class) {
                    MethodHandle unaryTest = CHECK_LHS.bindTo(clazz0);
                    test = unaryTest.asType(unaryTest.type().changeParameterType(0, (Class<?>)type.parameterType(0)));
                } else if (type.parameterType(0) != Object.class) {
                    MethodHandle unaryTest = CHECK_RHS.bindTo(clazz0).bindTo(clazz1);
                    test = unaryTest.asType(unaryTest.type().changeParameterType(0, (Class<?>)type.parameterType(0)).changeParameterType(1, (Class<?>)type.parameterType(1)));
                } else {
                    MethodHandle binaryTest = CHECK_BOTH.bindTo(clazz0).bindTo(clazz1);
                    test = binaryTest.asType(binaryTest.type().changeParameterType(0, (Class<?>)type.parameterType(0)).changeParameterType(1, (Class<?>)type.parameterType(1)));
                }
            } else {
                MethodHandle receiverTest = CHECK_LHS.bindTo(args[0].getClass());
                test = receiverTest.asType(receiverTest.type().changeParameterType(0, (Class<?>)type.parameterType(0)));
            }
            MethodHandle guard = MethodHandles.guardWithTest(test, target, this.getTarget());
            if (this.flavor == 8 && (this.flags & 1) != 0) {
                MethodHandle handler = MethodHandles.dropArguments(this.lookupGeneric().asType(this.type()), 0, new Class[]{NullPointerException.class});
                guard = MethodHandles.catchException(guard, NullPointerException.class, handler);
            }
            this.initialized = true;
            this.setTarget(guard);
            return target.invokeWithArguments(args);
        }

        static boolean checkLHS(Class<?> clazz, Object leftObject) {
            return leftObject.getClass() == clazz;
        }

        static boolean checkRHS(Class<?> left, Class<?> right, Object leftObject, Object rightObject) {
            return rightObject.getClass() == right;
        }

        static boolean checkBoth(Class<?> left, Class<?> right, Object leftObject, Object rightObject) {
            return leftObject.getClass() == left && rightObject.getClass() == right;
        }

        static {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            try {
                CHECK_LHS = lookup.findStatic(lookup.lookupClass(), "checkLHS", MethodType.methodType(Boolean.TYPE, Class.class, Object.class));
                CHECK_RHS = lookup.findStatic(lookup.lookupClass(), "checkRHS", MethodType.methodType(Boolean.TYPE, Class.class, Class.class, Object.class, Object.class));
                CHECK_BOTH = lookup.findStatic(lookup.lookupClass(), "checkBoth", MethodType.methodType(Boolean.TYPE, Class.class, Class.class, Object.class, Object.class));
                FALLBACK = lookup.findVirtual(lookup.lookupClass(), "fallback", MethodType.methodType(Object.class, Object[].class));
            }
            catch (ReflectiveOperationException e) {
                throw new AssertionError((Object)e);
            }
        }
    }

    static final class PIC
    extends MutableCallSite {
        static final int MAX_DEPTH = 5;
        private final MethodHandles.Lookup lookup;
        private final String name;
        private final int flavor;
        private final Object[] args;
        int depth;
        private static final MethodHandle CHECK_CLASS;
        private static final MethodHandle FALLBACK;
        private static final MethodHandle MEGAMORPHIC_LOOKUP;

        PIC(MethodHandles.Lookup lookup, String name, MethodType type, int initialDepth, int flavor, Object[] args) {
            super(type);
            if (type.parameterType(0) != Object.class) {
                throw new BootstrapMethodError("The receiver type (1st arg) of invokedynamic descriptor must be Object.");
            }
            this.lookup = lookup;
            this.name = name;
            this.flavor = flavor;
            this.args = args;
            this.depth = initialDepth;
            MethodHandle fallback = FALLBACK.bindTo(this).asCollector(Object[].class, type.parameterCount()).asType(type);
            this.setTarget(fallback);
        }

        static boolean checkClass(Class<?> clazz, Object receiver) {
            return receiver.getClass() == clazz;
        }

        private MethodHandle lookup(int flavor, String name, Class<?> receiver) throws Throwable {
            switch (flavor) {
                case 0: {
                    return Def.lookupMethod(this.lookup, this.type(), receiver, name, this.args);
                }
                case 1: {
                    return Def.lookupGetter(receiver, name);
                }
                case 2: {
                    return Def.lookupSetter(receiver, name);
                }
                case 3: {
                    return Def.lookupArrayLoad(receiver);
                }
                case 4: {
                    return Def.lookupArrayStore(receiver);
                }
                case 5: {
                    return Def.lookupIterator(receiver);
                }
                case 6: {
                    return Def.lookupReference(this.lookup, (String)this.args[0], receiver, name);
                }
            }
            throw new AssertionError();
        }

        private MethodHandle createMegamorphicHandle() {
            final MethodType type = this.type();
            ClassValue<MethodHandle> megamorphicCache = new ClassValue<MethodHandle>(){

                @Override
                protected MethodHandle computeValue(Class<?> receiverType) {
                    try {
                        return this.lookup(flavor, name, receiverType).asType(type);
                    }
                    catch (Throwable t) {
                        Def.rethrow(t);
                        throw new AssertionError();
                    }
                }
            };
            return MethodHandles.foldArguments(MethodHandles.exactInvoker(type), MEGAMORPHIC_LOOKUP.bindTo(megamorphicCache));
        }

        @SuppressForbidden(reason="slow path")
        Object fallback(Object[] callArgs) throws Throwable {
            if (this.depth >= 5) {
                MethodHandle target = this.createMegamorphicHandle();
                this.setTarget(target);
                return target.invokeWithArguments(callArgs);
            }
            Class<?> receiver = callArgs[0].getClass();
            MethodHandle target = this.lookup(this.flavor, this.name, receiver).asType(this.type());
            MethodHandle test = CHECK_CLASS.bindTo(receiver);
            MethodHandle guard = MethodHandles.guardWithTest(test, target, this.getTarget());
            ++this.depth;
            this.setTarget(guard);
            return target.invokeWithArguments(callArgs);
        }

        static {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            MethodHandles.Lookup publicLookup = MethodHandles.publicLookup();
            try {
                CHECK_CLASS = lookup.findStatic(lookup.lookupClass(), "checkClass", MethodType.methodType(Boolean.TYPE, Class.class, Object.class));
                FALLBACK = lookup.findVirtual(lookup.lookupClass(), "fallback", MethodType.methodType(Object.class, Object[].class));
                MethodHandle mh = publicLookup.findVirtual(ClassValue.class, "get", MethodType.methodType(Object.class, Class.class));
                mh = MethodHandles.filterArguments(mh, 1, publicLookup.findVirtual(Object.class, "getClass", MethodType.methodType(Class.class)));
                MEGAMORPHIC_LOOKUP = mh.asType(mh.type().changeReturnType(MethodHandle.class));
            }
            catch (ReflectiveOperationException e) {
                throw new AssertionError((Object)e);
            }
        }
    }
}

