/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless.node;

import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.painless.Definition;
import org.elasticsearch.painless.Globals;
import org.elasticsearch.painless.Locals;
import org.elasticsearch.painless.Location;
import org.elasticsearch.painless.MethodWriter;
import org.elasticsearch.painless.WriterConstants;
import org.elasticsearch.painless.node.AExpression;

public final class ECallLocal
extends AExpression {
    private final String name;
    private final List<AExpression> arguments;
    private Definition.Method method = null;

    public ECallLocal(Location location, String name, List<AExpression> arguments) {
        super(location);
        this.name = Objects.requireNonNull(name);
        this.arguments = Objects.requireNonNull(arguments);
    }

    @Override
    void extractVariables(Set<String> variables) {
        for (AExpression argument : this.arguments) {
            argument.extractVariables(variables);
        }
    }

    @Override
    void analyze(Locals locals) {
        Definition.MethodKey methodKey = new Definition.MethodKey(this.name, this.arguments.size());
        this.method = locals.getMethod(methodKey);
        if (this.method == null) {
            throw this.createError(new IllegalArgumentException("Unknown call [" + this.name + "] with [" + this.arguments.size() + "] arguments."));
        }
        for (int argument = 0; argument < this.arguments.size(); ++argument) {
            AExpression expression = this.arguments.get(argument);
            expression.expected = this.method.arguments.get(argument);
            expression.internal = true;
            expression.analyze(locals);
            this.arguments.set(argument, expression.cast(locals));
        }
        this.statement = true;
        this.actual = this.method.rtn;
    }

    @Override
    void write(MethodWriter writer, Globals globals) {
        writer.writeDebugInfo(this.location);
        for (AExpression argument : this.arguments) {
            argument.write(writer, globals);
        }
        writer.invokeStatic(WriterConstants.CLASS_TYPE, this.method.method);
    }
}

