/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.delete;

import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.RoutingMissingException;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.action.admin.indices.create.TransportCreateIndexAction;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.AutoCreateIndex;
import org.elasticsearch.action.support.replication.TransportWriteAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.action.shard.ShardStateAction;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.translog.Translog;
import org.elasticsearch.indices.IndexAlreadyExistsException;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportDeleteAction
extends TransportWriteAction<DeleteRequest, DeleteResponse> {
    private final AutoCreateIndex autoCreateIndex;
    private final TransportCreateIndexAction createIndexAction;

    @Inject
    public TransportDeleteAction(Settings settings, TransportService transportService, ClusterService clusterService, IndicesService indicesService, ThreadPool threadPool, ShardStateAction shardStateAction, TransportCreateIndexAction createIndexAction, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, AutoCreateIndex autoCreateIndex) {
        super(settings, "indices:data/write/delete", transportService, clusterService, indicesService, threadPool, shardStateAction, actionFilters, indexNameExpressionResolver, DeleteRequest::new, "index");
        this.createIndexAction = createIndexAction;
        this.autoCreateIndex = autoCreateIndex;
    }

    @Override
    protected void doExecute(final Task task, final DeleteRequest request, final ActionListener<DeleteResponse> listener) {
        ClusterState state = this.clusterService.state();
        if (this.autoCreateIndex.shouldAutoCreate(request.index(), state)) {
            this.createIndexAction.execute(task, new CreateIndexRequest().index(request.index()).cause("auto(delete api)").masterNodeTimeout(request.timeout()), new ActionListener<CreateIndexResponse>(){

                @Override
                public void onResponse(CreateIndexResponse result) {
                    TransportDeleteAction.this.innerExecute(task, request, listener);
                }

                @Override
                public void onFailure(Exception e) {
                    if (ExceptionsHelper.unwrapCause(e) instanceof IndexAlreadyExistsException) {
                        TransportDeleteAction.this.innerExecute(task, request, listener);
                    } else {
                        listener.onFailure(e);
                    }
                }
            });
        } else {
            this.innerExecute(task, request, listener);
        }
    }

    @Override
    protected void resolveRequest(MetaData metaData, IndexMetaData indexMetaData, DeleteRequest request) {
        super.resolveRequest(metaData, indexMetaData, request);
        TransportDeleteAction.resolveAndValidateRouting(metaData, indexMetaData.getIndex().getName(), request);
        ShardId shardId = this.clusterService.operationRouting().shardId(this.clusterService.state(), indexMetaData.getIndex().getName(), request.id(), request.routing());
        request.setShardId(shardId);
    }

    public static void resolveAndValidateRouting(MetaData metaData, String concreteIndex, DeleteRequest request) {
        request.routing(metaData.resolveIndexRouting(request.parent(), request.routing(), request.index()));
        if (request.routing() == null && metaData.routingRequired(concreteIndex, request.type())) {
            throw new RoutingMissingException(concreteIndex, request.type(), request.id());
        }
    }

    private void innerExecute(Task task, DeleteRequest request, ActionListener<DeleteResponse> listener) {
        super.doExecute(task, request, listener);
    }

    @Override
    protected DeleteResponse newResponseInstance() {
        return new DeleteResponse();
    }

    @Override
    protected TransportWriteAction.WriteResult<DeleteResponse> onPrimaryShard(DeleteRequest request, IndexShard indexShard) {
        return TransportDeleteAction.executeDeleteRequestOnPrimary(request, indexShard);
    }

    @Override
    protected Translog.Location onReplicaShard(DeleteRequest request, IndexShard indexShard) {
        return TransportDeleteAction.executeDeleteRequestOnReplica(request, indexShard).getTranslogLocation();
    }

    public static TransportWriteAction.WriteResult<DeleteResponse> executeDeleteRequestOnPrimary(DeleteRequest request, IndexShard indexShard) {
        Engine.Delete delete = indexShard.prepareDeleteOnPrimary(request.type(), request.id(), request.version(), request.versionType());
        indexShard.delete(delete);
        request.versionType(delete.versionType().versionTypeForReplicationAndRecovery());
        request.version(delete.version());
        assert (request.versionType().validateVersionForWrites(request.version()));
        DeleteResponse response = new DeleteResponse(indexShard.shardId(), request.type(), request.id(), delete.version(), delete.found());
        return new TransportWriteAction.WriteResult<DeleteResponse>(response, delete.getTranslogLocation());
    }

    public static Engine.Delete executeDeleteRequestOnReplica(DeleteRequest request, IndexShard indexShard) {
        Engine.Delete delete = indexShard.prepareDeleteOnReplica(request.type(), request.id(), request.version(), request.versionType());
        indexShard.delete(delete);
        return delete;
    }
}

