/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.discovery.zen.ping;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.discovery.zen.ping.PingContextProvider;
import org.elasticsearch.discovery.zen.ping.ZenPing;

public class ZenPingService
extends AbstractLifecycleComponent {
    private List<ZenPing> zenPings = Collections.emptyList();

    @Inject
    public ZenPingService(Settings settings, Set<ZenPing> zenPings) {
        super(settings);
        this.zenPings = Collections.unmodifiableList(new ArrayList<ZenPing>(zenPings));
    }

    public List<ZenPing> zenPings() {
        return this.zenPings;
    }

    public void setPingContextProvider(PingContextProvider contextProvider) {
        if (this.lifecycle.started()) {
            throw new IllegalStateException("Can't set nodes provider when started");
        }
        for (ZenPing zenPing : this.zenPings) {
            zenPing.setPingContextProvider(contextProvider);
        }
    }

    @Override
    protected void doStart() {
        for (ZenPing zenPing : this.zenPings) {
            zenPing.start();
        }
    }

    @Override
    protected void doStop() {
        for (ZenPing zenPing : this.zenPings) {
            zenPing.stop();
        }
    }

    @Override
    protected void doClose() {
        for (ZenPing zenPing : this.zenPings) {
            zenPing.close();
        }
    }

    public ZenPing.PingCollection pingAndWait(TimeValue timeout) {
        ZenPing.PingCollection response = new ZenPing.PingCollection();
        CountDownLatch latch = new CountDownLatch(this.zenPings.size());
        for (ZenPing zenPing : this.zenPings) {
            AtomicBoolean counted = new AtomicBoolean();
            try {
                zenPing.ping(pings -> {
                    response.addPings(pings);
                    if (counted.compareAndSet(false, true)) {
                        latch.countDown();
                    }
                }, timeout);
            }
            catch (Exception ex) {
                this.logger.warn("Ping execution failed", (Throwable)ex);
                if (!counted.compareAndSet(false, true)) continue;
                latch.countDown();
            }
        }
        try {
            latch.await();
            return response;
        }
        catch (InterruptedException e) {
            this.logger.trace("pingAndWait interrupted");
            return response;
        }
    }
}

