/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.engine;

import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.search.SearcherFactory;
import org.apache.lucene.search.SearcherManager;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.IOUtils;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.lucene.index.ElasticsearchDirectoryReader;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.ReleasableLock;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.engine.EngineClosedException;
import org.elasticsearch.index.engine.EngineConfig;
import org.elasticsearch.index.engine.EngineCreationFailureException;
import org.elasticsearch.index.engine.EngineException;
import org.elasticsearch.index.engine.EngineSearcherFactory;
import org.elasticsearch.index.engine.FlushFailedEngineException;
import org.elasticsearch.index.engine.RefreshFailedEngineException;
import org.elasticsearch.index.engine.Segment;
import org.elasticsearch.index.translog.Translog;

public class ShadowEngine
extends Engine {
    public static final String NONEXISTENT_INDEX_RETRY_WAIT = "index.shadow.wait_for_initial_commit";
    public static final TimeValue DEFAULT_NONEXISTENT_INDEX_RETRY_WAIT = TimeValue.timeValueSeconds(5L);
    private volatile SearcherManager searcherManager;
    private volatile SegmentInfos lastCommittedSegmentInfos;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ShadowEngine(EngineConfig engineConfig) {
        block9: {
            super(engineConfig);
            if (engineConfig.getRefreshListeners() != null) {
                throw new IllegalArgumentException("ShadowEngine doesn't support RefreshListeners");
            }
            EngineSearcherFactory searcherFactory = new EngineSearcherFactory(engineConfig);
            long nonexistentRetryTime = engineConfig.getIndexSettings().getSettings().getAsTime(NONEXISTENT_INDEX_RETRY_WAIT, DEFAULT_NONEXISTENT_INDEX_RETRY_WAIT).getMillis();
            try {
                ElasticsearchDirectoryReader reader = null;
                this.store.incRef();
                boolean success = false;
                try {
                    if (!Lucene.waitForIndex(this.store.directory(), nonexistentRetryTime)) {
                        throw new IllegalStateException("failed to open a shadow engine after" + nonexistentRetryTime + "ms, directory is not an index");
                    }
                    reader = ElasticsearchDirectoryReader.wrap(DirectoryReader.open((Directory)this.store.directory()), this.shardId);
                    this.searcherManager = new SearcherManager((DirectoryReader)reader, (SearcherFactory)searcherFactory);
                    this.lastCommittedSegmentInfos = ShadowEngine.readLastCommittedSegmentInfos(this.searcherManager, this.store);
                    success = true;
                    if (success) break block9;
                }
                catch (Exception e) {
                    try {
                        this.logger.warn("failed to create new reader", (Throwable)e);
                        throw e;
                    }
                    catch (Throwable throwable) {
                        if (!success) {
                            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{reader});
                            this.store.decRef();
                        }
                        throw throwable;
                    }
                }
                IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{reader});
                this.store.decRef();
            }
            catch (IOException ex) {
                throw new EngineCreationFailureException(this.shardId, "failed to open index reader", ex);
            }
        }
        this.logger.trace("created new ShadowEngine");
    }

    @Override
    public void index(Engine.Index index) throws EngineException {
        throw new UnsupportedOperationException(this.shardId + " index operation not allowed on shadow engine");
    }

    @Override
    public void delete(Engine.Delete delete) throws EngineException {
        throw new UnsupportedOperationException(this.shardId + " delete operation not allowed on shadow engine");
    }

    @Override
    public Engine.SyncedFlushResult syncFlush(String syncId, Engine.CommitId expectedCommitId) {
        throw new UnsupportedOperationException(this.shardId + " sync commit operation not allowed on shadow engine");
    }

    @Override
    public Engine.CommitId flush() throws EngineException {
        return this.flush(false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Engine.CommitId flush(boolean force, boolean waitIfOngoing) throws EngineException {
        this.logger.trace("skipping FLUSH on shadow engine");
        this.refresh("flush");
        this.store.incRef();
        try (ReleasableLock lock = this.readLock.acquire();){
            this.lastCommittedSegmentInfos = ShadowEngine.readLastCommittedSegmentInfos(this.searcherManager, this.store);
        }
        catch (Exception e) {
            if (!this.isClosed.get()) {
                this.logger.warn("failed to read latest segment infos on flush", (Throwable)e);
                if (Lucene.isCorruptionException(e)) {
                    throw new FlushFailedEngineException(this.shardId, (Throwable)e);
                }
            }
        }
        finally {
            this.store.decRef();
        }
        return new Engine.CommitId(this.lastCommittedSegmentInfos.getId());
    }

    @Override
    public void forceMerge(boolean flush, int maxNumSegments, boolean onlyExpungeDeletes, boolean upgrade, boolean upgradeOnlyAncientSegments) throws EngineException {
        this.logger.trace("skipping FORCE-MERGE on shadow engine");
    }

    @Override
    public Engine.GetResult get(Engine.Get get, Function<String, Engine.Searcher> searcherFacotry) throws EngineException {
        return this.getFromSearcher(get, searcherFacotry);
    }

    @Override
    public Translog getTranslog() {
        throw new UnsupportedOperationException("shadow engines don't have translogs");
    }

    @Override
    public List<Segment> segments(boolean verbose) {
        try (ReleasableLock lock = this.readLock.acquire();){
            Segment[] segmentsArr = this.getSegmentInfo(this.lastCommittedSegmentInfos, verbose);
            for (int i = 0; i < segmentsArr.length; ++i) {
                segmentsArr[i].committed = true;
            }
            List<Segment> list = Arrays.asList(segmentsArr);
            return list;
        }
    }

    @Override
    public void refresh(String source) throws EngineException {
        try (ReleasableLock lock = this.readLock.acquire();){
            this.ensureOpen();
            this.searcherManager.maybeRefreshBlocking();
        }
        catch (AlreadyClosedException e) {
            throw new AssertionError((Object)e);
        }
        catch (EngineClosedException e) {
            throw e;
        }
        catch (Exception e) {
            try {
                this.failEngine("refresh failed", e);
            }
            catch (Exception inner) {
                e.addSuppressed(inner);
            }
            throw new RefreshFailedEngineException(this.shardId, (Throwable)e);
        }
    }

    @Override
    public IndexCommit acquireIndexCommit(boolean flushFirst) throws EngineException {
        throw new UnsupportedOperationException("Can not take snapshot from a shadow engine");
    }

    @Override
    protected SearcherManager getSearcherManager() {
        return this.searcherManager;
    }

    @Override
    protected void closeNoLock(String reason) {
        if (this.isClosed.compareAndSet(false, true)) {
            try {
                this.logger.debug("shadow replica close searcher manager refCount: {}", (Object)this.store.refCount());
                IOUtils.close((Closeable[])new Closeable[]{this.searcherManager});
            }
            catch (Exception e) {
                this.logger.warn("shadow replica failed to close searcher manager", (Throwable)e);
            }
            finally {
                this.store.decRef();
            }
        }
    }

    @Override
    protected SegmentInfos getLastCommittedSegmentInfos() {
        return this.lastCommittedSegmentInfos;
    }

    @Override
    public long getIndexBufferRAMBytesUsed() {
        throw new UnsupportedOperationException("ShadowEngine has no IndexWriter");
    }

    @Override
    public void writeIndexingBuffer() {
        throw new UnsupportedOperationException("ShadowEngine has no IndexWriter");
    }

    @Override
    public void activateThrottling() {
        throw new UnsupportedOperationException("ShadowEngine has no IndexWriter");
    }

    @Override
    public void deactivateThrottling() {
        throw new UnsupportedOperationException("ShadowEngine has no IndexWriter");
    }

    @Override
    public Engine recoverFromTranslog() throws IOException {
        throw new UnsupportedOperationException("can't recover on a shadow engine");
    }
}

