/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.interop;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.object.DynamicObject;
import java.util.ArrayList;
import org.jruby.RubyArray;
import org.jruby.RubyException;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.language.RubyNode;

public class JRubyInterop {
    private RubyContext context;
    private String originalInputFile;

    public JRubyInterop(RubyContext context) {
        this.context = context;
    }

    @CompilerDirectives.TruffleBoundary
    public DynamicObject toTruffle(RubyException jrubyException, RubyNode currentNode) {
        switch (jrubyException.getMetaClass().getName()) {
            case "ArgumentError": {
                return this.context.getCoreExceptions().argumentError(jrubyException.getMessage().toString(), currentNode);
            }
            case "RegexpError": {
                return this.context.getCoreExceptions().regexpError(jrubyException.getMessage().toString(), currentNode);
            }
        }
        throw new UnsupportedOperationException();
    }

    @CompilerDirectives.TruffleBoundary
    public String getArg0() {
        return this.context.getJRubyRuntime().getGlobalVariables().get("$0").toString();
    }

    public String[] getArgv() {
        IRubyObject[] jrubyStrings = ((RubyArray)this.context.getJRubyRuntime().getObject().getConstant("ARGV")).toJavaArray();
        String[] strings = new String[jrubyStrings.length];
        for (int n = 0; n < strings.length; ++n) {
            strings[n] = jrubyStrings[n].toString();
        }
        return strings;
    }

    public String[] getOriginalLoadPath() {
        ArrayList<String> loadPath = new ArrayList<String>();
        for (IRubyObject path : ((RubyArray)this.context.getJRubyRuntime().getLoadService().getLoadPath()).toJavaArray()) {
            String pathString = path.toString();
            if (pathString.endsWith("lib/ruby/2.2/site_ruby") || pathString.endsWith("lib/ruby/shared") || pathString.endsWith("lib/ruby/stdlib")) continue;
            if (pathString.startsWith("uri:classloader:")) {
                pathString = "jruby:" + pathString.substring("uri:classloader:".length());
            }
            loadPath.add(pathString);
        }
        return loadPath.toArray(new String[loadPath.size()]);
    }

    public void setVerbose(boolean verbose) {
        this.context.getJRubyRuntime().setVerbose((IRubyObject)this.context.getJRubyRuntime().newBoolean(verbose));
    }

    public void setVerboseNil() {
        this.context.getJRubyRuntime().setVerbose(this.context.getJRubyRuntime().getNil());
    }

    public void setOriginalInputFile(String originalInputFile) {
        this.originalInputFile = originalInputFile;
    }

    public String getOriginalInputFile() {
        return this.originalInputFile;
    }
}

