/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.diagnostics.DiagnosticUtils;
import org.jetbrains.kotlin.psi.KtTreeVisitorVoid;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.diagnostics.Diagnostics;

public class AnalyzingUtils {
    public static void checkForSyntacticErrors(@NotNull PsiElement root) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "org/jetbrains/kotlin/resolve/AnalyzingUtils", "checkForSyntacticErrors"));
        }
        root.acceptChildren(new PsiErrorElementVisitor(){

            @Override
            public void visitErrorElement(@NotNull PsiErrorElement element) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/resolve/AnalyzingUtils$1", "visitErrorElement"));
                }
                throw new IllegalArgumentException(element.getErrorDescription() + "; looking at " + element.getNode().getElementType() + " '" + element.getText() + DiagnosticUtils.atLocation(element));
            }
        });
    }

    public static List<PsiErrorElement> getSyntaxErrorRanges(@NotNull PsiElement root) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "org/jetbrains/kotlin/resolve/AnalyzingUtils", "getSyntaxErrorRanges"));
        }
        final ArrayList<PsiErrorElement> r = new ArrayList<PsiErrorElement>();
        root.acceptChildren(new PsiErrorElementVisitor(){

            @Override
            public void visitErrorElement(@NotNull PsiErrorElement element) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/resolve/AnalyzingUtils$2", "visitErrorElement"));
                }
                r.add(element);
            }
        });
        return r;
    }

    public static void throwExceptionOnErrors(BindingContext bindingContext) {
        AnalyzingUtils.throwExceptionOnErrors(bindingContext.getDiagnostics());
    }

    public static void throwExceptionOnErrors(Diagnostics diagnostics2) {
        for (Diagnostic diagnostic : diagnostics2) {
            DiagnosticSink.THROW_EXCEPTION.report(diagnostic);
        }
    }

    public static String formDebugNameForBindingTrace(@NotNull String debugName, @Nullable Object resolutionSubjectForMessage) {
        if (debugName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugName", "org/jetbrains/kotlin/resolve/AnalyzingUtils", "formDebugNameForBindingTrace"));
        }
        return "";
    }

    public static abstract class PsiErrorElementVisitor
    extends KtTreeVisitorVoid {
        @Override
        public abstract void visitErrorElement(@NotNull PsiErrorElement var1);
    }
}

