/*
 * Decompiled with CFR 0.152.
 */
package java.sql;

import java.sql.DriverManager;
import java.sql.SQLWarning;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

public class SQLException
extends Exception
implements Iterable<Throwable> {
    private String SQLState;
    private int vendorCode;
    private volatile SQLException next;
    private static final AtomicReferenceFieldUpdater<SQLException, SQLException> nextUpdater = AtomicReferenceFieldUpdater.newUpdater(SQLException.class, SQLException.class, "next");
    private static final long serialVersionUID = 2135244094396331484L;

    public SQLException(String reason, String SQLState, int vendorCode) {
        super(reason);
        this.SQLState = SQLState;
        this.vendorCode = vendorCode;
        if (!(this instanceof SQLWarning) && DriverManager.getLogWriter() != null) {
            DriverManager.println("SQLState(" + SQLState + ") vendor code(" + vendorCode + ")");
            this.printStackTrace(DriverManager.getLogWriter());
        }
    }

    public SQLException(String reason, String SQLState) {
        super(reason);
        this.SQLState = SQLState;
        this.vendorCode = 0;
        if (!(this instanceof SQLWarning) && DriverManager.getLogWriter() != null) {
            this.printStackTrace(DriverManager.getLogWriter());
            DriverManager.println("SQLException: SQLState(" + SQLState + ")");
        }
    }

    public SQLException(String reason) {
        super(reason);
        this.SQLState = null;
        this.vendorCode = 0;
        if (!(this instanceof SQLWarning) && DriverManager.getLogWriter() != null) {
            this.printStackTrace(DriverManager.getLogWriter());
        }
    }

    public SQLException() {
        this.SQLState = null;
        this.vendorCode = 0;
        if (!(this instanceof SQLWarning) && DriverManager.getLogWriter() != null) {
            this.printStackTrace(DriverManager.getLogWriter());
        }
    }

    public SQLException(Throwable cause) {
        super(cause);
        if (!(this instanceof SQLWarning) && DriverManager.getLogWriter() != null) {
            this.printStackTrace(DriverManager.getLogWriter());
        }
    }

    public SQLException(String reason, Throwable cause) {
        super(reason, cause);
        if (!(this instanceof SQLWarning) && DriverManager.getLogWriter() != null) {
            this.printStackTrace(DriverManager.getLogWriter());
        }
    }

    public SQLException(String reason, String sqlState, Throwable cause) {
        super(reason, cause);
        this.SQLState = sqlState;
        this.vendorCode = 0;
        if (!(this instanceof SQLWarning) && DriverManager.getLogWriter() != null) {
            this.printStackTrace(DriverManager.getLogWriter());
            DriverManager.println("SQLState(" + this.SQLState + ")");
        }
    }

    public SQLException(String reason, String sqlState, int vendorCode, Throwable cause) {
        super(reason, cause);
        this.SQLState = sqlState;
        this.vendorCode = vendorCode;
        if (!(this instanceof SQLWarning) && DriverManager.getLogWriter() != null) {
            DriverManager.println("SQLState(" + this.SQLState + ") vendor code(" + vendorCode + ")");
            this.printStackTrace(DriverManager.getLogWriter());
        }
    }

    public String getSQLState() {
        return this.SQLState;
    }

    public int getErrorCode() {
        return this.vendorCode;
    }

    public SQLException getNextException() {
        return this.next;
    }

    public void setNextException(SQLException ex) {
        SQLException current = this;
        while (true) {
            SQLException next;
            if ((next = current.next) != null) {
                current = next;
                continue;
            }
            if (nextUpdater.compareAndSet(current, null, ex)) {
                return;
            }
            current = current.next;
        }
    }

    @Override
    public Iterator<Throwable> iterator() {
        return new Iterator<Throwable>(){
            SQLException firstException;
            SQLException nextException;
            Throwable cause;
            {
                this.firstException = SQLException.this;
                this.nextException = this.firstException.getNextException();
                this.cause = this.firstException.getCause();
            }

            @Override
            public boolean hasNext() {
                return this.firstException != null || this.nextException != null || this.cause != null;
            }

            @Override
            public Throwable next() {
                Throwable throwable = null;
                if (this.firstException != null) {
                    throwable = this.firstException;
                    this.firstException = null;
                } else if (this.cause != null) {
                    throwable = this.cause;
                    this.cause = this.cause.getCause();
                } else if (this.nextException != null) {
                    throwable = this.nextException;
                    this.cause = this.nextException.getCause();
                    this.nextException = this.nextException.getNextException();
                } else {
                    throw new NoSuchElementException();
                }
                return throwable;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

