/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest;

import java.util.Collections;
import java.util.Map;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.ingest.TemplateService;
import org.elasticsearch.script.CompiledScript;
import org.elasticsearch.script.ExecutableScript;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptContext;
import org.elasticsearch.script.ScriptService;

public class InternalTemplateService
implements TemplateService {
    private final ScriptService scriptService;

    InternalTemplateService(ScriptService scriptService) {
        this.scriptService = scriptService;
    }

    @Override
    public TemplateService.Template compile(final String template) {
        int mustacheStart = template.indexOf("{{");
        int mustacheEnd = template.indexOf("}}");
        if (mustacheStart != -1 && mustacheEnd != -1 && mustacheStart < mustacheEnd) {
            Script script = new Script(template, ScriptService.ScriptType.INLINE, "mustache", Collections.emptyMap());
            final CompiledScript compiledScript = this.scriptService.compile(script, ScriptContext.Standard.INGEST, Collections.emptyMap());
            return new TemplateService.Template(){

                @Override
                public String execute(Map<String, Object> model) {
                    ExecutableScript executableScript = InternalTemplateService.this.scriptService.executable(compiledScript, model);
                    Object result = executableScript.run();
                    if (result instanceof BytesReference) {
                        return ((BytesReference)result).utf8ToString();
                    }
                    return String.valueOf(result);
                }

                @Override
                public String getKey() {
                    return template;
                }
            };
        }
        return new StringTemplate(template);
    }

    class StringTemplate
    implements TemplateService.Template {
        private final String value;

        public StringTemplate(String value) {
            this.value = value;
        }

        @Override
        public String execute(Map<String, Object> model) {
            return this.value;
        }

        @Override
        public String getKey() {
            return this.value;
        }
    }
}

