/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless.node;

import java.util.Objects;
import java.util.Set;
import org.elasticsearch.painless.Definition;
import org.elasticsearch.painless.FunctionRef;
import org.elasticsearch.painless.Globals;
import org.elasticsearch.painless.Locals;
import org.elasticsearch.painless.Location;
import org.elasticsearch.painless.MethodWriter;
import org.elasticsearch.painless.WriterConstants;
import org.elasticsearch.painless.node.AExpression;
import org.elasticsearch.painless.node.ILambda;
import org.objectweb.asm.Type;

public final class EFunctionRef
extends AExpression
implements ILambda {
    private final String type;
    private final String call;
    private FunctionRef ref;
    private String defPointer;

    public EFunctionRef(Location location, String type, String call) {
        super(location);
        this.type = Objects.requireNonNull(type);
        this.call = Objects.requireNonNull(call);
    }

    @Override
    void extractVariables(Set<String> variables) {
    }

    @Override
    void analyze(Locals locals) {
        if (this.expected == null) {
            this.ref = null;
            this.actual = Definition.getType("String");
            this.defPointer = "S" + this.type + "." + this.call + ",0";
        } else {
            this.defPointer = null;
            try {
                if ("this".equals(this.type)) {
                    Definition.Method interfaceMethod = this.expected.struct.getFunctionalMethod();
                    if (interfaceMethod == null) {
                        throw new IllegalArgumentException("Cannot convert function reference [" + this.type + "::" + this.call + "] to [" + this.expected.name + "], not a functional interface");
                    }
                    Definition.Method implMethod = locals.getMethod(new Definition.MethodKey(this.call, interfaceMethod.arguments.size()));
                    if (implMethod == null) {
                        throw new IllegalArgumentException("Cannot convert function reference [" + this.type + "::" + this.call + "] to [" + this.expected.name + "], function not found");
                    }
                    this.ref = new FunctionRef(this.expected, interfaceMethod, implMethod, 0);
                } else {
                    this.ref = new FunctionRef(this.expected, this.type, this.call, 0);
                }
            }
            catch (IllegalArgumentException e) {
                throw this.createError(e);
            }
            this.actual = this.expected;
        }
    }

    @Override
    void write(MethodWriter writer, Globals globals) {
        if (this.ref != null) {
            writer.writeDebugInfo(this.location);
            String invokedType = this.ref.invokedType.toMethodDescriptorString();
            Type samMethodType = Type.getMethodType((String)this.ref.samMethodType.toMethodDescriptorString());
            Type interfaceType = Type.getMethodType((String)this.ref.interfaceMethodType.toMethodDescriptorString());
            if (this.ref.needsBridges()) {
                writer.invokeDynamic(this.ref.invokedName, invokedType, WriterConstants.LAMBDA_BOOTSTRAP_HANDLE, new Object[]{samMethodType, this.ref.implMethodASM, samMethodType, 4, 1, interfaceType});
            } else {
                writer.invokeDynamic(this.ref.invokedName, invokedType, WriterConstants.LAMBDA_BOOTSTRAP_HANDLE, new Object[]{samMethodType, this.ref.implMethodASM, samMethodType, 0});
            }
        } else {
            writer.push(null);
        }
    }

    @Override
    public String getPointer() {
        return this.defPointer;
    }

    @Override
    public Type[] getCaptures() {
        return new Type[0];
    }
}

