/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless.node;

import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.elasticsearch.painless.Constant;
import org.elasticsearch.painless.Definition;
import org.elasticsearch.painless.Globals;
import org.elasticsearch.painless.Locals;
import org.elasticsearch.painless.Location;
import org.elasticsearch.painless.MethodWriter;
import org.elasticsearch.painless.WriterConstants;
import org.elasticsearch.painless.node.AExpression;

public final class ERegex
extends AExpression {
    private final String pattern;
    private final int flags;
    private Constant constant;

    public ERegex(Location location, String pattern, String flagsString) {
        super(location);
        this.pattern = pattern;
        int flags = 0;
        for (int c = 0; c < flagsString.length(); ++c) {
            flags |= this.flagForChar(flagsString.charAt(c));
        }
        this.flags = flags;
    }

    @Override
    void extractVariables(Set<String> variables) {
    }

    @Override
    void analyze(Locals locals) {
        if (!this.read) {
            throw this.createError(new IllegalArgumentException("Regex constant may only be read [" + this.pattern + "]."));
        }
        try {
            Pattern.compile(this.pattern, this.flags);
        }
        catch (PatternSyntaxException exception) {
            throw this.createError(exception);
        }
        this.constant = new Constant(this.location, Definition.PATTERN_TYPE.type, "regexAt$" + this.location.getOffset(), this::initializeConstant);
        this.actual = Definition.PATTERN_TYPE;
    }

    @Override
    void write(MethodWriter writer, Globals globals) {
        writer.writeDebugInfo(this.location);
        writer.getStatic(WriterConstants.CLASS_TYPE, this.constant.name, Definition.PATTERN_TYPE.type);
        globals.addConstantInitializer(this.constant);
    }

    private void initializeConstant(MethodWriter writer) {
        writer.push(this.pattern);
        writer.push(this.flags);
        writer.invokeStatic(Definition.PATTERN_TYPE.type, WriterConstants.PATTERN_COMPILE);
    }

    private int flagForChar(char c) {
        switch (c) {
            case 'c': {
                return 128;
            }
            case 'i': {
                return 2;
            }
            case 'l': {
                return 16;
            }
            case 'm': {
                return 8;
            }
            case 's': {
                return 32;
            }
            case 'U': {
                return 256;
            }
            case 'u': {
                return 64;
            }
            case 'x': {
                return 4;
            }
        }
        throw new IllegalArgumentException("Unknown flag [" + c + "]");
    }
}

