/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless.node;

import java.util.Objects;
import java.util.Set;
import org.elasticsearch.painless.Definition;
import org.elasticsearch.painless.Globals;
import org.elasticsearch.painless.Locals;
import org.elasticsearch.painless.Location;
import org.elasticsearch.painless.MethodWriter;
import org.elasticsearch.painless.node.AExpression;
import org.elasticsearch.painless.node.AStatement;

public final class SExpression
extends AStatement {
    private AExpression expression;

    public SExpression(Location location, AExpression expression) {
        super(location);
        this.expression = Objects.requireNonNull(expression);
    }

    @Override
    void extractVariables(Set<String> variables) {
        this.expression.extractVariables(variables);
    }

    @Override
    void analyze(Locals locals) {
        Definition.Type rtnType = locals.getReturnType();
        boolean isVoid = rtnType.sort == Definition.Sort.VOID;
        this.expression.read = this.lastSource && !isVoid;
        this.expression.analyze(locals);
        if (!this.lastSource && !this.expression.statement) {
            throw this.createError(new IllegalArgumentException("Not a statement."));
        }
        boolean rtn = this.lastSource && !isVoid && this.expression.actual.sort != Definition.Sort.VOID;
        this.expression.expected = rtn ? rtnType : this.expression.actual;
        this.expression.internal = rtn;
        this.expression = this.expression.cast(locals);
        this.methodEscape = rtn;
        this.loopEscape = rtn;
        this.allEscape = rtn;
        this.statementCount = 1;
    }

    @Override
    void write(MethodWriter writer, Globals globals) {
        writer.writeStatementOffset(this.location);
        this.expression.write(writer, globals);
        if (this.methodEscape) {
            writer.returnValue();
        } else {
            writer.writePop(this.expression.expected.sort.size);
        }
    }
}

