/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.vm;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.vm.ContextStore;

final class ContextStoreProfile {
    private static final ContextStore UNINTIALIZED_STORE = new ContextStore(null, 0);
    private final Assumption dynamicStoreAssumption = Truffle.getRuntime().createAssumption("constant context store");
    private final Assumption constantStoreAssumption = Truffle.getRuntime().createAssumption("dynamic context store");
    @CompilerDirectives.CompilationFinal
    private ContextStore constantStore;
    private volatile ContextStore dynamicStore = UNINTIALIZED_STORE;
    private volatile Thread singleThread;
    private volatile ThreadLocal<ContextStore> threadStore;

    ContextStoreProfile(ContextStore initialStore) {
        this.constantStore = initialStore == null ? UNINTIALIZED_STORE : initialStore;
    }

    ContextStore get() {
        ContextStore store = this.constantStoreAssumption.isValid() ? this.constantStore : (this.dynamicStoreAssumption.isValid() ? this.dynamicStore : ContextStoreProfile.getThreadLocalStore(this.threadStore));
        return store;
    }

    void enter(ContextStore store) {
        assert (store != null);
        if (this.constantStore == store && this.constantStoreAssumption.isValid()) {
            return;
        }
        if (Thread.currentThread() == this.singleThread && this.dynamicStore != UNINTIALIZED_STORE && this.dynamicStoreAssumption.isValid()) {
            this.dynamicStore = store;
            return;
        }
        ThreadLocal<ContextStore> tlstore = this.threadStore;
        if (tlstore != null) {
            ContextStore currentstore = ContextStoreProfile.getThreadLocalStore(tlstore);
            if (currentstore != store) {
                tlstore.set(store);
            }
            return;
        }
        this.slowPathProfile(store);
    }

    @CompilerDirectives.TruffleBoundary
    private synchronized void slowPathProfile(ContextStore store) {
        if (this.constantStoreAssumption.isValid()) {
            if (this.constantStore == UNINTIALIZED_STORE) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.constantStore = store;
                this.singleThread = Thread.currentThread();
                return;
            }
            this.constantStoreAssumption.invalidate();
        }
        if (this.dynamicStoreAssumption.isValid()) {
            Thread currentThread = Thread.currentThread();
            if (this.dynamicStore == UNINTIALIZED_STORE && this.singleThread == currentThread) {
                this.dynamicStore = store;
                return;
            }
            final ContextStore initialStore = this.dynamicStore == UNINTIALIZED_STORE ? this.constantStore : this.dynamicStore;
            this.threadStore = new ThreadLocal<ContextStore>(){

                @Override
                protected ContextStore initialValue() {
                    return initialStore;
                }
            };
            this.threadStore.set(store);
            this.dynamicStoreAssumption.invalidate();
        }
        this.constantStore = null;
        this.dynamicStore = null;
        this.singleThread = null;
        assert (!this.constantStoreAssumption.isValid());
        assert (!this.dynamicStoreAssumption.isValid());
        assert (this.threadStore != null);
    }

    @CompilerDirectives.TruffleBoundary
    private static ContextStore getThreadLocalStore(ThreadLocal<ContextStore> tls) {
        return tls.get();
    }
}

