/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.rope;

import com.oracle.truffle.api.CompilerDirectives;
import org.jcodings.Encoding;
import org.jruby.truffle.core.rope.CodeRange;
import org.jruby.truffle.core.rope.Rope;

public class ConcatRope
extends Rope {
    private final Rope left;
    private final Rope right;

    public ConcatRope(Rope left, Rope right, Encoding encoding, CodeRange codeRange, boolean singleByteOptimizable, int depth) {
        this(left, right, encoding, codeRange, singleByteOptimizable, depth, null);
    }

    private ConcatRope(Rope left, Rope right, Encoding encoding, CodeRange codeRange, boolean singleByteOptimizable, int depth, byte[] bytes) {
        super(encoding, codeRange, singleByteOptimizable, left.byteLength() + right.byteLength(), left.characterLength() + right.characterLength(), depth, bytes);
        this.left = left;
        this.right = right;
    }

    @Override
    public Rope withEncoding(Encoding newEncoding, CodeRange newCodeRange) {
        if (newCodeRange != this.getCodeRange()) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new UnsupportedOperationException("Cannot fast-path updating encoding with different code range.");
        }
        return new ConcatRope(this.getLeft(), this.getRight(), newEncoding, newCodeRange, this.isSingleByteOptimizable(), this.depth(), this.getRawBytes());
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public byte getByteSlow(int index) {
        if (index < this.left.byteLength()) {
            return this.left.getByteSlow(index);
        }
        return this.right.getByteSlow(index - this.left.byteLength());
    }

    public Rope getLeft() {
        return this.left;
    }

    public Rope getRight() {
        return this.right;
    }

    public String toString() {
        return this.left.toString() + this.right.toString();
    }
}

