/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.view.messagelocation.http;

import java.awt.BorderLayout;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import org.apache.commons.configuration.FileConfiguration;
import org.parosproxy.paros.network.HttpMessage;
import org.zaproxy.zap.extension.httppanel.component.split.request.RequestSplitComponent;
import org.zaproxy.zap.extension.httppanel.component.split.response.ResponseSplitComponent;
import org.zaproxy.zap.model.MessageLocation;
import org.zaproxy.zap.utils.ZapXmlConfiguration;
import org.zaproxy.zap.view.HttpPanelManager;
import org.zaproxy.zap.view.messagelocation.SelectMessageLocationsPanel;
import org.zaproxy.zap.view.messagelocation.http.DefaultHttpMessageLocationsPanel;

public class HttpMessageLocationsPanel
extends JPanel {
    private static final long serialVersionUID = -5501414760564977715L;
    private DefaultHttpMessageLocationsPanel locationsPanel;
    private SelectMessageLocationsPanel selectMessageLocationsPanel;
    private boolean request;

    public HttpMessageLocationsPanel(boolean bl, HttpMessage httpMessage, String string) {
        super(new BorderLayout());
        this.request = bl;
        this.selectMessageLocationsPanel = new SelectMessageLocationsPanel();
        if (bl) {
            this.selectMessageLocationsPanel.addComponent(new RequestSplitComponent(), (FileConfiguration)new ZapXmlConfiguration());
            HttpPanelManager.getInstance().addRequestPanel(this.selectMessageLocationsPanel);
        } else {
            this.selectMessageLocationsPanel.addComponent(new ResponseSplitComponent(), (FileConfiguration)new ZapXmlConfiguration());
            HttpPanelManager.getInstance().addResponsePanel(this.selectMessageLocationsPanel);
        }
        this.selectMessageLocationsPanel.setMessage(httpMessage, true);
        this.locationsPanel = new DefaultHttpMessageLocationsPanel(this, this.selectMessageLocationsPanel);
        this.selectMessageLocationsPanel.addFocusListener(this.locationsPanel.getFocusListenerAddButtonEnabler());
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        GroupLayout groupLayout = new GroupLayout(jPanel);
        jPanel.setLayout(groupLayout);
        groupLayout.setAutoCreateGaps(true);
        groupLayout.setAutoCreateContainerGaps(true);
        JLabel jLabel = new JLabel(string);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup().addComponent(jLabel).addComponent(this.locationsPanel));
        groupLayout.setVerticalGroup(groupLayout.createSequentialGroup().addComponent(jLabel).addComponent(this.locationsPanel));
        JSplitPane jSplitPane = new JSplitPane(1, this.selectMessageLocationsPanel, jPanel);
        jSplitPane.setResizeWeight(0.6);
        this.add(jSplitPane);
    }

    public boolean setSelectedContainer(String string) {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("Parameter containerName must not be null nor empty.");
        }
        return this.selectMessageLocationsPanel.setSelectedView(string);
    }

    public boolean addMessageLocation(MessageLocation messageLocation) {
        if (messageLocation == null) {
            throw new IllegalArgumentException("Parameter messageLocation must not be null.");
        }
        return this.locationsPanel.addMessageLocation(messageLocation);
    }

    public void clear() {
        if (this.request) {
            HttpPanelManager.getInstance().removeRequestPanel(this.selectMessageLocationsPanel);
        } else {
            HttpPanelManager.getInstance().removeResponsePanel(this.selectMessageLocationsPanel);
        }
    }

    public List<MessageLocation> getLocations() {
        return this.locationsPanel.getLocations();
    }
}

