/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.http.netty3;

import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.http.netty3.Netty3HttpChannel;
import org.elasticsearch.http.netty3.Netty3HttpRequest;
import org.elasticsearch.http.netty3.Netty3HttpServerTransport;
import org.elasticsearch.http.netty3.pipelining.OrderedUpstreamMessageEvent;
import org.elasticsearch.rest.RestChannel;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.handler.codec.http.HttpRequest;

@ChannelHandler.Sharable
public class Netty3HttpRequestHandler
extends SimpleChannelUpstreamHandler {
    private final Netty3HttpServerTransport serverTransport;
    private final boolean httpPipeliningEnabled;
    private final boolean detailedErrorsEnabled;
    private final ThreadContext threadContext;

    public Netty3HttpRequestHandler(Netty3HttpServerTransport serverTransport, boolean detailedErrorsEnabled, ThreadContext threadContext) {
        this.serverTransport = serverTransport;
        this.httpPipeliningEnabled = serverTransport.pipelining;
        this.detailedErrorsEnabled = detailedErrorsEnabled;
        this.threadContext = threadContext;
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        HttpRequest request;
        OrderedUpstreamMessageEvent oue = null;
        if (this.httpPipeliningEnabled && e instanceof OrderedUpstreamMessageEvent) {
            oue = (OrderedUpstreamMessageEvent)e;
            request = (HttpRequest)oue.getMessage();
        } else {
            request = (HttpRequest)e.getMessage();
        }
        Netty3HttpRequest httpRequest = new Netty3HttpRequest(request, e.getChannel());
        Netty3HttpChannel channel = new Netty3HttpChannel(this.serverTransport, httpRequest, oue, this.detailedErrorsEnabled, this.threadContext);
        this.serverTransport.dispatchRequest(httpRequest, (RestChannel)channel);
        super.messageReceived(ctx, e);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        this.serverTransport.exceptionCaught(ctx, e);
    }
}

