/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support;

import java.util.function.Supplier;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.TransportAction;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportRequestHandler;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportService;

public abstract class HandledTransportAction<Request extends ActionRequest<Request>, Response extends ActionResponse>
extends TransportAction<Request, Response> {
    protected HandledTransportAction(Settings settings, String actionName, ThreadPool threadPool, TransportService transportService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<Request> request) {
        this(settings, actionName, true, threadPool, transportService, actionFilters, indexNameExpressionResolver, request);
    }

    protected HandledTransportAction(Settings settings, String actionName, boolean canTripCircuitBreaker, ThreadPool threadPool, TransportService transportService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<Request> request) {
        super(settings, actionName, threadPool, actionFilters, indexNameExpressionResolver, transportService.getTaskManager());
        transportService.registerRequestHandler(actionName, request, "same", false, canTripCircuitBreaker, new TransportHandler());
    }

    class TransportHandler
    implements TransportRequestHandler<Request> {
        TransportHandler() {
        }

        @Override
        public final void messageReceived(Request request, TransportChannel channel) throws Exception {
            throw new UnsupportedOperationException("the task parameter is required for this operation");
        }

        @Override
        public final void messageReceived(Request request, final TransportChannel channel, Task task) throws Exception {
            HandledTransportAction.this.execute(task, request, new ActionListener<Response>((ActionRequest)request){
                final /* synthetic */ ActionRequest val$request;
                {
                    this.val$request = actionRequest;
                }

                @Override
                public void onResponse(Response response) {
                    try {
                        channel.sendResponse((TransportResponse)response);
                    }
                    catch (Exception e) {
                        this.onFailure(e);
                    }
                }

                @Override
                public void onFailure(Exception e) {
                    try {
                        channel.sendResponse(e);
                    }
                    catch (Exception e1) {
                        HandledTransportAction.this.logger.warn(() -> new ParameterizedMessage("Failed to send error response for action [{}] and request [{}]", (Object)HandledTransportAction.this.actionName, (Object)this.val$request), (Throwable)e1);
                    }
                }
            });
        }
    }
}

