/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.bootstrap;

import java.io.FilePermission;
import java.io.IOException;
import java.net.SocketPermission;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.AccessMode;
import java.nio.file.DirectoryStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NotDirectoryException;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.NoSuchAlgorithmException;
import java.security.Permissions;
import java.security.Policy;
import java.security.URIParameter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.SecureSM;
import org.elasticsearch.Version;
import org.elasticsearch.bootstrap.ESPolicy;
import org.elasticsearch.bootstrap.JarHell;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.SuppressForbidden;
import org.elasticsearch.common.io.PathUtils;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.http.HttpTransportSettings;
import org.elasticsearch.transport.TransportSettings;

final class Security {
    private Security() {
    }

    static void configure(Environment environment, boolean filterBadDefaults) throws IOException, NoSuchAlgorithmException {
        Policy.setPolicy(new ESPolicy(Security.createPermissions(environment), Security.getPluginPermissions(environment), filterBadDefaults));
        System.setSecurityManager((SecurityManager)new SecureSM(new String[]{"org.elasticsearch.bootstrap.", "org.elasticsearch.cli"}));
        Security.selfTest();
    }

    @SuppressForbidden(reason="proper use of URL")
    static Map<String, Policy> getPluginPermissions(Environment environment) throws IOException, NoSuchAlgorithmException {
        Throwable throwable;
        DirectoryStream<Path> stream;
        HashMap<String, Policy> map = new HashMap<String, Policy>();
        ArrayList<Path> pluginsAndModules = new ArrayList<Path>();
        if (Files.exists(environment.pluginsFile(), new LinkOption[0])) {
            stream = Files.newDirectoryStream(environment.pluginsFile());
            throwable = null;
            try {
                for (Path plugin : stream) {
                    pluginsAndModules.add(plugin);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (stream != null) {
                    if (throwable != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        stream.close();
                    }
                }
            }
        }
        if (Files.exists(environment.modulesFile(), new LinkOption[0])) {
            stream = Files.newDirectoryStream(environment.modulesFile());
            throwable = null;
            try {
                for (Path plugin : stream) {
                    pluginsAndModules.add(plugin);
                }
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (stream != null) {
                    if (throwable != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        stream.close();
                    }
                }
            }
        }
        for (Path plugin : pluginsAndModules) {
            Path policyFile = plugin.resolve("plugin-security.policy");
            if (!Files.exists(policyFile, new LinkOption[0])) continue;
            ArrayList<URL> codebases = new ArrayList<URL>();
            DirectoryStream<Path> jarStream = Files.newDirectoryStream(plugin, "*.jar");
            Object object = null;
            try {
                for (Path jar : jarStream) {
                    codebases.add(jar.toRealPath(new LinkOption[0]).toUri().toURL());
                }
            }
            catch (Throwable throwable6) {
                object = throwable6;
                throw throwable6;
            }
            finally {
                if (jarStream != null) {
                    if (object != null) {
                        try {
                            jarStream.close();
                        }
                        catch (Throwable throwable7) {
                            ((Throwable)object).addSuppressed(throwable7);
                        }
                    } else {
                        jarStream.close();
                    }
                }
            }
            Policy policy = Security.readPolicy(policyFile.toUri().toURL(), codebases.toArray(new URL[codebases.size()]));
            for (URL url : codebases) {
                if (map.put(url.getFile(), policy) == null) continue;
                throw new IllegalStateException("per-plugin permissions already granted for jar file: " + url);
            }
        }
        return Collections.unmodifiableMap(map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressForbidden(reason="accesses fully qualified URLs to configure security")
    static Policy readPolicy(URL policyFile, URL[] codebases) {
        Policy policy;
        try {
            for (URL url : codebases) {
                String shortName = PathUtils.get(url.toURI()).getFileName().toString();
                System.setProperty("codebase." + shortName, url.toString());
            }
            policy = Policy.getInstance("JavaPolicy", new URIParameter(policyFile.toURI()));
        }
        catch (Throwable throwable) {
            try {
                for (URL url : codebases) {
                    String shortName = PathUtils.get(url.toURI()).getFileName().toString();
                    System.clearProperty("codebase." + shortName);
                }
                throw throwable;
            }
            catch (URISyntaxException | NoSuchAlgorithmException exception) {
                throw new IllegalArgumentException("unable to parse policy file `" + policyFile + "`", exception);
            }
        }
        for (URL url : codebases) {
            String shortName = PathUtils.get(url.toURI()).getFileName().toString();
            System.clearProperty("codebase." + shortName);
        }
        return policy;
    }

    static Permissions createPermissions(Environment environment) throws IOException {
        Permissions policy = new Permissions();
        Security.addClasspathPermissions(policy);
        Security.addFilePermissions(policy, environment);
        Security.addBindPermissions(policy, environment.settings());
        return policy;
    }

    @SuppressForbidden(reason="accesses fully qualified URLs to configure security")
    static void addClasspathPermissions(Permissions policy) throws IOException {
        for (URL url : JarHell.parseClassPath()) {
            Path path;
            try {
                path = PathUtils.get(url.toURI());
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
            policy.add(new FilePermission(path.toString(), "read,readlink"));
            if (!Files.isDirectory(path, new LinkOption[0])) continue;
            policy.add(new FilePermission(path.toString() + path.getFileSystem().getSeparator() + "-", "read,readlink"));
        }
    }

    static void addFilePermissions(Permissions policy, Environment environment) {
        Security.addPath(policy, Environment.PATH_HOME_SETTING.getKey(), environment.binFile(), "read,readlink");
        Security.addPath(policy, Environment.PATH_HOME_SETTING.getKey(), environment.libFile(), "read,readlink");
        Security.addPath(policy, Environment.PATH_HOME_SETTING.getKey(), environment.modulesFile(), "read,readlink");
        Security.addPath(policy, Environment.PATH_HOME_SETTING.getKey(), environment.pluginsFile(), "read,readlink");
        Security.addPath(policy, Environment.PATH_CONF_SETTING.getKey(), environment.configFile(), "read,readlink");
        Security.addPath(policy, Environment.PATH_SCRIPTS_SETTING.getKey(), environment.scriptsFile(), "read,readlink");
        Security.addPath(policy, "java.io.tmpdir", environment.tmpFile(), "read,readlink,write,delete");
        Security.addPath(policy, Environment.PATH_LOGS_SETTING.getKey(), environment.logsFile(), "read,readlink,write,delete");
        if (environment.sharedDataFile() != null) {
            Security.addPath(policy, Environment.PATH_SHARED_DATA_SETTING.getKey(), environment.sharedDataFile(), "read,readlink,write,delete");
        }
        for (Path path : environment.dataFiles()) {
            Security.addPath(policy, Environment.PATH_DATA_SETTING.getKey(), path, "read,readlink,write,delete");
        }
        assert (Version.CURRENT.major < 6) : "cluster name is no longer used in data path";
        for (Path path : environment.dataWithClusterFiles()) {
            Security.addPathIfExists(policy, Environment.PATH_DATA_SETTING.getKey(), path, "read,readlink,write,delete");
        }
        for (Path path : environment.repoFiles()) {
            Security.addPath(policy, Environment.PATH_REPO_SETTING.getKey(), path, "read,readlink,write,delete");
        }
        if (environment.pidFile() != null) {
            policy.add(new FilePermission(environment.pidFile().toString(), "delete"));
        }
    }

    static void addBindPermissions(Permissions policy, Settings settings) throws IOException {
        String httpRange = HttpTransportSettings.SETTING_HTTP_PORT.get(settings).getPortRangeString();
        policy.add(new SocketPermission("*:" + httpRange, "listen,resolve"));
        Map<String, Settings> profiles = TransportSettings.TRANSPORT_PROFILES_SETTING.get(settings).getAsGroups();
        if (!profiles.containsKey("default")) {
            profiles = new HashMap<String, Settings>(profiles);
            profiles.put("default", Settings.EMPTY);
        }
        for (Map.Entry<String, Settings> entry : profiles.entrySet()) {
            Settings profileSettings = entry.getValue();
            String name = entry.getKey();
            String transportRange = profileSettings.get("port", TransportSettings.PORT.get(settings));
            boolean valid = "default".equals(name) || Strings.hasLength(name) && profileSettings.get("port") != null;
            if (!valid) continue;
            policy.add(new SocketPermission("*:" + transportRange, "listen,resolve"));
        }
    }

    static void addPath(Permissions policy, String configurationName, Path path, String permissions) {
        try {
            Security.ensureDirectoryExists(path);
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to access '" + configurationName + "' (" + path + ")", e);
        }
        policy.add(new FilePermission(path.toString(), permissions));
        policy.add(new FilePermission(path.toString() + path.getFileSystem().getSeparator() + "-", permissions));
    }

    static void addPathIfExists(Permissions policy, String configurationName, Path path, String permissions) {
        if (Files.isDirectory(path, new LinkOption[0])) {
            policy.add(new FilePermission(path.toString(), permissions));
            policy.add(new FilePermission(path.toString() + path.getFileSystem().getSeparator() + "-", permissions));
            try {
                path.getFileSystem().provider().checkAccess(path.toRealPath(new LinkOption[0]), AccessMode.READ);
            }
            catch (IOException e) {
                throw new IllegalStateException("Unable to access '" + configurationName + "' (" + path + ")", e);
            }
        }
    }

    static void ensureDirectoryExists(Path path) throws IOException {
        if (Files.isDirectory(path, new LinkOption[0])) {
            path.getFileSystem().provider().checkAccess(path.toRealPath(new LinkOption[0]), AccessMode.READ);
        } else {
            try {
                Files.createDirectories(path, new FileAttribute[0]);
            }
            catch (FileAlreadyExistsException e) {
                NotDirectoryException e2 = new NotDirectoryException(path.toString());
                e2.addSuppressed(e);
                throw e2;
            }
        }
    }

    @SuppressForbidden(reason="accesses jvm default tempdir as a self-test")
    static void selfTest() throws IOException {
        try {
            Path p = Files.createTempFile(null, null, new FileAttribute[0]);
            try {
                Files.delete(p);
            }
            catch (IOException iOException) {}
        }
        catch (SecurityException problem) {
            throw new SecurityException("Security misconfiguration: cannot access java.io.tmpdir", problem);
        }
    }
}

