/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster;

import java.io.IOException;
import org.elasticsearch.cluster.Diff;
import org.elasticsearch.cluster.Diffable;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public abstract class AbstractDiffable<T extends Diffable<T>>
implements Diffable<T> {
    @Override
    public Diff<T> diff(T previousState) {
        if (this.get().equals(previousState)) {
            return new CompleteDiff();
        }
        return new CompleteDiff<T>(this.get());
    }

    @Override
    public Diff<T> readDiffFrom(StreamInput in) throws IOException {
        return new CompleteDiff(this, in);
    }

    public static <T extends Diffable<T>> Diff<T> readDiffFrom(T reader, StreamInput in) throws IOException {
        return new CompleteDiff(reader, in);
    }

    public T get() {
        return (T)this;
    }

    private static class CompleteDiff<T extends Diffable<T>>
    implements Diff<T> {
        @Nullable
        private final T part;

        public CompleteDiff(T part) {
            this.part = part;
        }

        public CompleteDiff() {
            this.part = null;
        }

        public CompleteDiff(Diffable<T> reader, StreamInput in) throws IOException {
            this.part = in.readBoolean() ? (Diffable)reader.readFrom(in) : null;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            if (this.part != null) {
                out.writeBoolean(true);
                this.part.writeTo(out);
            } else {
                out.writeBoolean(false);
            }
        }

        @Override
        public T apply(T part) {
            if (this.part != null) {
                return this.part;
            }
            return part;
        }
    }
}

