/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import com.carrotsearch.hppc.cursors.ObjectCursor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.function.Function;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesClusterStateUpdateRequest;
import org.elasticsearch.cluster.AckedClusterStateUpdateTask;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ack.AckedRequest;
import org.elasticsearch.cluster.ack.ClusterStateUpdateResponse;
import org.elasticsearch.cluster.metadata.AliasAction;
import org.elasticsearch.cluster.metadata.AliasValidator;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.MappingMetaData;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.metadata.MetaDataDeleteIndexService;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.NodeServicesProvider;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.indices.cluster.IndicesClusterStateService;

public class MetaDataIndexAliasesService
extends AbstractComponent {
    private final ClusterService clusterService;
    private final IndicesService indicesService;
    private final AliasValidator aliasValidator;
    private final NodeServicesProvider nodeServicesProvider;
    private final MetaDataDeleteIndexService deleteIndexService;

    @Inject
    public MetaDataIndexAliasesService(Settings settings, ClusterService clusterService, IndicesService indicesService, AliasValidator aliasValidator, NodeServicesProvider nodeServicesProvider, MetaDataDeleteIndexService deleteIndexService) {
        super(settings);
        this.clusterService = clusterService;
        this.indicesService = indicesService;
        this.aliasValidator = aliasValidator;
        this.nodeServicesProvider = nodeServicesProvider;
        this.deleteIndexService = deleteIndexService;
    }

    public void indicesAliases(final IndicesAliasesClusterStateUpdateRequest request, ActionListener<ClusterStateUpdateResponse> listener) {
        this.clusterService.submitStateUpdateTask("index-aliases", new AckedClusterStateUpdateTask<ClusterStateUpdateResponse>(Priority.URGENT, (AckedRequest)request, listener){

            @Override
            protected ClusterStateUpdateResponse newResponse(boolean acknowledged) {
                return new ClusterStateUpdateResponse(acknowledged);
            }

            @Override
            public ClusterState execute(ClusterState currentState) {
                return MetaDataIndexAliasesService.this.innerExecute(currentState, request.actions());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ClusterState innerExecute(ClusterState currentState, Iterable<AliasAction> actions) {
        ArrayList indicesToClose = new ArrayList();
        HashMap indices = new HashMap();
        try {
            ClusterState clusterState;
            boolean changed = false;
            HashSet<Index> indicesToDelete = new HashSet<Index>();
            for (AliasAction clusterState2 : actions) {
                if (!clusterState2.removeIndex()) continue;
                IndexMetaData index = currentState.metaData().getIndices().get(clusterState2.getIndex());
                if (index == null) {
                    throw new IndexNotFoundException(clusterState2.getIndex());
                }
                indicesToDelete.add(index.getIndex());
                changed = true;
            }
            if (changed) {
                currentState = this.deleteIndexService.deleteIndices(currentState, indicesToDelete);
            }
            MetaData.Builder metadata = MetaData.builder(currentState.metaData());
            for (AliasAction action : actions) {
                if (action.removeIndex()) continue;
                IndexMetaData index = metadata.get(action.getIndex());
                if (index == null) {
                    throw new IndexNotFoundException(action.getIndex());
                }
                AliasAction.NewAliasValidator newAliasValidator = (alias, indexRouting, filter) -> {
                    Function<String, IndexMetaData> indexLookup = name -> metadata.get((String)name);
                    this.aliasValidator.validateAlias(alias, action.getIndex(), indexRouting, indexLookup);
                    if (Strings.hasLength(filter)) {
                        IndicesClusterStateService.AllocatedIndex<IndexShard> indexService = (IndexService)indices.get(index.getIndex());
                        if (indexService == null) {
                            indexService = this.indicesService.indexService(index.getIndex());
                            if (indexService == null) {
                                try {
                                    indexService = this.indicesService.createIndex(this.nodeServicesProvider, index, Collections.emptyList());
                                }
                                catch (IOException e) {
                                    throw new ElasticsearchException("Failed to create temporary index for parsing the alias", (Throwable)e, new Object[0]);
                                }
                                for (ObjectCursor cursor : index.getMappings().values()) {
                                    MappingMetaData mappingMetaData = (MappingMetaData)cursor.value;
                                    ((IndexService)indexService).mapperService().merge(mappingMetaData.type(), mappingMetaData.source(), MapperService.MergeReason.MAPPING_RECOVERY, false);
                                }
                                indicesToClose.add(index.getIndex());
                            }
                            indices.put(action.getIndex(), indexService);
                        }
                        this.aliasValidator.validateAliasFilter(alias, filter, ((IndexService)indexService).newQueryShardContext());
                    }
                };
                changed |= action.apply(newAliasValidator, metadata, index);
            }
            if (changed && !(clusterState = ClusterState.builder(currentState).metaData(metadata).build()).metaData().equalsAliases(currentState.metaData())) {
                ClusterState clusterState3 = clusterState;
                return clusterState3;
            }
            ClusterState clusterState4 = currentState;
            return clusterState4;
        }
        finally {
            for (Index index : indicesToClose) {
                this.indicesService.removeIndex(index, "created for alias processing");
            }
        }
    }
}

