/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.logging;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.logging.log4j.core.config.builder.api.ConfigurationBuilder;
import org.apache.logging.log4j.core.config.builder.api.ConfigurationBuilderFactory;
import org.apache.logging.log4j.core.config.composite.CompositeConfiguration;
import org.apache.logging.log4j.core.config.properties.PropertiesConfiguration;
import org.apache.logging.log4j.core.config.properties.PropertiesConfigurationFactory;
import org.elasticsearch.Version;
import org.elasticsearch.cli.UserException;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.common.SuppressForbidden;
import org.elasticsearch.common.logging.ESLoggerFactory;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;

public class LogConfigurator {
    public static void configureWithoutConfig(Settings settings) {
        Objects.requireNonNull(settings);
        LogConfigurator.configureStatusLogger();
        LogConfigurator.configureLoggerLevels(settings);
    }

    public static void configure(Environment environment) throws IOException, UserException {
        Objects.requireNonNull(environment);
        LogConfigurator.configure(environment.settings(), environment.configFile(), environment.logsFile());
    }

    private static void configure(Settings settings, Path configsPath, Path logsPath) throws IOException, UserException {
        Objects.requireNonNull(settings);
        Objects.requireNonNull(configsPath);
        Objects.requireNonNull(logsPath);
        LogConfigurator.setLogConfigurationSystemProperty(logsPath, settings);
        LogConfigurator.configureStatusLogger();
        LoggerContext context = (LoggerContext)LogManager.getContext((boolean)false);
        final ArrayList configurations = new ArrayList();
        final PropertiesConfigurationFactory factory = new PropertiesConfigurationFactory();
        EnumSet<FileVisitOption> options = EnumSet.of(FileVisitOption.FOLLOW_LINKS);
        Files.walkFileTree(configsPath, options, Integer.MAX_VALUE, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                if (file.getFileName().toString().equals("log4j2.properties")) {
                    configurations.add((PropertiesConfiguration)factory.getConfiguration(file.toString(), file.toUri()));
                }
                return FileVisitResult.CONTINUE;
            }
        });
        if (configurations.isEmpty()) {
            throw new UserException(78, "no log4j2.properties found; tried [" + configsPath + "] and its subdirectories");
        }
        context.start((Configuration)new CompositeConfiguration(configurations));
        LogConfigurator.warnIfOldConfigurationFilePresent(configsPath);
        LogConfigurator.configureLoggerLevels(settings);
    }

    private static void configureStatusLogger() {
        ConfigurationBuilder builder = ConfigurationBuilderFactory.newConfigurationBuilder();
        builder.setStatusLevel(Level.ERROR);
        Configurator.initialize((Configuration)((Configuration)builder.build()));
    }

    private static void configureLoggerLevels(Settings settings) {
        if (ESLoggerFactory.LOG_DEFAULT_LEVEL_SETTING.exists(settings)) {
            Level level = ESLoggerFactory.LOG_DEFAULT_LEVEL_SETTING.get(settings);
            Loggers.setLevel(ESLoggerFactory.getRootLogger(), level);
        }
        Map<String, String> levels = settings.filter(ESLoggerFactory.LOG_LEVEL_SETTING::match).getAsMap();
        for (String key : levels.keySet()) {
            Level level = ESLoggerFactory.LOG_LEVEL_SETTING.getConcreteSetting(key).get(settings);
            Loggers.setLevel(ESLoggerFactory.getLogger(key.substring("logger.".length())), level);
        }
    }

    private static void warnIfOldConfigurationFilePresent(Path configsPath) throws IOException {
        assert (Version.CURRENT.major < 6);
        final List<String> suffixes = Arrays.asList(".yml", ".yaml", ".json", ".properties");
        EnumSet<FileVisitOption> options = EnumSet.of(FileVisitOption.FOLLOW_LINKS);
        Files.walkFileTree(configsPath, options, Integer.MAX_VALUE, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                String fileName = file.getFileName().toString();
                if (fileName.startsWith("logging")) {
                    for (String suffix : suffixes) {
                        if (!fileName.endsWith(suffix)) continue;
                        Loggers.getLogger(LogConfigurator.class).warn("ignoring unsupported logging configuration file [{}], logging is configured via [{}]", (Object)file.toString(), (Object)file.getParent().resolve("log4j2.properties"));
                    }
                }
                return FileVisitResult.CONTINUE;
            }
        });
    }

    @SuppressForbidden(reason="sets system property for logging configuration")
    private static void setLogConfigurationSystemProperty(Path logsPath, Settings settings) {
        System.setProperty("es.logs", logsPath.resolve(ClusterName.CLUSTER_NAME_SETTING.get(settings).value()).toString());
    }
}

