/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.SortedSetDocValuesField;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.Version;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.plain.DocValuesIndexFieldData;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.StringFieldMapper;
import org.elasticsearch.index.mapper.StringFieldType;
import org.elasticsearch.index.mapper.TypeParsers;

public final class KeywordFieldMapper
extends FieldMapper {
    public static final String CONTENT_TYPE = "keyword";
    private static final List<String> SUPPORTED_PARAMETERS_FOR_AUTO_DOWNGRADE_TO_STRING = Collections.unmodifiableList(Arrays.asList("type", "index", "store", "doc_values", "omit_norms", "norms", "boost", "fields", "copy_to", "include_in_all", "ignore_above", "index_options", "similarity"));
    private Boolean includeInAll;
    private int ignoreAbove;

    protected KeywordFieldMapper(String simpleName, MappedFieldType fieldType, MappedFieldType defaultFieldType, int ignoreAbove, Boolean includeInAll, Settings indexSettings, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo) {
        super(simpleName, fieldType, defaultFieldType, indexSettings, multiFields, copyTo);
        assert (fieldType.indexOptions().compareTo((Enum)IndexOptions.DOCS_AND_FREQS) <= 0);
        this.ignoreAbove = ignoreAbove;
        this.includeInAll = includeInAll;
    }

    int ignoreAbove() {
        return this.ignoreAbove;
    }

    @Override
    protected KeywordFieldMapper clone() {
        return (KeywordFieldMapper)super.clone();
    }

    Boolean includeInAll() {
        return this.includeInAll;
    }

    @Override
    protected void parseCreateField(ParseContext context, List<Field> fields) throws IOException {
        XContentParser parser;
        String value = context.externalValueSet() ? context.externalValue().toString() : ((parser = context.parser()).currentToken() == XContentParser.Token.VALUE_NULL ? this.fieldType().nullValueAsString() : parser.textOrNull());
        if (value == null || value.length() > this.ignoreAbove) {
            return;
        }
        if (context.includeInAll(this.includeInAll, this)) {
            context.allEntries().addText(this.fieldType().name(), value, this.fieldType().boost());
        }
        BytesRef binaryValue = new BytesRef((CharSequence)value);
        if (this.fieldType().indexOptions() != IndexOptions.NONE || this.fieldType().stored()) {
            Field field = new Field(this.fieldType().name(), binaryValue, (FieldType)this.fieldType());
            fields.add(field);
        }
        if (this.fieldType().hasDocValues()) {
            fields.add((Field)new SortedSetDocValuesField(this.fieldType().name(), binaryValue));
        }
    }

    @Override
    protected String contentType() {
        return CONTENT_TYPE;
    }

    @Override
    protected void doMerge(Mapper mergeWith, boolean updateAllTypes) {
        super.doMerge(mergeWith, updateAllTypes);
        this.includeInAll = ((KeywordFieldMapper)mergeWith).includeInAll;
        this.ignoreAbove = ((KeywordFieldMapper)mergeWith).ignoreAbove;
    }

    @Override
    protected void doXContentBody(XContentBuilder builder, boolean includeDefaults, ToXContent.Params params) throws IOException {
        super.doXContentBody(builder, includeDefaults, params);
        if (includeDefaults || this.fieldType().nullValue() != null) {
            builder.field("null_value", this.fieldType().nullValue());
        }
        if (this.includeInAll != null) {
            builder.field("include_in_all", this.includeInAll);
        } else if (includeDefaults) {
            builder.field("include_in_all", true);
        }
        if (includeDefaults || this.ignoreAbove != Integer.MAX_VALUE) {
            builder.field("ignore_above", this.ignoreAbove);
        }
    }

    public static final class KeywordFieldType
    extends StringFieldType {
        public KeywordFieldType() {
        }

        protected KeywordFieldType(KeywordFieldType ref) {
            super(ref);
        }

        @Override
        public KeywordFieldType clone() {
            return new KeywordFieldType(this);
        }

        @Override
        public String typeName() {
            return KeywordFieldMapper.CONTENT_TYPE;
        }

        @Override
        public Query nullValueQuery() {
            if (this.nullValue() == null) {
                return null;
            }
            return this.termQuery(this.nullValue(), null);
        }

        @Override
        public IndexFieldData.Builder fielddataBuilder() {
            this.failIfNoDocValues();
            return new DocValuesIndexFieldData.Builder();
        }

        @Override
        public Object valueForSearch(Object value) {
            if (value == null) {
                return null;
            }
            BytesRef binaryValue = (BytesRef)value;
            return binaryValue.utf8ToString();
        }
    }

    public static class TypeParser
    implements Mapper.TypeParser {
        public Mapper.Builder parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            if (parserContext.indexVersionCreated().before(Version.V_5_0_0_alpha1)) {
                HashSet<String> unsupportedParameters = new HashSet<String>(node.keySet());
                unsupportedParameters.removeAll(SUPPORTED_PARAMETERS_FOR_AUTO_DOWNGRADE_TO_STRING);
                if (!SUPPORTED_PARAMETERS_FOR_AUTO_DOWNGRADE_TO_STRING.containsAll(node.keySet())) {
                    throw new IllegalArgumentException("Automatic downgrade from [keyword] to [string] failed because parameters " + unsupportedParameters + " are not supported for automatic downgrades.");
                }
                Object index = node.get("index");
                if (index == null || Boolean.TRUE.equals(index)) {
                    index = "not_analyzed";
                } else if (Boolean.FALSE.equals(index)) {
                    index = "no";
                } else {
                    throw new IllegalArgumentException("Can't parse [index] value [" + index + "] for field [" + name + "], expected [true] or [false]");
                }
                node.put("index", index);
                return new StringFieldMapper.TypeParser().parse(name, node, parserContext);
            }
            Builder builder = new Builder(name);
            TypeParsers.parseField(builder, name, node, parserContext);
            Iterator<Map.Entry<String, Object>> iterator = node.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Object> entry = iterator.next();
                String propName = entry.getKey();
                Object propNode = entry.getValue();
                if (propName.equals("null_value")) {
                    if (propNode == null) {
                        throw new MapperParsingException("Property [null_value] cannot be null.");
                    }
                    builder.nullValue(propNode.toString());
                    iterator.remove();
                    continue;
                }
                if (propName.equals("ignore_above")) {
                    builder.ignoreAbove(XContentMapValues.nodeIntegerValue(propNode, -1));
                    iterator.remove();
                    continue;
                }
                if (propName.equals("norms")) {
                    builder.omitNorms(!XContentMapValues.nodeBooleanValue(propNode));
                    iterator.remove();
                    continue;
                }
                if (!propName.equals("eager_global_ordinals")) continue;
                builder.eagerGlobalOrdinals(XContentMapValues.nodeBooleanValue(propNode));
                iterator.remove();
            }
            return builder;
        }
    }

    public static class Builder
    extends FieldMapper.Builder<Builder, KeywordFieldMapper> {
        protected String nullValue = Defaults.NULL_VALUE;
        protected int ignoreAbove = Integer.MAX_VALUE;

        public Builder(String name) {
            super(name, Defaults.FIELD_TYPE, Defaults.FIELD_TYPE);
            this.builder = this;
        }

        public Builder ignoreAbove(int ignoreAbove) {
            if (ignoreAbove < 0) {
                throw new IllegalArgumentException("[ignore_above] must be positive, got " + ignoreAbove);
            }
            this.ignoreAbove = ignoreAbove;
            return this;
        }

        @Override
        public Builder indexOptions(IndexOptions indexOptions) {
            if (indexOptions.compareTo((Enum)IndexOptions.DOCS_AND_FREQS) > 0) {
                throw new IllegalArgumentException("The [keyword] field does not support positions, got [index_options]=" + FieldMapper.indexOptionToString(indexOptions));
            }
            return (Builder)super.indexOptions(indexOptions);
        }

        public Builder eagerGlobalOrdinals(boolean eagerGlobalOrdinals) {
            this.fieldType().setEagerGlobalOrdinals(eagerGlobalOrdinals);
            return (Builder)this.builder;
        }

        @Override
        public KeywordFieldMapper build(Mapper.BuilderContext context) {
            this.setupFieldType(context);
            return new KeywordFieldMapper(this.name, this.fieldType, this.defaultFieldType, this.ignoreAbove, this.includeInAll, context.indexSettings(), this.multiFieldsBuilder.build(this, context), this.copyTo);
        }
    }

    public static class Defaults {
        public static final MappedFieldType FIELD_TYPE = new KeywordFieldType();
        public static final String NULL_VALUE;
        public static final int IGNORE_ABOVE = Integer.MAX_VALUE;

        static {
            FIELD_TYPE.setTokenized(false);
            FIELD_TYPE.setOmitNorms(true);
            FIELD_TYPE.setIndexOptions(IndexOptions.DOCS);
            FIELD_TYPE.freeze();
            NULL_VALUE = null;
        }
    }
}

