/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.script.NativeScriptEngineService;
import org.elasticsearch.script.ScriptContext;
import org.elasticsearch.script.ScriptContextRegistry;
import org.elasticsearch.script.ScriptEngineRegistry;
import org.elasticsearch.script.ScriptEngineService;
import org.elasticsearch.script.ScriptModes;
import org.elasticsearch.script.ScriptService;

public class ScriptSettings {
    static final String LEGACY_DEFAULT_LANG = "groovy";
    @Deprecated
    public static final String LEGACY_SCRIPT_SETTING = "script.legacy.default_lang";
    private static final Map<ScriptService.ScriptType, Setting<Boolean>> SCRIPT_TYPE_SETTING_MAP;
    private final Map<ScriptContext, Setting<Boolean>> scriptContextSettingMap;
    private final List<Setting<Boolean>> scriptLanguageSettings;
    private final Setting<String> defaultLegacyScriptLanguageSetting;

    public ScriptSettings(ScriptEngineRegistry scriptEngineRegistry, ScriptContextRegistry scriptContextRegistry) {
        Map<ScriptContext, Setting<Boolean>> scriptContextSettingMap = ScriptSettings.contextSettings(scriptContextRegistry);
        this.scriptContextSettingMap = Collections.unmodifiableMap(scriptContextSettingMap);
        List<Setting<Boolean>> scriptLanguageSettings = ScriptSettings.languageSettings(SCRIPT_TYPE_SETTING_MAP, scriptContextSettingMap, scriptEngineRegistry, scriptContextRegistry);
        this.scriptLanguageSettings = Collections.unmodifiableList(scriptLanguageSettings);
        this.defaultLegacyScriptLanguageSetting = new Setting<String>(LEGACY_SCRIPT_SETTING, LEGACY_DEFAULT_LANG, setting -> {
            if (!LEGACY_DEFAULT_LANG.equals(setting) && !scriptEngineRegistry.getRegisteredLanguages().containsKey(setting)) {
                throw new IllegalArgumentException("unregistered default language [" + setting + "]");
            }
            return setting;
        }, Setting.Property.NodeScope);
    }

    private static Map<ScriptContext, Setting<Boolean>> contextSettings(ScriptContextRegistry scriptContextRegistry) {
        HashMap<ScriptContext, Setting<Boolean>> scriptContextSettingMap = new HashMap<ScriptContext, Setting<Boolean>>();
        for (ScriptContext scriptContext : scriptContextRegistry.scriptContexts()) {
            scriptContextSettingMap.put(scriptContext, Setting.boolSetting(ScriptModes.operationKey(scriptContext), false, Setting.Property.NodeScope));
        }
        return scriptContextSettingMap;
    }

    private static List<Setting<Boolean>> languageSettings(Map<ScriptService.ScriptType, Setting<Boolean>> scriptTypeSettingMap, Map<ScriptContext, Setting<Boolean>> scriptContextSettingMap, ScriptEngineRegistry scriptEngineRegistry, ScriptContextRegistry scriptContextRegistry) {
        ArrayList<Setting<Boolean>> scriptModeSettings = new ArrayList<Setting<Boolean>>();
        for (Class<? extends ScriptEngineService> scriptEngineService : scriptEngineRegistry.getRegisteredScriptEngineServices()) {
            if (scriptEngineService == NativeScriptEngineService.class) continue;
            String language = scriptEngineRegistry.getLanguage(scriptEngineService);
            for (ScriptService.ScriptType scriptType : ScriptService.ScriptType.values()) {
                boolean defaultNonFileScriptMode;
                boolean defaultLangAndType = defaultNonFileScriptMode = scriptEngineRegistry.getDefaultInlineScriptEnableds().get(language).booleanValue();
                if (ScriptService.ScriptType.FILE == scriptType) {
                    defaultLangAndType = ScriptService.ScriptType.FILE.getDefaultScriptEnabled();
                }
                boolean defaultIfNothingSet = defaultLangAndType;
                Function<Settings, String> defaultLangAndTypeFn = settings -> {
                    Setting globalTypeSetting = (Setting)scriptTypeSettingMap.get((Object)scriptType);
                    Setting<Boolean> langAndTypeSetting = Setting.boolSetting(ScriptModes.getGlobalKey(language, scriptType), defaultIfNothingSet, Setting.Property.NodeScope);
                    if (langAndTypeSetting.exists((Settings)settings)) {
                        return langAndTypeSetting.get((Settings)settings).toString();
                    }
                    if (globalTypeSetting.exists((Settings)settings)) {
                        return ((Boolean)globalTypeSetting.get((Settings)settings)).toString();
                    }
                    return Boolean.toString(defaultIfNothingSet);
                };
                Setting<Boolean> langAndTypeSetting = Setting.boolSetting(ScriptModes.getGlobalKey(language, scriptType), defaultLangAndTypeFn, Setting.Property.NodeScope);
                scriptModeSettings.add(langAndTypeSetting);
                for (ScriptContext scriptContext : scriptContextRegistry.scriptContexts()) {
                    String langAndTypeAndContextName = ScriptModes.getKey(language, scriptType, scriptContext);
                    Function<Settings, String> defaultSettingFn = settings -> {
                        Setting globalOpSetting = (Setting)scriptContextSettingMap.get(scriptContext);
                        Setting globalTypeSetting = (Setting)scriptTypeSettingMap.get((Object)scriptType);
                        Setting<Boolean> langAndTypeAndContextSetting = Setting.boolSetting(langAndTypeAndContextName, defaultIfNothingSet, Setting.Property.NodeScope);
                        if (langAndTypeAndContextSetting.exists((Settings)settings)) {
                            return langAndTypeAndContextSetting.get((Settings)settings).toString();
                        }
                        if (langAndTypeSetting.exists((Settings)settings)) {
                            return ((Boolean)langAndTypeSetting.get((Settings)settings)).toString();
                        }
                        if (globalOpSetting.exists((Settings)settings)) {
                            return ((Boolean)globalOpSetting.get((Settings)settings)).toString();
                        }
                        if (globalTypeSetting.exists((Settings)settings)) {
                            return ((Boolean)globalTypeSetting.get((Settings)settings)).toString();
                        }
                        return Boolean.toString(defaultIfNothingSet);
                    };
                    Setting<Boolean> setting = Setting.boolSetting(langAndTypeAndContextName, defaultSettingFn, Setting.Property.NodeScope);
                    scriptModeSettings.add(setting);
                }
            }
        }
        return scriptModeSettings;
    }

    public List<Setting<?>> getSettings() {
        ArrayList settings = new ArrayList();
        settings.addAll(SCRIPT_TYPE_SETTING_MAP.values());
        settings.addAll(this.scriptContextSettingMap.values());
        settings.addAll(this.scriptLanguageSettings);
        settings.add(this.defaultLegacyScriptLanguageSetting);
        return settings;
    }

    public Iterable<Setting<Boolean>> getScriptLanguageSettings() {
        return this.scriptLanguageSettings;
    }

    public Setting<String> getDefaultLegacyScriptLanguageSetting() {
        return this.defaultLegacyScriptLanguageSetting;
    }

    public static String getLegacyDefaultLang(Settings settings) {
        return settings.get(LEGACY_SCRIPT_SETTING, LEGACY_DEFAULT_LANG);
    }

    static {
        HashMap<ScriptService.ScriptType, Setting<Boolean>> scriptTypeSettingMap = new HashMap<ScriptService.ScriptType, Setting<Boolean>>();
        for (ScriptService.ScriptType scriptType : ScriptService.ScriptType.values()) {
            scriptTypeSettingMap.put(scriptType, Setting.boolSetting(ScriptModes.sourceKey(scriptType), scriptType.getDefaultScriptEnabled(), Setting.Property.NodeScope));
        }
        SCRIPT_TYPE_SETTING_MAP = Collections.unmodifiableMap(scriptTypeSettingMap);
    }
}

