/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless.node;

import java.util.Objects;
import java.util.Set;
import org.elasticsearch.painless.AnalyzerCaster;
import org.elasticsearch.painless.Definition;
import org.elasticsearch.painless.Globals;
import org.elasticsearch.painless.Locals;
import org.elasticsearch.painless.Location;
import org.elasticsearch.painless.MethodWriter;
import org.elasticsearch.painless.Operation;
import org.elasticsearch.painless.WriterConstants;
import org.elasticsearch.painless.node.AExpression;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;

public final class EComp
extends AExpression {
    private final Operation operation;
    private AExpression left;
    private AExpression right;
    private Definition.Type promotedType;

    public EComp(Location location, Operation operation, AExpression left, AExpression right) {
        super(location);
        this.operation = Objects.requireNonNull(operation);
        this.left = Objects.requireNonNull(left);
        this.right = Objects.requireNonNull(right);
    }

    @Override
    void extractVariables(Set<String> variables) {
        this.left.extractVariables(variables);
        this.right.extractVariables(variables);
    }

    @Override
    void analyze(Locals locals) {
        if (this.operation == Operation.EQ) {
            this.analyzeEq(locals);
        } else if (this.operation == Operation.EQR) {
            this.analyzeEqR(locals);
        } else if (this.operation == Operation.NE) {
            this.analyzeNE(locals);
        } else if (this.operation == Operation.NER) {
            this.analyzeNER(locals);
        } else if (this.operation == Operation.GTE) {
            this.analyzeGTE(locals);
        } else if (this.operation == Operation.GT) {
            this.analyzeGT(locals);
        } else if (this.operation == Operation.LTE) {
            this.analyzeLTE(locals);
        } else if (this.operation == Operation.LT) {
            this.analyzeLT(locals);
        } else {
            throw this.createError(new IllegalStateException("Illegal tree structure."));
        }
    }

    private void analyzeEq(Locals variables) {
        this.left.analyze(variables);
        this.right.analyze(variables);
        this.promotedType = AnalyzerCaster.promoteEquality(this.left.actual, this.right.actual);
        if (this.promotedType == null) {
            throw this.createError(new ClassCastException("Cannot apply equals [==] to types [" + this.left.actual.name + "] and [" + this.right.actual.name + "]."));
        }
        if (this.promotedType.sort == Definition.Sort.DEF) {
            this.left.expected = this.left.actual;
            this.right.expected = this.right.actual;
        } else {
            this.left.expected = this.promotedType;
            this.right.expected = this.promotedType;
        }
        this.left = this.left.cast(variables);
        this.right = this.right.cast(variables);
        if (this.left.isNull && this.right.isNull) {
            throw this.createError(new IllegalArgumentException("Extraneous comparison of null constants."));
        }
        if ((this.left.constant != null || this.left.isNull) && (this.right.constant != null || this.right.isNull)) {
            Definition.Sort sort = this.promotedType.sort;
            if (sort == Definition.Sort.BOOL) {
                this.constant = ((Boolean)this.left.constant).booleanValue() == ((Boolean)this.right.constant).booleanValue();
            } else if (sort == Definition.Sort.INT) {
                this.constant = ((Integer)this.left.constant).intValue() == ((Integer)this.right.constant).intValue();
            } else if (sort == Definition.Sort.LONG) {
                this.constant = ((Long)this.left.constant).longValue() == ((Long)this.right.constant).longValue();
            } else if (sort == Definition.Sort.FLOAT) {
                this.constant = ((Float)this.left.constant).floatValue() == ((Float)this.right.constant).floatValue();
            } else if (sort == Definition.Sort.DOUBLE) {
                this.constant = ((Double)this.left.constant).doubleValue() == ((Double)this.right.constant).doubleValue();
            } else if (!this.left.isNull) {
                this.constant = this.left.constant.equals(this.right.constant);
            } else if (!this.right.isNull) {
                this.constant = this.right.constant.equals(null);
            } else {
                throw this.createError(new IllegalStateException("Illegal tree structure."));
            }
        }
        this.actual = Definition.BOOLEAN_TYPE;
    }

    private void analyzeEqR(Locals variables) {
        this.left.analyze(variables);
        this.right.analyze(variables);
        this.promotedType = AnalyzerCaster.promoteEquality(this.left.actual, this.right.actual);
        if (this.promotedType == null) {
            throw this.createError(new ClassCastException("Cannot apply reference equals [===] to types [" + this.left.actual.name + "] and [" + this.right.actual.name + "]."));
        }
        if (this.promotedType.sort == Definition.Sort.DEF) {
            this.left.expected = this.left.actual;
            this.right.expected = this.right.actual;
        } else {
            this.left.expected = this.promotedType;
            this.right.expected = this.promotedType;
        }
        this.left = this.left.cast(variables);
        this.right = this.right.cast(variables);
        if (this.left.isNull && this.right.isNull) {
            throw this.createError(new IllegalArgumentException("Extraneous comparison of null constants."));
        }
        if ((this.left.constant != null || this.left.isNull) && (this.right.constant != null || this.right.isNull)) {
            Definition.Sort sort = this.promotedType.sort;
            this.constant = sort == Definition.Sort.BOOL ? Boolean.valueOf(((Boolean)this.left.constant).booleanValue() == ((Boolean)this.right.constant).booleanValue()) : (sort == Definition.Sort.INT ? Boolean.valueOf(((Integer)this.left.constant).intValue() == ((Integer)this.right.constant).intValue()) : (sort == Definition.Sort.LONG ? Boolean.valueOf(((Long)this.left.constant).longValue() == ((Long)this.right.constant).longValue()) : (sort == Definition.Sort.FLOAT ? Boolean.valueOf(((Float)this.left.constant).floatValue() == ((Float)this.right.constant).floatValue()) : (sort == Definition.Sort.DOUBLE ? Boolean.valueOf(((Double)this.left.constant).doubleValue() == ((Double)this.right.constant).doubleValue()) : Boolean.valueOf(this.left.constant == this.right.constant)))));
        }
        this.actual = Definition.BOOLEAN_TYPE;
    }

    private void analyzeNE(Locals variables) {
        this.left.analyze(variables);
        this.right.analyze(variables);
        this.promotedType = AnalyzerCaster.promoteEquality(this.left.actual, this.right.actual);
        if (this.promotedType == null) {
            throw this.createError(new ClassCastException("Cannot apply not equals [!=] to types [" + this.left.actual.name + "] and [" + this.right.actual.name + "]."));
        }
        if (this.promotedType.sort == Definition.Sort.DEF) {
            this.left.expected = this.left.actual;
            this.right.expected = this.right.actual;
        } else {
            this.left.expected = this.promotedType;
            this.right.expected = this.promotedType;
        }
        this.left = this.left.cast(variables);
        this.right = this.right.cast(variables);
        if (this.left.isNull && this.right.isNull) {
            throw this.createError(new IllegalArgumentException("Extraneous comparison of null constants."));
        }
        if ((this.left.constant != null || this.left.isNull) && (this.right.constant != null || this.right.isNull)) {
            Definition.Sort sort = this.promotedType.sort;
            if (sort == Definition.Sort.BOOL) {
                this.constant = ((Boolean)this.left.constant).booleanValue() != ((Boolean)this.right.constant).booleanValue();
            } else if (sort == Definition.Sort.INT) {
                this.constant = ((Integer)this.left.constant).intValue() != ((Integer)this.right.constant).intValue();
            } else if (sort == Definition.Sort.LONG) {
                this.constant = ((Long)this.left.constant).longValue() != ((Long)this.right.constant).longValue();
            } else if (sort == Definition.Sort.FLOAT) {
                this.constant = ((Float)this.left.constant).floatValue() != ((Float)this.right.constant).floatValue();
            } else if (sort == Definition.Sort.DOUBLE) {
                this.constant = ((Double)this.left.constant).doubleValue() != ((Double)this.right.constant).doubleValue();
            } else if (!this.left.isNull) {
                this.constant = !this.left.constant.equals(this.right.constant);
            } else if (!this.right.isNull) {
                this.constant = !this.right.constant.equals(null);
            } else {
                throw this.createError(new IllegalStateException("Illegal tree structure."));
            }
        }
        this.actual = Definition.BOOLEAN_TYPE;
    }

    private void analyzeNER(Locals variables) {
        this.left.analyze(variables);
        this.right.analyze(variables);
        this.promotedType = AnalyzerCaster.promoteEquality(this.left.actual, this.right.actual);
        if (this.promotedType == null) {
            throw this.createError(new ClassCastException("Cannot apply reference not equals [!==] to types [" + this.left.actual.name + "] and [" + this.right.actual.name + "]."));
        }
        if (this.promotedType.sort == Definition.Sort.DEF) {
            this.left.expected = this.left.actual;
            this.right.expected = this.right.actual;
        } else {
            this.left.expected = this.promotedType;
            this.right.expected = this.promotedType;
        }
        this.left = this.left.cast(variables);
        this.right = this.right.cast(variables);
        if (this.left.isNull && this.right.isNull) {
            throw this.createError(new IllegalArgumentException("Extraneous comparison of null constants."));
        }
        if ((this.left.constant != null || this.left.isNull) && (this.right.constant != null || this.right.isNull)) {
            Definition.Sort sort = this.promotedType.sort;
            this.constant = sort == Definition.Sort.BOOL ? Boolean.valueOf(((Boolean)this.left.constant).booleanValue() != ((Boolean)this.right.constant).booleanValue()) : (sort == Definition.Sort.INT ? Boolean.valueOf(((Integer)this.left.constant).intValue() != ((Integer)this.right.constant).intValue()) : (sort == Definition.Sort.LONG ? Boolean.valueOf(((Long)this.left.constant).longValue() != ((Long)this.right.constant).longValue()) : (sort == Definition.Sort.FLOAT ? Boolean.valueOf(((Float)this.left.constant).floatValue() != ((Float)this.right.constant).floatValue()) : (sort == Definition.Sort.DOUBLE ? Boolean.valueOf(((Double)this.left.constant).doubleValue() != ((Double)this.right.constant).doubleValue()) : Boolean.valueOf(this.left.constant != this.right.constant)))));
        }
        this.actual = Definition.BOOLEAN_TYPE;
    }

    private void analyzeGTE(Locals variables) {
        this.left.analyze(variables);
        this.right.analyze(variables);
        this.promotedType = AnalyzerCaster.promoteNumeric(this.left.actual, this.right.actual, true);
        if (this.promotedType == null) {
            throw this.createError(new ClassCastException("Cannot apply greater than or equals [>=] to types [" + this.left.actual.name + "] and [" + this.right.actual.name + "]."));
        }
        if (this.promotedType.sort == Definition.Sort.DEF) {
            this.left.expected = this.left.actual;
            this.right.expected = this.right.actual;
        } else {
            this.left.expected = this.promotedType;
            this.right.expected = this.promotedType;
        }
        this.left = this.left.cast(variables);
        this.right = this.right.cast(variables);
        if (this.left.constant != null && this.right.constant != null) {
            Definition.Sort sort = this.promotedType.sort;
            if (sort == Definition.Sort.INT) {
                this.constant = (Integer)this.left.constant >= (Integer)this.right.constant;
            } else if (sort == Definition.Sort.LONG) {
                this.constant = (Long)this.left.constant >= (Long)this.right.constant;
            } else if (sort == Definition.Sort.FLOAT) {
                this.constant = ((Float)this.left.constant).floatValue() >= ((Float)this.right.constant).floatValue();
            } else if (sort == Definition.Sort.DOUBLE) {
                this.constant = (Double)this.left.constant >= (Double)this.right.constant;
            } else {
                throw this.createError(new IllegalStateException("Illegal tree structure."));
            }
        }
        this.actual = Definition.BOOLEAN_TYPE;
    }

    private void analyzeGT(Locals variables) {
        this.left.analyze(variables);
        this.right.analyze(variables);
        this.promotedType = AnalyzerCaster.promoteNumeric(this.left.actual, this.right.actual, true);
        if (this.promotedType == null) {
            throw this.createError(new ClassCastException("Cannot apply greater than [>] to types [" + this.left.actual.name + "] and [" + this.right.actual.name + "]."));
        }
        if (this.promotedType.sort == Definition.Sort.DEF) {
            this.left.expected = this.left.actual;
            this.right.expected = this.right.actual;
        } else {
            this.left.expected = this.promotedType;
            this.right.expected = this.promotedType;
        }
        this.left = this.left.cast(variables);
        this.right = this.right.cast(variables);
        if (this.left.constant != null && this.right.constant != null) {
            Definition.Sort sort = this.promotedType.sort;
            if (sort == Definition.Sort.INT) {
                this.constant = (Integer)this.left.constant > (Integer)this.right.constant;
            } else if (sort == Definition.Sort.LONG) {
                this.constant = (Long)this.left.constant > (Long)this.right.constant;
            } else if (sort == Definition.Sort.FLOAT) {
                this.constant = ((Float)this.left.constant).floatValue() > ((Float)this.right.constant).floatValue();
            } else if (sort == Definition.Sort.DOUBLE) {
                this.constant = (Double)this.left.constant > (Double)this.right.constant;
            } else {
                throw this.createError(new IllegalStateException("Illegal tree structure."));
            }
        }
        this.actual = Definition.BOOLEAN_TYPE;
    }

    private void analyzeLTE(Locals variables) {
        this.left.analyze(variables);
        this.right.analyze(variables);
        this.promotedType = AnalyzerCaster.promoteNumeric(this.left.actual, this.right.actual, true);
        if (this.promotedType == null) {
            throw this.createError(new ClassCastException("Cannot apply less than or equals [<=] to types [" + this.left.actual.name + "] and [" + this.right.actual.name + "]."));
        }
        if (this.promotedType.sort == Definition.Sort.DEF) {
            this.left.expected = this.left.actual;
            this.right.expected = this.right.actual;
        } else {
            this.left.expected = this.promotedType;
            this.right.expected = this.promotedType;
        }
        this.left = this.left.cast(variables);
        this.right = this.right.cast(variables);
        if (this.left.constant != null && this.right.constant != null) {
            Definition.Sort sort = this.promotedType.sort;
            if (sort == Definition.Sort.INT) {
                this.constant = (Integer)this.left.constant <= (Integer)this.right.constant;
            } else if (sort == Definition.Sort.LONG) {
                this.constant = (Long)this.left.constant <= (Long)this.right.constant;
            } else if (sort == Definition.Sort.FLOAT) {
                this.constant = ((Float)this.left.constant).floatValue() <= ((Float)this.right.constant).floatValue();
            } else if (sort == Definition.Sort.DOUBLE) {
                this.constant = (Double)this.left.constant <= (Double)this.right.constant;
            } else {
                throw this.createError(new IllegalStateException("Illegal tree structure."));
            }
        }
        this.actual = Definition.BOOLEAN_TYPE;
    }

    private void analyzeLT(Locals variables) {
        this.left.analyze(variables);
        this.right.analyze(variables);
        this.promotedType = AnalyzerCaster.promoteNumeric(this.left.actual, this.right.actual, true);
        if (this.promotedType == null) {
            throw this.createError(new ClassCastException("Cannot apply less than [>=] to types [" + this.left.actual.name + "] and [" + this.right.actual.name + "]."));
        }
        if (this.promotedType.sort == Definition.Sort.DEF) {
            this.left.expected = this.left.actual;
            this.right.expected = this.right.actual;
        } else {
            this.left.expected = this.promotedType;
            this.right.expected = this.promotedType;
        }
        this.left = this.left.cast(variables);
        this.right = this.right.cast(variables);
        if (this.left.constant != null && this.right.constant != null) {
            Definition.Sort sort = this.promotedType.sort;
            if (sort == Definition.Sort.INT) {
                this.constant = (Integer)this.left.constant < (Integer)this.right.constant;
            } else if (sort == Definition.Sort.LONG) {
                this.constant = (Long)this.left.constant < (Long)this.right.constant;
            } else if (sort == Definition.Sort.FLOAT) {
                this.constant = ((Float)this.left.constant).floatValue() < ((Float)this.right.constant).floatValue();
            } else if (sort == Definition.Sort.DOUBLE) {
                this.constant = (Double)this.left.constant < (Double)this.right.constant;
            } else {
                throw this.createError(new IllegalStateException("Illegal tree structure."));
            }
        }
        this.actual = Definition.BOOLEAN_TYPE;
    }

    @Override
    void write(MethodWriter writer, Globals globals) {
        writer.writeDebugInfo(this.location);
        this.left.write(writer, globals);
        if (!this.right.isNull) {
            this.right.write(writer, globals);
        }
        Label jump = new Label();
        Label end = new Label();
        boolean eq = this.operation == Operation.EQ || this.operation == Operation.EQR;
        boolean ne = this.operation == Operation.NE || this.operation == Operation.NER;
        boolean lt = this.operation == Operation.LT;
        boolean lte = this.operation == Operation.LTE;
        boolean gt = this.operation == Operation.GT;
        boolean gte = this.operation == Operation.GTE;
        boolean writejump = true;
        switch (this.promotedType.sort) {
            case VOID: 
            case BYTE: 
            case SHORT: 
            case CHAR: {
                throw this.createError(new IllegalStateException("Illegal tree structure."));
            }
            case BOOL: {
                if (eq) {
                    writer.ifCmp(this.promotedType.type, 153, jump);
                    break;
                }
                if (ne) {
                    writer.ifCmp(this.promotedType.type, 154, jump);
                    break;
                }
                throw this.createError(new IllegalStateException("Illegal tree structure."));
            }
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: {
                if (eq) {
                    writer.ifCmp(this.promotedType.type, 153, jump);
                    break;
                }
                if (ne) {
                    writer.ifCmp(this.promotedType.type, 154, jump);
                    break;
                }
                if (lt) {
                    writer.ifCmp(this.promotedType.type, 155, jump);
                    break;
                }
                if (lte) {
                    writer.ifCmp(this.promotedType.type, 158, jump);
                    break;
                }
                if (gt) {
                    writer.ifCmp(this.promotedType.type, 157, jump);
                    break;
                }
                if (gte) {
                    writer.ifCmp(this.promotedType.type, 156, jump);
                    break;
                }
                throw this.createError(new IllegalStateException("Illegal tree structure."));
            }
            case DEF: {
                Type booleanType = Type.getType(Boolean.TYPE);
                Type descriptor = Type.getMethodType((Type)booleanType, (Type[])new Type[]{this.left.actual.type, this.right.actual.type});
                if (eq) {
                    if (this.right.isNull) {
                        writer.ifNull(jump);
                        break;
                    }
                    if (!this.left.isNull && this.operation == Operation.EQ) {
                        writer.invokeDefCall("eq", descriptor, 8, 1);
                        writejump = false;
                        break;
                    }
                    writer.ifCmp(this.promotedType.type, 153, jump);
                    break;
                }
                if (ne) {
                    if (this.right.isNull) {
                        writer.ifNonNull(jump);
                        break;
                    }
                    if (!this.left.isNull && this.operation == Operation.NE) {
                        writer.invokeDefCall("eq", descriptor, 8, 1);
                        writer.ifZCmp(153, jump);
                        break;
                    }
                    writer.ifCmp(this.promotedType.type, 154, jump);
                    break;
                }
                if (lt) {
                    writer.invokeDefCall("lt", descriptor, 8, 0);
                    writejump = false;
                    break;
                }
                if (lte) {
                    writer.invokeDefCall("lte", descriptor, 8, 0);
                    writejump = false;
                    break;
                }
                if (gt) {
                    writer.invokeDefCall("gt", descriptor, 8, 0);
                    writejump = false;
                    break;
                }
                if (gte) {
                    writer.invokeDefCall("gte", descriptor, 8, 0);
                    writejump = false;
                    break;
                }
                throw this.createError(new IllegalStateException("Illegal tree structure."));
            }
            default: {
                if (eq) {
                    if (this.right.isNull) {
                        writer.ifNull(jump);
                        break;
                    }
                    if (this.operation == Operation.EQ) {
                        writer.invokeStatic(WriterConstants.OBJECTS_TYPE, WriterConstants.EQUALS);
                        writejump = false;
                        break;
                    }
                    writer.ifCmp(this.promotedType.type, 153, jump);
                    break;
                }
                if (ne) {
                    if (this.right.isNull) {
                        writer.ifNonNull(jump);
                        break;
                    }
                    if (this.operation == Operation.NE) {
                        writer.invokeStatic(WriterConstants.OBJECTS_TYPE, WriterConstants.EQUALS);
                        writer.ifZCmp(153, jump);
                        break;
                    }
                    writer.ifCmp(this.promotedType.type, 154, jump);
                    break;
                }
                throw this.createError(new IllegalStateException("Illegal tree structure."));
            }
        }
        if (writejump) {
            writer.push(false);
            writer.goTo(end);
            writer.mark(jump);
            writer.push(true);
            writer.mark(end);
        }
    }
}

