/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless.node;

import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.painless.Definition;
import org.elasticsearch.painless.Globals;
import org.elasticsearch.painless.Locals;
import org.elasticsearch.painless.Location;
import org.elasticsearch.painless.MethodWriter;
import org.elasticsearch.painless.node.AExpression;

public final class ENewObj
extends AExpression {
    private final String type;
    private final List<AExpression> arguments;
    private Definition.Method constructor;

    public ENewObj(Location location, String type, List<AExpression> arguments) {
        super(location);
        this.type = Objects.requireNonNull(type);
        this.arguments = Objects.requireNonNull(arguments);
    }

    @Override
    void extractVariables(Set<String> variables) {
        for (AExpression argument : this.arguments) {
            argument.extractVariables(variables);
        }
    }

    @Override
    void analyze(Locals locals) {
        Definition.Type type;
        try {
            type = Definition.getType(this.type);
        }
        catch (IllegalArgumentException exception) {
            throw this.createError(new IllegalArgumentException("Not a type [" + this.type + "]."));
        }
        Definition.Struct struct = type.struct;
        this.constructor = struct.constructors.get(new Definition.MethodKey("<init>", this.arguments.size()));
        if (this.constructor != null) {
            Definition.Type[] types = new Definition.Type[this.constructor.arguments.size()];
            this.constructor.arguments.toArray(types);
            if (this.constructor.arguments.size() != this.arguments.size()) {
                throw this.createError(new IllegalArgumentException("When calling constructor on type [" + struct.name + "] expected [" + this.constructor.arguments.size() + "] arguments, but found [" + this.arguments.size() + "]."));
            }
            for (int argument = 0; argument < this.arguments.size(); ++argument) {
                AExpression expression = this.arguments.get(argument);
                expression.expected = types[argument];
                expression.internal = true;
                expression.analyze(locals);
                this.arguments.set(argument, expression.cast(locals));
            }
        } else {
            throw this.createError(new IllegalArgumentException("Unknown new call on type [" + struct.name + "]."));
        }
        this.statement = true;
        this.actual = type;
    }

    @Override
    void write(MethodWriter writer, Globals globals) {
        writer.writeDebugInfo(this.location);
        writer.newInstance(this.actual.type);
        if (this.read) {
            writer.dup();
        }
        for (AExpression argument : this.arguments) {
            argument.write(writer, globals);
        }
        writer.invokeConstructor(this.constructor.owner.type, this.constructor.method);
    }
}

