/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.publish;

import java.io.File;
import java.util.Date;
import org.gradle.api.internal.artifacts.publish.AbstractPublishArtifact;
import org.gradle.api.tasks.bundling.AbstractArchiveTask;
import org.gradle.util.GUtil;

public class ArchivePublishArtifact
extends AbstractPublishArtifact {
    private String name;
    private String extension;
    private String type;
    private String classifier;
    private Date date;
    private File file;
    private AbstractArchiveTask archiveTask;

    public ArchivePublishArtifact(AbstractArchiveTask archiveTask) {
        super(archiveTask);
        this.archiveTask = archiveTask;
    }

    public String getName() {
        if (this.name != null) {
            return this.name;
        }
        if (this.archiveTask.getBaseName() != null) {
            return this.withAppendix(this.archiveTask.getBaseName());
        }
        return this.archiveTask.getAppendix();
    }

    private String withAppendix(String baseName) {
        return baseName + (GUtil.isTrue((Object)this.archiveTask.getAppendix()) ? "-" + this.archiveTask.getAppendix() : "");
    }

    public String getExtension() {
        return (String)GUtil.elvis((Object)this.extension, (Object)this.archiveTask.getExtension());
    }

    public String getType() {
        return (String)GUtil.elvis((Object)this.type, (Object)this.archiveTask.getExtension());
    }

    public String getClassifier() {
        return (String)GUtil.elvis((Object)this.classifier, (Object)this.archiveTask.getClassifier());
    }

    public File getFile() {
        return (File)GUtil.elvis((Object)this.file, (Object)this.archiveTask.getArchivePath());
    }

    public Date getDate() {
        return (Date)GUtil.elvis((Object)this.date, (Object)new Date(this.archiveTask.getArchivePath().lastModified()));
    }

    public AbstractArchiveTask getArchiveTask() {
        return this.archiveTask;
    }

    public ArchivePublishArtifact setName(String name) {
        this.name = name;
        return this;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setClassifier(String classifier) {
        this.classifier = classifier;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public void setFile(File file) {
        this.file = file;
    }
}

