/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import java.util.HashMap;
import java.util.Map;
import org.gradle.api.internal.cache.HeapProportionalCacheSizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CacheCapSizer {
    private static final Map<String, Integer> DEFAULT_CAP_SIZES = new HashMap<String, Integer>();
    final HeapProportionalCacheSizer sizer;
    private final Map<String, Integer> capSizes;

    CacheCapSizer(int maxHeapMB) {
        this.sizer = maxHeapMB > 0 ? new HeapProportionalCacheSizer(maxHeapMB) : new HeapProportionalCacheSizer();
        this.capSizes = this.calculateCaps();
    }

    CacheCapSizer() {
        this(0);
    }

    private Map<String, Integer> calculateCaps() {
        HashMap<String, Integer> capSizes = new HashMap<String, Integer>();
        for (Map.Entry<String, Integer> entry : DEFAULT_CAP_SIZES.entrySet()) {
            capSizes.put(entry.getKey(), this.scaleCacheSize(entry.getValue()));
        }
        return capSizes;
    }

    protected int scaleCacheSize(int referenceValue) {
        return this.sizer.scaleCacheSize(referenceValue);
    }

    public Integer getMaxSize(String cacheName) {
        return this.capSizes.get(cacheName);
    }

    public int getNumberOfCaches() {
        return this.capSizes.size();
    }

    static {
        DEFAULT_CAP_SIZES.put("fileSnapshots", 10000);
        DEFAULT_CAP_SIZES.put("taskArtifacts", 2000);
        DEFAULT_CAP_SIZES.put("fileHashes", 400000);
        DEFAULT_CAP_SIZES.put("compilationState", 1000);
    }
}

