/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.cache;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.internal.tasks.cache.TaskCacheKey;
import org.gradle.api.internal.tasks.cache.TaskOutputCache;
import org.gradle.api.internal.tasks.cache.TaskOutputReader;
import org.gradle.api.internal.tasks.cache.TaskOutputWriter;

public class LocalDirectoryTaskOutputCache
implements TaskOutputCache {
    private final File directory;

    public LocalDirectoryTaskOutputCache(File directory) {
        if (directory.exists()) {
            if (!directory.isDirectory()) {
                throw new IllegalArgumentException(String.format("Cache directory %s must be a directory", directory));
            }
            if (!directory.canRead()) {
                throw new IllegalArgumentException(String.format("Cache directory %s must be readable", directory));
            }
            if (!directory.canWrite()) {
                throw new IllegalArgumentException(String.format("Cache directory %s must be writable", directory));
            }
        } else if (!directory.mkdirs()) {
            throw new UncheckedIOException(String.format("Could not create cache directory: %s", directory));
        }
        this.directory = directory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean load(TaskCacheKey key, TaskOutputReader reader) throws IOException {
        File file = this.getFile(key.getHashCode());
        if (file.isFile()) {
            FileInputStream stream = new FileInputStream(file);
            try {
                reader.readFrom(stream);
                boolean bl = true;
                return bl;
            }
            finally {
                stream.close();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(TaskCacheKey key, TaskOutputWriter result) throws IOException {
        File file = this.getFile(key.getHashCode());
        FileOutputStream output = new FileOutputStream(file);
        try {
            result.writeTo(output);
        }
        finally {
            ((OutputStream)output).close();
        }
    }

    private File getFile(String key) {
        return new File(this.directory, key);
    }

    public String getDescription() {
        return "local directory cache in " + this.directory;
    }
}

