/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.loaded.agent;

import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.springsource.loaded.FileChangeListener;
import org.springsource.loaded.GlobalConfiguration;
import org.springsource.loaded.ReloadableType;
import org.springsource.loaded.TypeRegistry;

public class ReloadableFileChangeListener
implements FileChangeListener {
    private static Logger log = Logger.getLogger(ReloadableFileChangeListener.class.getName());
    private TypeRegistry typeRegistry;
    private Map<File, ReloadableType> correspondingReloadableTypes = new HashMap<File, ReloadableType>();
    Map<File, Set<JarEntry>> watchedJarContents = new HashMap<File, Set<JarEntry>>();

    public ReloadableFileChangeListener(TypeRegistry typeRegistry) {
        this.typeRegistry = typeRegistry;
    }

    public void fileChanged(File file) {
        if (GlobalConfiguration.isRuntimeLogging && log.isLoggable(Level.INFO)) {
            log.info(" processing change for " + file);
        }
        ReloadableType rtype = this.correspondingReloadableTypes.get(file);
        if (file.getName().endsWith(".jar")) {
            if (GlobalConfiguration.isRuntimeLogging && log.isLoggable(Level.INFO)) {
                log.info(" processing change for JAR " + file);
            }
            try {
                ZipFile zf = new ZipFile(file);
                Set<JarEntry> entriesBeingWatched = this.watchedJarContents.get(file);
                for (JarEntry entryBeingWatched : entriesBeingWatched) {
                    ZipEntry ze = zf.getEntry(entryBeingWatched.slashname);
                    long lmt = ze.getTime();
                    if (lmt <= entryBeingWatched.lmt) continue;
                    if (GlobalConfiguration.isRuntimeLogging && log.isLoggable(Level.INFO)) {
                        log.info(" detected update to jar entry. jar=" + file.getName() + " class=" + entryBeingWatched.slashname + "  OLD LMT=" + new Date(entryBeingWatched.lmt) + " NEW LMT=" + new Date(lmt));
                    }
                    this.typeRegistry.loadNewVersion(entryBeingWatched.rtype, lmt, zf.getInputStream(ze));
                    entryBeingWatched.lmt = lmt;
                }
                zf.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            this.typeRegistry.loadNewVersion(rtype, file);
        }
    }

    public void register(ReloadableType rtype, File file) {
        if (file.getName().endsWith(".jar")) {
            try {
                ZipFile zf = new ZipFile(file);
                String slashname = rtype.getSlashedName() + ".class";
                ZipEntry ze = zf.getEntry(slashname);
                long lmt = ze.getTime();
                JarEntry je = new JarEntry(rtype, slashname, lmt);
                zf.close();
                Set<JarEntry> jarEntries = this.watchedJarContents.get(file);
                if (jarEntries == null) {
                    jarEntries = new HashSet<JarEntry>();
                    this.watchedJarContents.put(file, jarEntries);
                }
                jarEntries.add(je);
                if (GlobalConfiguration.isRuntimeLogging && log.isLoggable(Level.INFO)) {
                    log.info(" watching jar file entry. Jar=" + file + "  file=" + rtype.getSlashedName() + " lmt=" + lmt);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            this.correspondingReloadableTypes.put(file, rtype);
        }
    }

    static class JarEntry {
        final ReloadableType rtype;
        final String slashname;
        long lmt;

        public JarEntry(ReloadableType rtype, String slashname, long lmt) {
            this.rtype = rtype;
            this.slashname = slashname;
            this.lmt = lmt;
        }
    }
}

